document.addEventListener('DOMContentLoaded', function () {
    // Recuperar los colores guardados de PHP a JavaScript
    var pinesShapeColor = pinesColors.shapeColor || '#89849b';
    var pinesTextColor = pinesColors.textColor || '#837B72';

    // Crear una nueva hoja de estilos
    var styleSheet = document.createElement("style");
    styleSheet.type = "text/css";
    document.head.appendChild(styleSheet);

    // Función para actualizar los colores en tiempo real
    function updateColors(shapeColor, textColor) {
        var cssRuleShape = `.xpin { background: ${shapeColor}; }`;
        var cssRuleText = `.jo-pin-text { color: ${textColor}; }`;

        if (styleSheet.styleSheet) {
            styleSheet.styleSheet.cssText = cssRuleShape + cssRuleText; // IE
        } else {
            styleSheet.innerHTML = cssRuleShape + cssRuleText; // Otros navegadores
        }
    }

    // Actualizar los colores con los valores guardados al cargar la página
    updateColors(pinesShapeColor, pinesTextColor);

    // Agregar eventos input para actualizar los colores en tiempo real cuando el usuario cambia los valores
    document.getElementById('pines_shape_color').addEventListener('input', function () {
        pinesShapeColor = this.value;
        updateColors(pinesShapeColor, pinesTextColor);
    });

    document.getElementById('pines_text_color').addEventListener('input', function () {
        pinesTextColor = this.value;
        updateColors(pinesShapeColor, pinesTextColor);
    });
});
