 /**
     * Manages the hide and show feature of the tabs in main settings, color settings, etc
     */
 document.addEventListener('DOMContentLoaded', function () {
    var i, tabcontent, tablinks;
    //get all tab btns
    tablinks = document.getElementsByClassName('tablinks');

    for (var i = 0; i < tablinks.length; i++) {
        //event for each tab when clicked
        tablinks[i].addEventListener('click', function (e) {
            //remove the active class (displays the tab) from all the tablinks
            for (var i = 0; i < tablinks.length; i++) {
                tablinks[i].classList.remove('tbl-active');
            }
            //add the class only to the clicked tab
            this.classList.add('tbl-active');
            
            //get the attribute that indicates which content should be displayed (tabcontent)
            var currentTab = this.getAttribute('data-selected');
            //console.log(currentTab);

            var tabs = document.getElementsByClassName('tabcontent');
            for (i = 0; i < tabs.length; i++) {
                tabs[i].classList.remove('active')
                tabs[i].classList.add('inactive');
            }
            //show only the corresponding tabcontent
            document.getElementById(currentTab).classList.replace('inactive', 'active');

        });
    };
});