<?php
/**
 * Plugin Name: Store-IT - Contact
 * Plugin URI: https://store-it.eu/store356-de-software/
 * Description: Plaats een Store-IT contactformulier op de website
 * Version: 1.0.0
 * Requires at least: 5.0
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * Author: Store-IT
 * Author URI: https://store-it.eu/
 * Text Domain: store-it-contact
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
    exit;
}

define('STOREIT_CONTACT_VERSION', '1.0.0');
define('STOREIT_CONTACT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('STOREIT_CONTACT_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/Plugin.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/models/StoreItContactFormsManager.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/models/StoreItContactSubmissionsManager.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/controllers/StoreItContactAdmin.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/controllers/StoreItContactShortcodes.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/services/StoreItAPIClient.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/services/SubmissionSyncService.php';
require_once STOREIT_CONTACT_PLUGIN_DIR . 'includes/controllers/LanguageController.php';
/**
 * Initialize the plugin
 */
function store_it_contact_init() {
    $plugin = new StoreItContactPlugin();
    $plugin->init();
}
add_action('init', 'store_it_contact_init', 0);