<?php
if (!defined('ABSPATH')) {
    exit;
}

$fieldStyle = sprintf(
    'background-color: %s; border: 1px solid %s; color: %s; font-size: %dpx; padding: 8px; width: 100%%; box-sizing: border-box; border-radius: %dpx;',
    esc_attr($bgColor),
    esc_attr($borderColor),
    esc_attr($textColor),
    $fontSize,
    $borderRadius
);

$buttonStyle = sprintf(
    'background-color: %s; color: %s; padding: 8px 14px; border: none; cursor: pointer; border-radius: %dpx; font-size: %dpx;',
    esc_attr($accentColor),
    esc_attr($accentContrastColor), 
    esc_attr($borderRadius),
    $fontSize
);

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only status check, no form processing
if (isset($_GET['store_it_form_submit_success']) && isset($_GET['store_it_contact_form_id']) && $_GET['store_it_contact_form_id'] == $formId): 
    $successMessage = !empty($formDataForView['notifications']['success_message']) ? 
        $formDataForView['notifications']['success_message'] : 
        __('Thank you! Your message has been submitted.', 'store-it-contact');
    ?>
    <div class="store-it-contact-form-success-message" id="success-store-it-contact-form-<?php echo esc_attr($formId); ?>" style="font-size: <?php echo intval($fontSize); ?>px;">
        <?php echo esc_html($successMessage); ?>
    </div>
        
<?php endif; ?>

<?php 
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only status check, no form processing
if (isset($_GET['store_it_form_submit_error']) && isset($_GET['store_it_contact_form_id']) && $_GET['store_it_contact_form_id'] == $formId):
    $errorDetails = get_transient('store_it_contact_form_error_' . $formId);
    $errorMessage = !empty($formDataForView['notifications']['default_error_message']) ? 
        $formDataForView['notifications']['default_error_message'] : 
        __('An error occurred while submitting the form. Please try again later.', 'store-it-contact');

    ?>
    <div 
        class="store-it-contact-form-error-message" style="font-size: <?php echo intval($fontSize); ?>px;" 
        id="error-store-it-contact-form-<?php echo esc_attr($formId); ?>"
        data-error-details="<?php echo esc_attr($errorDetails); ?>"
    >
        <?php echo esc_html($errorMessage); ?>
    </div>
<?php endif; ?>

<?php 
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only check, no form processing
if (!isset($_GET['store_it_form_submit'])): 
?>

    <div class="store-it-contact-form-<?php echo esc_attr($formId); ?>" id="store-it-contact-form-<?php echo esc_attr($formId); ?>">
        <h3 style="color: <?php echo esc_attr($textColor); ?>;"><?php echo esc_html($title); ?></h3>

        <!-- Render fields in the configured order -->
        <form method="post">
            <!-- New hidden inputs to identify the submission -->
            <input type="hidden" name="store_it_contact_form_id" value="<?php echo esc_attr($formId); ?>" />
            <input type="hidden" name="store_it_contact_submit_flag" value="1" />
            <?php wp_nonce_field('store_it_contact_form_' . $formId, 'store_it_contact_nonce'); ?>

            <?php

            foreach ($fields as $fieldId => $fieldConf) {
                // If not "visible", skip
                if (!isset($fieldConf['visible']) || $fieldConf['visible'] !== 'visible') {
                    continue;
                }

                // Extract field data
                $label       = isset($fieldConf['label'])       ? $fieldConf['label']       : $fieldId;
                $required    = (!empty($fieldConf['required']) && $fieldConf['required'] === 'required');
                $placeholder = isset($fieldConf['placeholder']) ? $fieldConf['placeholder'] : '';
                $desc        = isset($fieldConf['description']) ? $fieldConf['description'] : '';

                // Build a name attribute from the field_id
                $inputName = 'store_it_' . esc_attr($fieldId);
                $reqAttr   = $required ? 'required' : '';

                // Decide input type based on the field_id
                switch ($fieldId) {
                    case 'request_type':
                        ?>
                            <p class="store-it-contact-form-field">
                                <?php if (count($availableTaskTypes) === 1) : ?>
                                    <!-- When only one request type exists, auto-select it and hide the dropdown -->
                                    <input 
                                        type="hidden" 
                                        name="<?php echo esc_attr($inputName); ?>" 
                                        value="<?php echo esc_attr($availableTaskTypes[0]['typeId']); ?>" 
                                    />
                                <?php else : ?>
                                    <!-- Normal dropdown whenmultiple request types exist -->
                                    <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                                    <?php if (!empty($desc)) : ?>
                                        <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                                    <?php endif; ?>
                                    <select
                                        name="<?php echo esc_attr($inputName); ?>"
                                        <?php echo esc_attr($reqAttr); ?>
                                        style="<?php echo esc_attr($fieldStyle); ?>"
                                        id="<?php echo esc_attr($inputName); ?>"
                                    >
                                        <option value=""><?php echo esc_html($placeholder ?: __('Select an option', 'store-it-contact')); ?></option>
                                        <?php 
                                        if (!empty($availableTaskTypes)) {
                                            foreach ($availableTaskTypes as $type) {
                                                echo '<option value="' . esc_attr($type['typeId']) . '">' 
                                                    . esc_html($type['description']) 
                                                    . '</option>';
                                            }
                                        }
                                        ?>
                                    </select>
                                <?php endif; ?>
                            </p>
                        <?php
                        break;

                    case 'title_field': 
                        ?>
                            <p class="store-it-contact-form-field">
                                <?php if (count($allTitleTypes) === 1) : ?>
                                    <!-- When only one request type exists, auto-select it and hide the dropdown -->
                                    <input 
                                        type="hidden" 
                                        name="<?php echo esc_attr($inputName); ?>" 
                                        value="<?php echo esc_attr($allTitleTypes[0]['code']); ?>" 
                                    />
                                <?php else : ?>
                                    <!-- Normal dropdown when multiple request types exist -->
                                    <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                                    <?php if (!empty($desc)) : ?>
                                        <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                                    <?php endif; ?>
                                    <select
                                        name="<?php echo esc_attr($inputName); ?>"
                                        <?php echo esc_attr($reqAttr); ?>
                                        style="<?php echo esc_attr($fieldStyle); ?>"
                                        id="<?php echo esc_attr($inputName); ?>"
                                    >
                                        <option value=""><?php echo esc_html($placeholder ?: __('Select an option', 'store-it-contact')); ?></option>
                                        <?php 
                                        if (!empty($allTitleTypes)) {
                                            foreach ($allTitleTypes as $type) {
                                                echo '<option value="' . esc_attr($type['code']) . '">' 
                                                    . esc_html($type['description']) 
                                                    . '</option>';
                                            }
                                        }
                                        ?>
                                    </select>
                                <?php endif; ?>
                            </p>
                        <?php
                        break;

                    case 'message_field':
                        // Textarea field
                        ?>
                        <p class="store-it-contact-form-field">
                            <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                            <?php if (!empty($desc)) : ?>
                                <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                            <?php endif; ?>
                            <textarea
                                name="<?php echo esc_attr($inputName); ?>"
                                id="<?php echo esc_attr($inputName); ?>"
                                placeholder="<?php echo esc_attr($placeholder); ?>"
                                <?php echo esc_attr($reqAttr); ?>
                                style="<?php echo esc_attr($fieldStyle); ?> min-height: 150px; resize: vertical;"
                            ></textarea>
                        </p>
                        <?php
                        break;

                    case 'submit_button':
                        ?>
                        <p class="store-it-contact-form-field">
                            <button type="submit" class="store-it-contact-form-<?php echo esc_attr($formId); ?>-submit-button" style="<?php echo esc_attr($buttonStyle); ?> font-weight: 500;">
                                <?php echo esc_html($label) ?: esc_html($submitLabel); ?>
                            </button>
                        </p>
                        <?php
                        break;

                    case 'email':
                        // An email input
                        ?>
                        <p class="store-it-contact-form-field">
                            <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                            <?php if (!empty($desc)) : ?>
                                <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                            <?php endif; ?>
                            <input
                                type="email"
                                name="<?php echo esc_attr($inputName); ?>"
                                id="<?php echo esc_attr($inputName); ?>"
                                placeholder="<?php echo esc_attr($placeholder); ?>"
                                <?php echo esc_attr($reqAttr); ?>
                                style="<?php echo esc_attr($fieldStyle); ?>"
                            />
                        </p>
                        <?php
                        break;

                    case 'phone_number':
                        ?>
                            <p class="store-it-contact-form-field">
                                <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                                <?php if (!empty($desc)) : ?>
                                    <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                                <?php endif; ?>
                                <input
                                    type="tel"
                                    name="<?php echo esc_attr($inputName); ?>"
                                    id="<?php echo esc_attr($inputName); ?>"
                                    placeholder="<?php echo esc_attr($placeholder); ?>"
                                    <?php echo esc_attr($reqAttr); ?>
                                    pattern="^\+?\d{7,15}$"
                                    oninvalid="this.setCustomValidity('Please enter a valid value')"
                                    oninput="this.setCustomValidity('')"
                                    style="<?php echo esc_attr($fieldStyle); ?>"
                                />
                            </p>
                        <?php
                        break;

                    case 'location':
                        ?>
                        <p class="store-it-contact-form-field">
                            <?php if (count($availableFacilities) === 1) : ?>
                                <!-- When only one location exists, auto-select it and hide the dropdown -->
                                <input 
                                    type="hidden" 
                                    name="<?php echo esc_attr($inputName); ?>" 
                                    value="<?php echo esc_attr($availableFacilities[0]['siteCode']); ?>" 
                                />
                            <?php else : ?>
                                <!-- Normal dropdown when multiple locations exist -->
                                <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                                <?php if (!empty($desc)) : ?>
                                    <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                                <?php endif; ?>
                                <select
                                    name="<?php echo esc_attr($inputName); ?>"
                                    <?php echo esc_attr($reqAttr); ?>
                                    style="<?php echo esc_attr($fieldStyle); ?>"
                                    id="<?php echo esc_attr($inputName); ?>"
                                >
                                    <option value=""><?php echo esc_html($placeholder ?: __('Select a location', 'store-it-contact')); ?></option>
                                    <?php 
                                    if (!empty($availableFacilities)) {
                                        foreach ($availableFacilities as $facility) {
                                            echo '<option value="' . esc_attr($facility['siteCode']) . '">' 
                                                . esc_html($facility['description']) 
                                                . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            <?php endif; ?>
                        </p>
                        <?php
                        break;

                    case 'recaptcha':   
                        if (!empty($recaptchaSiteKey) && !empty($recaptchaSecretKey)) {
                            ?>
                                <p class="g-recaptcha-error">
                                    <?php echo esc_html__('Please complete the reCAPTCHA verification', 'store-it-contact'); ?>
                                </p>

                                <div class="g-recaptcha" data-sitekey="<?php echo esc_attr($recaptchaSiteKey); ?>"></div>
                            <?php
                        }
                        break;

                    default:
                        // Generic text input
                        ?>
                        <p class="store-it-contact-form-field">
                            <label for="<?php echo esc_attr($inputName); ?>" style="display: block; margin-bottom: 5px; color: <?php echo esc_attr($textColor); ?>; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($label); ?><?php echo $required ? ' *' : ''; ?></label>
                            <?php if (!empty($desc)) : ?>
                                <small style="color: <?php echo esc_attr($textColor); ?>; opacity: 0.8; display: block; margin-bottom: 5px; font-size: <?php echo intval($fontSize); ?>px;"><?php echo esc_html($desc); ?></small>
                            <?php endif; ?>
                            <input
                                type="text"
                                name="<?php echo esc_attr($inputName); ?>"
                                id="<?php echo esc_attr($inputName); ?>"
                                placeholder="<?php echo esc_attr($placeholder); ?>"
                                <?php echo esc_attr($reqAttr); ?>
                                style="<?php echo esc_attr($fieldStyle); ?>"
                            />
                        </p>
                        <?php
                        break;
                }
            }
            ?>
        </form>
    </div>
<?php endif; ?>