<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <h1><?php esc_html_e('Store IT Contact Forms', 'store-it-contact'); ?></h1>

    <?php 
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only admin notice, no form processing
    if (isset($_GET['duplicated']) && $_GET['duplicated'] == '1') : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Form has been successfully duplicated.', 'store-it-contact'); ?></p>
        </div>
    <?php endif; ?>

    <?php 
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only admin notice, no form processing
    if (isset($_GET['error']) && $_GET['error'] == '1') : ?>
        <div class="notice notice-error is-dismissible">
            <p><?php esc_html_e('Error duplicating form. Please try again.', 'store-it-contact'); ?></p>
        </div>
    <?php endif; ?>

    <!-- Add New Form button -->
    <a href="<?php echo esc_url(admin_url('admin.php?page=store-it-contact-edit')); ?>" class="button-primary">
        <?php esc_html_e('Add New', 'store-it-contact'); ?>
    </a>

    <?php if (!empty($forms)) : ?>
        <table class="widefat striped" style="margin-top: 20px;">
            <thead>
                <tr>
                    <th><?php esc_html_e('Form Name', 'store-it-contact'); ?></th>
                    <th><?php esc_html_e('Shortcode', 'store-it-contact'); ?></th>
                    <th><?php esc_html_e('Actions', 'store-it-contact'); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($forms as $id => $formData) : ?>
                <tr>
                    <td>
                        <?php echo esc_html($formData['name']); ?>
                    </td>
                    <td>
                        <code>[store_it_contact_form id="<?php echo esc_attr($id); ?>"]</code>
                    </td>
                    <td>
                        <a class="button" href="<?php echo esc_url(admin_url('admin.php?page=store-it-contact-edit&form_id=' . urlencode($id))); ?>">
                            <?php esc_html_e('Edit', 'store-it-contact'); ?>
                        </a>
                        <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=store-it-contact&action=duplicate&form_id=' . urlencode($id))); ?>">
                            <?php esc_html_e('Duplicate', 'store-it-contact'); ?>
                        </a>
                        <a class="button button-secondary" style="color:red;"
                           href="<?php echo esc_url(admin_url('admin.php?page=store-it-contact&action=delete&form_id=' . urlencode($id))); ?>"
                           onclick="return confirm('<?php esc_attr_e('Are you sure you want to delete this form?', 'store-it-contact'); ?>');">
                            <?php esc_html_e('Delete', 'store-it-contact'); ?>
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php else : ?>
        <p><?php esc_html_e('No forms found.', 'store-it-contact'); ?></p>
    <?php endif; ?>
</div>