<?php
if (!defined('ABSPATH')) {
    exit;
}

// Utility function for building tab URLs
function store_it_global_tab_url($tabKey) {
    $base = admin_url('admin.php?page=store-it-contact-global-settings');
    return add_query_arg(['tab' => $tabKey], $base);
}
?>

<div class="wrap">
    <h1><?php esc_html_e('Store-IT Global Settings', 'store-it-contact'); ?></h1>

    <?php
    // Display settings errors/messages
    settings_errors('store_it_contact_messages');
    ?>

    <!-- Tab navigation -->
    <h2 class="nav-tab-wrapper">
        <a href="<?php echo esc_url(store_it_global_tab_url('general')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'general') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('General', 'store-it-contact'); ?>
        </a>
        <a href="<?php echo esc_url(store_it_global_tab_url('sync')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'sync') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Sync', 'store-it-contact'); ?>
        </a>
        <a href="<?php echo esc_url(store_it_global_tab_url('recaptcha')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'recaptcha') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('reCAPTCHA', 'store-it-contact'); ?>
        </a>
    </h2>

    <?php 
        if($activeTab === 'general'):
            ?>
                <!-- GENERAL TAB -->
                <form method="post">
                    <?php wp_nonce_field('store_it_global_settings_form', 'store_it_global_settings_nonce'); ?>

                    <table class="form-table">
                        <tr>
                            <th>
                                <label for="base_url"><?php esc_html_e('Base URL', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input type="text" name="base_url" id="base_url" 
                                    value="<?php echo esc_attr($globalSettings['base_url']); ?>"
                                    placeholder="https://api.store-it365.eu"
                                    class="regular-text" required>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="username"><?php esc_html_e('Username', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input type="text" name="username" id="username" 
                                    value="<?php echo esc_attr($globalSettings['username']); ?>" 
                                    class="regular-text" required>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="password"><?php esc_html_e('Password', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input type="password" name="password" id="password" 
                                    value="<?php echo esc_attr($globalSettings['password']); ?>" 
                                    class="regular-text" required>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="grant_type"><?php esc_html_e('Grant Type', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input type="text" name="grant_type" id="grant_type"
                                    value="<?php echo esc_attr($globalSettings['grant_type']); ?>" 
                                    placeholder="password"
                                    class="regular-text" required>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label for="client_id"><?php esc_html_e('Client ID', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input type="text" name="client_id" id="client_id"
                                    value="<?php echo esc_attr($globalSettings['client_id']); ?>" 
                                    class="regular-text" required>
                            </td>
                        </tr>
                    </table>

                    <?php submit_button(__('Save Settings', 'store-it-contact')); ?>
                </form>
            <?php
        elseif ($activeTab === 'sync'):
            ?>
            <!-- SYNC TAB -->
                <form method="post">
                    <?php wp_nonce_field('store_it_global_settings_form', 'store_it_global_settings_nonce'); ?>
                    
                    <p>
                        <strong><?php esc_html_e('Last Sync:', 'store-it-contact'); ?></strong>
                        <?php 
                        if (!empty($globalSettings['last_sync_timestamp'])) {
                            echo esc_html($globalSettings['last_sync_timestamp']);
                        } else {
                            esc_html_e('No sync has been performed yet.', 'store-it-contact');
                        }
                        ?>
                    </p>

                    <table class="form-table">
                        <tr>
                            <th><label><?php esc_html_e('Fetched Facilities', 'store-it-contact'); ?></label></th>
                            <td>
                                <textarea readonly rows="5" style="width:100%;">
                                <?php 
                                    // Format the facilities_data properly
                                    $facilitiesData = isset($globalSettings['facilities_data']) ? $globalSettings['facilities_data'] : '';
                                    if (is_array($facilitiesData)) {
                                        echo esc_textarea(json_encode($facilitiesData, JSON_PRETTY_PRINT));
                                    } else {
                                        echo esc_textarea($facilitiesData);
                                    }
                                ?>
                                </textarea>
                                <p class="description">
                                    <?php esc_html_e('Data returned from the API request to /v1/api/facilities.', 'store-it-contact'); ?>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <th><label><?php esc_html_e('Fetched Title Types', 'store-it-contact'); ?></label></th>
                            <td>
                                <textarea readonly rows="5" style="width:100%;">
                                    <?php 
                                        // Format the title_types_data properly
                                        $titleTypesData = isset($globalSettings['title_types_data']) ? $globalSettings['title_types_data'] : '';
                                        if (is_array($titleTypesData)) {
                                            echo esc_textarea(json_encode($titleTypesData, JSON_PRETTY_PRINT));
                                        } else {
                                            echo esc_textarea($titleTypesData);
                                        }
                                    ?>
                                </textarea>
                                <p class="description">
                                    <?php esc_html_e('Data returned from the API request to /v1/api/titleTypes.', 'store-it-contact'); ?>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <th><label><?php esc_html_e('Fetched Task Types', 'store-it-contact'); ?></label></th>
                            <td>
                                <textarea readonly rows="5" style="width:100%;">
                                <?php 
                                    // Format the task_types_data properly
                                    $taskTypesData = isset($globalSettings['task_types_data']) ? $globalSettings['task_types_data'] : '';
                                    if (is_array($taskTypesData)) {
                                        echo esc_textarea(json_encode($taskTypesData, JSON_PRETTY_PRINT));
                                    } else {
                                        echo esc_textarea($taskTypesData);
                                    }
                                ?>
                                </textarea>
                                <p class="description">
                                    <?php esc_html_e('Data returned from the API request to /v2/api/tasktypes.', 'store-it-contact'); ?>
                                </p>
                            </td>
                        </tr>
                    </table>

                    <?php
                        $hasCreds = (
                            !empty($globalSettings['base_url']) &&
                            !empty($globalSettings['username']) &&
                            !empty($globalSettings['password']) &&
                            !empty($globalSettings['grant_type']) &&
                            !empty($globalSettings['client_id'])
                        );
                    ?>
                    <button type="submit" class="button button-primary"
                            <?php disabled(!$hasCreds); ?>>
                        <?php esc_html_e('Synchronize', 'store-it-contact'); ?>
                    </button>
                </form>
            <?php
        elseif ($activeTab === 'recaptcha'):
            ?>
                <!-- RECAPTCHA TAB -->
                <form method="post">
                    <?php wp_nonce_field('store_it_global_settings_form', 'store_it_global_settings_nonce'); ?>

                    <table class="form-table">
                        <tr>
                            <th>
                                <label for="recaptcha_site_key"><?php esc_html_e('reCAPTCHA Site Key', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input 
                                    type="text" 
                                    name="recaptcha_site_key" 
                                    id="recaptcha_site_key"
                                    value="<?php echo esc_attr($globalSettings['recaptcha_site_key']); ?>"
                                    class="regular-text" 
                                />
                            </td>
                        </tr>       
                    </table>

                    <table class="form-table">
                        <tr>
                            <th>
                                <label for="recaptcha_secret_key"><?php esc_html_e('reCAPTCHA Secret Key', 'store-it-contact'); ?></label>
                            </th>
                            <td>
                                <input 
                                    type="text" 
                                    name="recaptcha_secret_key" 
                                    id="recaptcha_secret_key"
                                    value="<?php echo esc_attr($globalSettings['recaptcha_secret_key']); ?>"
                                    class="regular-text" 
                                />
                            </td>
                        </tr>
                    </table>

                    <?php submit_button(__('Save Settings', 'store-it-contact')); ?>
                </form>
            <?php
        endif;
    ?>
</div> 