<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap store-it-contact-edit-page">
    <?php 
    // Utility to build tab URLs
    function store_it_contact_tab_url($formId, $tabKey) {
        $base = admin_url('admin.php?page=store-it-contact-edit');
        $args = array('form_id' => $formId, 'tab' => $tabKey);
        return add_query_arg($args, $base);
    }

    $activeTab = $tab; // from the controller
    ?>
    <h1>
        <?php echo $editMode ? esc_html__('Edit Form', 'store-it-contact') : esc_html__('Add New Form', 'store-it-contact'); ?>
    </h1>

    <?php if ($editMode) : ?>
        <p><?php esc_html_e('Shortcode:', 'store-it-contact'); ?> 
            <code>[store_it_contact_form id="<?php echo esc_attr($formId); ?>"]</code>
        </p>
    <?php endif; ?>

    <?php 
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Display-only admin notice, no form processing
    if (isset($_GET['updated'])) : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Form saved successfully.', 'store-it-contact'); ?></p>
        </div>
    <?php endif; ?>

    <!-- TABS -->
    <h2 class="nav-tab-wrapper">
        <a href="<?php echo esc_url(store_it_contact_tab_url($formId, 'settings')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'settings') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Settings', 'store-it-contact'); ?>
        </a>
        <a href="<?php echo esc_url(store_it_contact_tab_url($formId, 'styling')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'styling') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Styling', 'store-it-contact'); ?>
        </a>
        <a href="<?php echo esc_url(store_it_contact_tab_url($formId, 'fields')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'fields') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Fields', 'store-it-contact'); ?>
        </a>
        <!-- New Notifications tab -->
        <a href="<?php echo esc_url(store_it_contact_tab_url($formId, 'notifications')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'notifications') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Notifications', 'store-it-contact'); ?>
        </a>
        <!-- New tab for Entries -->
        <?php if ($editMode): ?>
        <a href="<?php echo esc_url(store_it_contact_tab_url($formId, 'entries')); ?>" 
           class="nav-tab <?php echo ($activeTab === 'entries') ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Entries', 'store-it-contact'); ?>
        </a>
        <?php endif; ?>
    </h2>

    <?php
    // Render the content depending on $activeTab

    // =========== SETTINGS TAB ===========
    if ($activeTab === 'settings'): ?>
        <form method="post">
            <?php wp_nonce_field('store_it_contact_edit_form', 'store_it_contact_edit_form_nonce'); ?>

            <h2><?php esc_html_e('Basic Settings', 'store-it-contact'); ?></h2>
            <table class="form-table">
                <tr>
                    <th>
                        <label for="name"><?php esc_html_e('Form Name', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <input type="text" name="name" id="name" value="<?php echo esc_attr($name); ?>" 
                            class="regular-text" required>
                    </td>
                </tr>

                <tr>
                    <th>
                        <label for="title"><?php esc_html_e('Form Title', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <input type="text" name="title" id="title" value="<?php echo esc_attr($title); ?>" 
                            class="regular-text" required>
                    </td>
                </tr>
                <!-- Success message moved to Notifications tab -->
                <tr>
                    <th>
                        <label for="language"><?php esc_html_e('Language', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <select name="language" id="language">
                            <option value="en" <?php selected($language, 'en'); ?>><?php esc_html_e('English', 'store-it-contact'); ?></option>
                            <option value="nl" <?php selected($language, 'nl'); ?>><?php esc_html_e('Dutch', 'store-it-contact'); ?></option>
                            <option value="de" <?php selected($language, 'de'); ?>><?php esc_html_e('German', 'store-it-contact'); ?></option>
                            <option value="fr" <?php selected($language, 'fr'); ?>><?php esc_html_e('French', 'store-it-contact'); ?></option>
                            <option value="it" <?php selected($language, 'it'); ?>><?php esc_html_e('Italian', 'store-it-contact'); ?></option>
                            <option value="es" <?php selected($language, 'es'); ?>><?php esc_html_e('Spanish', 'store-it-contact'); ?></option>
                            <option value="fi" <?php selected($language, 'fi'); ?>><?php esc_html_e('Finnish', 'store-it-contact'); ?></option>
                        </select>
                    </td>
                </tr>
            </table>

            <h2><?php esc_html_e('Request Types', 'store-it-contact'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><label><?php esc_html_e('Options', 'store-it-contact'); ?></label></th>
                    <td>
                        <div id="request-types-error" style="display: none; color: #dc3232; margin-bottom: 10px; font-size: 13px;">
                            <?php echo esc_html__('Please select at least one request type.', 'store-it-contact'); ?>
                        </div>
                        <fieldset>
                            <?php
                            if (is_array($taskTypes) && !empty($taskTypes)) {
                                foreach ($taskTypes as $taskType) {
                                    $ttId = (string)$taskType['typeId'];
                                    $ttDesc = $taskType['description'];

                                    $isChecked = in_array($ttId, $requestTypes, true);
                                    ?>
                                    <label style="display:block; margin-bottom:6px;">
                                        <input type="checkbox"
                                               name="request_types[]"
                                               value="<?php echo esc_attr($ttId); ?>"
                                               <?php checked($isChecked); ?> />
                                        <?php echo esc_html($ttDesc); ?>
                                    </label>
                                    <?php
                                }
                            } else {
                                echo '<p>' . esc_html__('No task types found. Please synchronize first.', 'store-it-contact') . '</p>';
                            }
                            ?>
                        </fieldset>
                    </td>
                </tr>
            </table>
            
            <h2><?php esc_html_e('Locations', 'store-it-contact'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><label><?php esc_html_e('Options', 'store-it-contact'); ?></label></th>
                    <td>
                        <div id="location-error" style="display: none; color: #dc3232; margin-bottom: 10px; font-size: 13px;">
                            <?php echo esc_html__('Please select at least one location.', 'store-it-contact'); ?>
                        </div>
                        <fieldset>
                            <?php
                            if (is_array($facilities) && !empty($facilities)) {
                                foreach ($facilities as $facility) {
                                    $facilityId = (string)$facility['siteCode'];
                                    $facilityDesc = $facility['description'];

                                    $isChecked = in_array($facilityId, $locations, true);
                                    ?>
                                    <label style="display:block; margin-bottom:6px;">
                                        <input 
                                            type="checkbox"
                                            name="locations[]"
                                            value="<?php echo esc_attr($facilityId); ?>"
                                            <?php checked($isChecked); ?>
                                        />
                                        <?php echo esc_html($facilityDesc); ?>
                                    </label>
                                    <?php
                                }
                            } else {
                                echo '<p>' . esc_html__('No locations found. Please synchronize first.', 'store-it-contact') . '</p>';
                            }
                            ?>
                        </fieldset>
                    </td>
                </tr>
                <tr>
                    <th><label for="other_name"><?php esc_html_e('Custom text for "other"', 'store-it-contact'); ?></label></th>
                    <td>
                        <div style="display: flex; gap: 10px; align-items: flex-start;">
                            <div>
                                <input 
                                    type="text" 
                                    name="other_name" 
                                    id="other_name"
                                    value="<?php echo esc_attr(isset($other_name) ? $other_name : 'other'); ?>"
                                    class="regular-text"
                                />
                                <p class="description"><?php esc_html_e('Customize the display text for the "other" option.', 'store-it-contact'); ?></p>
                                <div id="other-name-error" style="display: none; color: #dc3232; margin-top: 5px; font-size: 13px;">
                                    <?php echo esc_html__('Please enter a name for the "other" option.', 'store-it-contact'); ?>
                                </div>
                            </div>
                            <div>
                                <select 
                                    name="other_facility_standin" 
                                    id="other_facility_standin" 
                                    class="regular-text" 
                                >
                                    <option value=""><?php esc_html_e('Select a facility standin', 'store-it-contact'); ?></option>
                                    <?php 
                                    if (is_array($facilities) && !empty($facilities)) {
                                        foreach ($facilities as $facility) {
                                            // Skip the 'other' option itself
                                            if ($facility['siteCode'] === 'other') continue;
                                            
                                            $facilityId = (string)$facility['siteCode'];
                                            $facilityDesc = $facility['description'];
                                            $isSelected = isset($other_facility_standin) && $other_facility_standin === $facilityId;
                                            ?>
                                            <option value="<?php echo esc_attr($facilityId); ?>" <?php selected($isSelected); ?>>
                                                <?php echo esc_html($facilityDesc); ?>
                                            </option>
                                    <?php
                                        }
                                    }
                                    ?>
                                </select>
                                <p class="description"><?php esc_html_e('Select which facility to use as a standin when "other" is submitted.', 'store-it-contact'); ?></p>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>


            <?php submit_button($editMode ? __('Save Changes', 'store-it-contact') : __('Create Form', 'store-it-contact')); ?>
        </form>

    <?php 
    // =========== STYLING TAB ===========
    elseif ($activeTab === 'styling'): ?>
        <form method="post">
            <?php wp_nonce_field('store_it_contact_edit_form', 'store_it_contact_edit_form_nonce'); ?>

            <h2><?php esc_html_e('Styling Settings', 'store-it-contact'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><label for="font_size"><?php esc_html_e('Font Size (px)', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="number" step="1" min="8" name="font_size" id="font_size" 
                            value="<?php echo esc_attr($styling['font_size']); ?>" 
                            class="small-text">
                    </td>
                </tr>
                <tr>
                    <th><label for="border_radius"><?php esc_html_e('Field Border Radius (px)', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="number" step="1" min="0" name="border_radius" id="border_radius" 
                            value="<?php echo esc_attr($styling['border_radius']); ?>" 
                            class="small-text">
                        <p class="description"><?php esc_html_e('Set to 0 for square corners', 'store-it-contact'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th><label for="background_color"><?php esc_html_e('Field Background Color', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="text" name="background_color" id="background_color" 
                            value="<?php echo esc_attr($styling['background_color']); ?>" 
                            class="color-picker">
                    </td>
                </tr>
                <tr>
                    <th><label for="border_color"><?php esc_html_e('Field Border Color', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="text" name="border_color" id="border_color" 
                            value="<?php echo esc_attr($styling['border_color']); ?>" 
                            class="color-picker">
                    </td>
                </tr>
                <tr>
                    <th><label for="text_color"><?php esc_html_e('Text Color', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="text" name="text_color" id="text_color" 
                            value="<?php echo esc_attr($styling['text_color']); ?>" 
                            class="color-picker">
                    </td>
                </tr>
                <tr>
                    <th><label for="accent_color"><?php esc_html_e('Accent Color', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="text" name="accent_color" id="accent_color" 
                            value="<?php echo esc_attr($styling['accent_color']); ?>" 
                            class="color-picker">
                    </td>
                </tr>
                <tr>
                    <th><label for="accent_contrast_color"><?php esc_html_e('Accent Contrast Color', 'store-it-contact'); ?></label></th>
                    <td>
                        <input type="text" name="accent_contrast_color" id="accent_contrast_color" 
                            value="<?php echo esc_attr($styling['accent_contrast_color']); ?>" 
                            class="color-picker">
                    </td>
                </tr>
            </table>

            <?php submit_button(__('Save Styling', 'store-it-contact')); ?>
        </form>

    <?php 
    // =========== FIELDS TAB ===========
    elseif ($activeTab === 'fields'): ?>
        <form method="post">
            <?php wp_nonce_field('store_it_contact_edit_form', 'store_it_contact_edit_form_nonce'); ?>

            <h2><?php esc_html_e('Fields', 'store-it-contact'); ?></h2>
            <p><?php esc_html_e('Drag to reorder. Click the edit icon to configure each field. Click the eye icon to toggle visibility.', 'store-it-contact'); ?></p>

            <input type="hidden" id="fields_data" name="fields_data" value="">

            <table class="widefat striped" style="width: 600px;">
                <thead>
                <tr>
                    <th><?php esc_html_e('Field', 'store-it-contact'); ?></th>
                    <th style="width:90px;"><?php esc_html_e('Actions', 'store-it-contact'); ?></th>
                </tr>
                </thead>
                <tbody id="store-it-fields-list">
                <?php
                foreach ($fields as $fId => $data) :

                    $label       = isset($data['label']) ? $data['label'] : $fId;
                    $visible     = (!empty($data['visible']) && $data['visible'] === 'visible') ? 'visible' : 'invisible';
                    $required    = (!empty($data['required']) && $data['required'] === 'required') ? 'required' : 'notrequired';
                    $placeholder = isset($data['placeholder']) ? $data['placeholder'] : '';
                    $desc        = isset($data['description']) ? $data['description'] : '';
                    $iconClass   = ($visible === 'visible') ? 'dashicons-visibility' : 'dashicons-hidden';
                    $iconTitle   = ($visible === 'visible') ? esc_attr__('Visible', 'store-it-contact') : esc_attr__('Hidden', 'store-it-contact');
                    ?>
                    <tr class="store-it-field-row"
                        data-field_id="<?php echo esc_attr($fId); ?>"
                        data-label="<?php echo esc_attr($label); ?>"
                        data-visible="<?php echo esc_attr($visible); ?>"
                        data-required="<?php echo esc_attr($required); ?>"
                        data-placeholder="<?php echo esc_attr($placeholder); ?>"
                        data-description="<?php echo esc_attr($desc); ?>"
                        data-lock_required="<?php echo isset($data['lock_required']) && $data['lock_required'] ? 'true' : 'false'; ?>"
                    >
                        <td>
                            <span class="store-it-field-label"><?php echo esc_html($label); ?></span>
                        </td>
                        <td style="text-align:center;">
                            <span class="dashicons <?php echo esc_attr($iconClass); ?> store-it-field-visibility-icon"
                                  title="<?php echo esc_attr($iconTitle); ?>"
                                  style="cursor:pointer;"></span>
                            &nbsp;
                            <?php if ($fId !== 'recaptcha'): ?>
                                <a href="#TB_inline?width=400&height=380&inlineId=store-it-field-edit-popup"
                                class="thickbox store-it-field-edit-trigger dashicons dashicons-edit"
                                style="text-decoration:none; cursor:pointer;"
                                title="<?php esc_attr_e('Configure field', 'store-it-contact'); ?>">
                                </a>
                            <?php endif; ?>
                            &nbsp;
                            <span class="dashicons dashicons-move store-it-field-drag-handle" style="cursor:move;"
                                  title="<?php esc_attr_e('Drag to reorder', 'store-it-contact'); ?>"></span>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <?php submit_button(__('Save Fields', 'store-it-contact')); ?>
        </form>

        <!-- Thickbox popup markup, etc. (unchanged from existing) -->
        <div id="store-it-field-edit-popup" style="display:none;">
            <h3><?php esc_html_e('Edit Field', 'store-it-contact'); ?></h3>
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Label', 'store-it-contact'); ?></th>
                    <td><input type="text" id="store-it-field-label" class="regular-text"></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Placeholder', 'store-it-contact'); ?></th>
                    <td><input type="text" id="store-it-field-placeholder" class="regular-text"></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Description', 'store-it-contact'); ?></th>
                    <td><textarea id="store-it-field-description" rows="3" style="width:100%;"></textarea></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Required', 'store-it-contact'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" id="store-it-field-required" value="1">
                            <?php esc_html_e('Mark as required field', 'store-it-contact'); ?>
                        </label>
                        <p class="description store-it-field-required-note" style="display:none; color:#d63638;">
                            <?php esc_html_e('This field is required by default and cannot be changed.', 'store-it-contact'); ?>
                        </p>
                    </td>
                </tr>
            </table>
            <p>
                <button type="button" class="button button-primary" id="store-it-field-save-btn">
                    <?php esc_html_e('Save', 'store-it-contact'); ?>
                </button>
                <button type="button" class="button tb-close-button" onclick="tb_remove();">
                    <?php esc_html_e('Cancel', 'store-it-contact'); ?>
                </button>
            </p>
        </div>
        <!-- Field management JavaScript is now handled in admin.js -->

    <?php
    // =========== NEW NOTIFICATIONS TAB ===========
    elseif ($activeTab === 'notifications'): ?>
        <form method="post">
            <?php wp_nonce_field('store_it_contact_edit_form', 'store_it_contact_edit_form_nonce'); ?>

            <h2><?php esc_html_e('Notification Settings', 'store-it-contact'); ?></h2>
            <table class="form-table">
                <tr>
                    <th>
                        <label for="success_message"><?php esc_html_e('Success Message', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <input 
                            type="text" name="success_message" id="success_message" 
                            value="<?php echo esc_attr($notifications['success_message'] ?? __('Thank you! Your message has been submitted.', 'store-it-contact')); ?>" 
                            class="regular-text"
                        >
                        <p class="description">
                            <?php esc_html_e('Message shown after successful form submission.', 'store-it-contact'); ?>
                        </p>
                    </td>
                </tr>

                <tr>
                    <th>
                        <label for="default_error_message"><?php esc_html_e('Default Error Message', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <?php
                            wp_editor(
                                $notifications['default_error_message'] ?? __('An error occurred while submitting the form. Please try again later.', 'store-it-contact'),
                                'default_error_message', // The HTML ID and name attribute
                                [
                                    'textarea_name' => 'default_error_message',
                                    'textarea_rows' => 10,
                                    'media_buttons' => false,
                                    'teeny'         => false, // Set to false for full toolbar
                                    'quicktags'     => true,
                                    'tinymce'      => [
                                        'toolbar1' => 'bold,italic,underline,strikethrough,bullist,numlist,blockquote,hr,link,unlink,wp_adv',
                                    ],
                                ]
                            );
                        ?>
                    </td>
                </tr>


                <tr>
                    <th>
                        <label for="email_template"><?php esc_html_e('E-mail Template', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <select name="email_template" id="email_template">
                            <?php for ($i = 1; $i <= 10; $i++) : 
                                $id = $i + 90;
                                $selected = isset($notifications['email_template']) && $notifications['email_template'] === $id;
                            ?>
                                <option value="<?php echo esc_attr($id); ?>" <?php selected($selected); ?>><?php 
                                    // translators: %1$d is the email template number, %2$d is the template ID
                                    echo esc_html(sprintf(__('API email %1$d - id: %2$d', 'store-it-contact'), $i, $id)); 
                                ?></option>
                            <?php endfor; ?>
                        </select>
                        <p class="description">
                            <?php esc_html_e('Select which email template to use for the notification email.', 'store-it-contact'); ?>
                        </p>
                    </td>
                </tr>

                <tr style="display:none;">
                    <th>
                        <label for="email_object"><?php esc_html_e('E-mail Objects', 'store-it-contact'); ?></label>
                    </th>
                    <td>
                        <select name="email_object" id="email_object">
                            <option 
                                value="none"
                                <?php echo isset($notifications['email_object']) && $notifications['email_object'] === 'none' ? 'selected' : ''; ?>
                            ><?php esc_html_e('None', 'store-it-contact'); ?></option>
                            <option 
                                value="task_document"
                                <?php echo isset($notifications['email_object']) && $notifications['email_object'] === 'task_document' ? 'selected' : ''; ?>
                            ><?php esc_html_e('Task Document', 'store-it-contact'); ?></option>
                            <option 
                                value="task_attachment"
                                <?php echo isset($notifications['email_object']) && $notifications['email_object'] === 'task_attachment' ? 'selected' : ''; ?>
                            ><?php esc_html_e('Task Attachment', 'store-it-contact'); ?></option>
                        </select>
                        <p class="description">
                            <?php esc_html_e('Select which objects to include in the notification email.', 'store-it-contact'); ?>
                        </p>
                    </td>
                </tr>
            </table>

            <?php submit_button(__('Save Notification Settings', 'store-it-contact')); ?>
        </form>
    <?php
    // =========== ENTRIES TAB ===========
    elseif ($activeTab === 'entries'): 
        // We'll load the submissions for this form
        $this->submissionsManager->loadSubmissions();
        $submissions = $this->submissionsManager->getSubmissions($formId);
        ?>
        <h2><?php esc_html_e('Entries (Submissions)', 'store-it-contact'); ?></h2>
        <?php if (empty($submissions)) : ?>
            <p><?php esc_html_e('No entries found for this form.', 'store-it-contact'); ?></p>
        <?php else: ?>
            <table class="widefat striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Date', 'store-it-contact'); ?></th>
                        <th><?php esc_html_e('Submitted Values', 'store-it-contact'); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($submissions as $subId => $submissionData) : 
                    $date   = isset($submissionData['date']) ? $submissionData['date'] : '';
                    $fields = isset($submissionData['fields']) ? $submissionData['fields'] : array();

                    $getTaskTypeDesc = function($typeId) use ($taskTypes) {
                        if (!$typeId || !is_array($taskTypes)) return $typeId;
                        foreach ($taskTypes as $type) {
                            if ((string)$type['typeId'] === (string)$typeId) {
                                return $type['description'];
                            }
                        }
                        return $typeId;
                    };
                    ?>
                    <tr>
                        <td><?php echo esc_html($date); ?></td>
                        <td>
                            <?php
                            foreach ($fields as $fKey => $fValue) {
                                // if key is submit_button, skip
                                if ($fKey === 'submit_button') {
                                    continue;
                                }
                                // If the field is request_type, show the description instead of ID
                                if ($fKey === 'request_type') {
                                    $fValue = $getTaskTypeDesc($fValue);
                                }
                                echo '<strong>' . esc_html($fKey) . ':</strong> ' . esc_html($fValue) . '<br>';
                            }
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

    <?php endif; ?>

</div>

