<?php
if (!defined('ABSPATH')) {
    exit;
}

class StoreItContactPlugin {

    private $formsManager;
    private $adminController;
    private $shortcodeController;
    private $submissionsManager;
    private $submissionSyncService;
    private $languageController;
    /**
     * instantiate sub-components
     */
    public function __construct() {
        $this->formsManager = new StoreItContactFormsManager();
        $this->submissionsManager = new StoreItContactSubmissionsManager();
        $this->submissionSyncService = new StoreItContact_SubmissionSyncService();
        $this->adminController = new StoreItContactAdmin($this->formsManager, $this->submissionsManager);
        $this->shortcodeController = new StoreItContactShortcodes($this->formsManager, $this->submissionsManager, $this->submissionSyncService);
        $this->languageController = new StoreItContact_LanguageController();
    }

    /**
     * Initialize the main plugin components
     */
    public function init() {
        $this->adminController->init();
        $this->shortcodeController->init();
    }
}