/* Store-IT Contact Form reCAPTCHA Validation */
document.addEventListener('DOMContentLoaded', function() {
    // Find all Store-IT contact forms with reCAPTCHA
    var forms = document.querySelectorAll('[id^="store-it-contact-form-"]');
    
    forms.forEach(function(formContainer) {
        var form = formContainer.querySelector('form');
        var recaptcha = form ? form.querySelector('.g-recaptcha') : null;
        var errorElement = form ? form.querySelector('.g-recaptcha-error') : null;
        
        if (form && recaptcha && errorElement) {
            form.addEventListener('submit', function(e) {
                if (typeof grecaptcha !== 'undefined' && !grecaptcha.getResponse()) {
                    e.preventDefault();
                    errorElement.style.display = 'block';
                    return false;
                }
                // Hide error if validation passes
                errorElement.style.display = 'none';
            });
        }
    });
});