document.addEventListener('DOMContentLoaded', function() {
    var storeItForm = document.querySelector('.store-it-contact-form form');

    if (storeItForm) {
        storeItForm.addEventListener('submit', function(e) {
            var formId = this.querySelector('input[name="store_it_contact_form_id"]').value;
            
            if (typeof window.dataLayer !== 'undefined') {
                window.dataLayer.push({
                    'event': 'store_it_form_submit',
                    'form_id': formId,
                    'form_title': '<?php echo esc_js($title); ?>'
                });
            } else if (typeof window.gtag === 'function') {
                window.gtag('event', 'store_it_form_submit', {
                    'form_id': formId,
                    'form_title': '<?php echo esc_js($title); ?>'
                });
            }
            
        });
    }
});