jQuery(document).ready(function($) {
    // Initialize color picker
    $('.color-picker').wpColorPicker();
    
    // Field management functionality
    var $tableBody = $('#store-it-fields-list');
    var $fieldsDataInput = $('#fields_data');
    var $editRow = null;

    if ($tableBody.length && $fieldsDataInput.length) {
        // Make rows sortable
        $tableBody.sortable({
            handle: '.store-it-field-drag-handle',
            update: function() {
                updateFieldsData();
            }
        });

        // Toggle visibility on click
        $tableBody.on('click', '.store-it-field-visibility-icon', function(){
            var $icon = $(this);
            var $row = $icon.closest('.store-it-field-row');
            var currentState = $row.data('visible');
            var newState = (currentState === 'visible') ? 'invisible' : 'visible';

            // Update icon
            $icon.removeClass('dashicons-visibility dashicons-hidden');
            if (newState === 'visible') {
                $icon.addClass('dashicons-visibility');
                $icon.attr('title', 'Visible');
            } else {
                $icon.addClass('dashicons-hidden');
                $icon.attr('title', 'Hidden');
            }

            // Update the row's data-visible attribute
            $row.attr('data-visible', newState);
            $row.data('visible', newState);

            updateFieldsData();
        });

        // Edit Field via Thickbox
        $tableBody.on('click', '.store-it-field-edit-trigger', function(){
            $editRow = $(this).closest('.store-it-field-row');
            var lockRequired = $editRow.data('lock_required') === true || $editRow.data('lock_required') === 'true';
            
            $('#store-it-field-label').val($editRow.data('label'));
            $('#store-it-field-placeholder').val($editRow.data('placeholder'));
            $('#store-it-field-description').val($editRow.data('description'));
            $('#store-it-field-required').prop('checked', $editRow.data('required') === 'required');
            $('#store-it-field-required').prop('disabled', lockRequired);
            
            if (lockRequired) {
                $('.store-it-field-required-note').show();
            } else {
                $('.store-it-field-required-note').hide();
            }
        });

        // Handle "Save" in the Thickbox form
        $('#store-it-field-save-btn').on('click', function(){
            if (!$editRow) {
                tb_remove();
                return;
            }

            var lockRequired = $editRow.data('lock_required') === true || $editRow.data('lock_required') === 'true';
            var newLabel = $('#store-it-field-label').val();
            var newPlaceholder = $('#store-it-field-placeholder').val();
            var newDescription = $('#store-it-field-description').val();
            var newRequired = lockRequired ? 'required' : ($('#store-it-field-required').is(':checked') ? 'required' : 'notrequired');

            $editRow.data('label', newLabel);
            $editRow.data('placeholder', newPlaceholder);
            $editRow.data('description', newDescription);
            $editRow.data('required', newRequired);
            $editRow.find('.store-it-field-label').text(newLabel);

            tb_remove();
            updateFieldsData();
        });

        // On form submit, gather the data into JSON
        $('form').on('submit', function(){
            updateFieldsData();
        });

        function updateFieldsData() {
            var fieldsArr = [];
            $tableBody.find('.store-it-field-row').each(function(index, row){
                var $row = $(row);
                var fieldId = $row.data('field_id');
                var fieldObj = {};
                fieldObj[fieldId] = {
                    label: $row.data('label'),
                    visible: $row.data('visible'),
                    required: $row.data('required'),
                    placeholder: $row.data('placeholder'),
                    description: $row.data('description')
                };
                
                if ($row.data('lock_required') === true) {
                    fieldObj[fieldId]['lock_required'] = true;
                }
                
                fieldsArr.push(fieldObj);
            });
            
            var fieldsData = {};
            fieldsArr.forEach(function(field) {
                var key = Object.keys(field)[0];
                fieldsData[key] = field[key];
            });
            
            $fieldsDataInput.val(JSON.stringify(fieldsData));
        }

        // Initialize once
        updateFieldsData();
    }
}); 