# Store-IT Contact Plugin

A WordPress plugin that integrates with the Store-IT API to create customizable contact forms with automatic submission synchronization.

**License:** GPL v2 or later  
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html

## Description

The Store-IT Contact plugin allows you to create and manage contact forms that automatically sync submissions with the Store-IT API. The plugin provides a complete form builder with styling options, field management, and multi-language support.

## Features

- **Form Builder**: Create unlimited contact forms with customizable fields
- **Store-IT API Integration**: Automatic submission synchronization with Store-IT services
- **Multi-language Support**: Available in English, Dutch, German, Spanish, Finnish, French, and Italian
- **Customizable Styling**: Full control over form appearance including colors, fonts, and spacing
- **Field Management**: Configure field visibility, requirements, labels, and validation
- **reCAPTCHA Support**: Built-in Google reCAPTCHA integration for spam protection
- **Responsive Design**: Mobile-friendly forms that adapt to any screen size
- **Admin Dashboard**: Complete management interface for forms and submissions

## Installation

1. Download the plugin files
2. Upload the `store-it-contact` folder to your `/wp-content/plugins/` directory
3. Activate the plugin through the 'Plugins' menu in WordPress
4. Configure the API settings in the plugin settings page

## Configuration

### API Settings

1. Navigate to **Store-IT Contact > Global Settings**
2. Configure your API credentials:
   - **Base URL**: Your Store-IT API endpoint
   - **Username**: Your Store-IT API username
   - **Password**: Your Store-IT API password
   - **Grant Type**: Authentication method (default: password)
   - **Client ID**: Your Store-IT API client ID

### reCAPTCHA Setup (Optional)

1. Go to **Store-IT Contact > Global Settings > reCAPTCHA**
2. Enter your Google reCAPTCHA credentials:
   - **Site Key**: Your reCAPTCHA site key
   - **Secret Key**: Your reCAPTCHA secret key

## Usage

### Creating a Contact Form

1. Navigate to **Store-IT Contact > Add New Form**
2. Configure the form settings:
   - **Form Name**: Internal name for the form
   - **Form Title**: Display title for visitors
   - **Language**: Form language
   - **Request Types**: Available request categories
   - **Locations**: Available facility locations

### Customizing Form Styling

1. Edit your form and go to the **Styling** tab
2. Customize:
   - Background color
   - Border color and radius
   - Text color
   - Font size
   - Accent colors

### Managing Form Fields

1. In the **Fields** tab, configure:
   - Field visibility (visible/hidden)
   - Field requirements (required/optional)
   - Field labels and placeholders
   - Field descriptions

### Displaying Forms

Use the shortcode to display your form:

```php
[store_it_contact_form id="your_form_id"]
```

### Form Fields

The plugin supports these field types:

- **Location**: Dropdown of available facilities
- **Request Type**: Dropdown of available request categories
- **Title**: Optional title field with predefined options
- **First Name**: Text input for first name
- **Surname**: Text input for surname
- **Phone Number**: Telephone input with validation
- **Email**: Email input with validation (required)
- **Message**: Textarea for message content
- **reCAPTCHA**: Google reCAPTCHA verification
- **Submit Button**: Form submission button

## API Integration

The plugin automatically synchronizes form submissions with the Store-IT API:

1. **Customer Creation**: Creates or updates customer records
2. **Submission Sync**: Sends form data to Store-IT services
3. **Error Handling**: Manages API errors and provides feedback
4. **Authentication**: Handles OAuth token management

## Multi-language Support

The plugin includes translations for:

- English (en)
- Dutch (nl)
- German (de)
- Spanish (es)
- Finnish (fi)
- French (fr)
- Italian (it)