<?php
/**
 * Plugin Name: StockCommerce
 * Description: Manage the stock of simple products in WooCommerce.
 * Version: 1.0
 * Author: Carlos Jimenez
 * Author URI: https://byteweb.es
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: stockcommerce
 * Domain Path: /languages
 */

defined('ABSPATH') || exit;

// Define plugin constants.
define('STOCKCOMMERCE_VERSION', '1.0');
define('STOCKCOMMERCE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('STOCKCOMMERCE_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files.
require_once STOCKCOMMERCE_PLUGIN_DIR . 'includes/class-stockcommerce-admin.php';
require_once STOCKCOMMERCE_PLUGIN_DIR . 'includes/class-stockcommerce-ajax.php';
require_once STOCKCOMMERCE_PLUGIN_DIR . 'includes/enqueue-scripts.php';

// Initialize the admin interface.
if (is_admin()) {
    new StockCommerce_Admin();
}

// Initialize AJAX handlers.
new StockCommerce_Ajax();

// Enqueue scripts and styles.
add_action('admin_enqueue_scripts', 'stockcommerce_enqueue_admin_scripts');

