<?php

function stockcommerce_enqueue_admin_scripts($hook) {
    if ($hook !== 'toplevel_page_stockcommerce') {
        return;
    }

    // Enqueue the admin script.
    wp_enqueue_script(
        'stockcommerce-admin',
        STOCKCOMMERCE_PLUGIN_URL . 'assets/js/admin.js',
        ['jquery'],
        STOCKCOMMERCE_VERSION,
        true
    );

    // Pass localized strings and variables to JavaScript.
    wp_localize_script('stockcommerce-admin', 'stockcommerce', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('stockcommerce_nonce'),
        'current_stock_label' => __('Current Stock', 'stockcommerce'),
        'modify_stock_label'  => __('Modify Stock', 'stockcommerce'),
    ]);

    // Enqueue the admin styles.
    wp_enqueue_style(
        'stockcommerce-admin',
        STOCKCOMMERCE_PLUGIN_URL . 'assets/css/admin.css',
        [],
        STOCKCOMMERCE_VERSION
    );
}
