<?php

class StockCommerce_Ajax {
    public function __construct() {
        add_action('wp_ajax_stockcommerce_search', [$this, 'search_products']);
        add_action('wp_ajax_stockcommerce_save', [$this, 'save_stock']);
    }

    public function search_products() {
        check_ajax_referer('stockcommerce_nonce', 'nonce');

        $search_term = isset($_POST['term']) ? sanitize_text_field($_POST['term']) : '';

        // Ensure the search term is not empty.
        if (empty($search_term)) {
            wp_send_json_success([]);
            return;
        }

        // Query to fetch simple products where the title matches the search term.
        $args = [
            'post_type'      => 'product',
            'post_status'    => 'publish',
            'posts_per_page' => -1, // Ensure all results are fetched.
            's'              => $search_term,
            'tax_query'      => [
                [
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'simple', // Only fetch simple products.
                ],
            ],
        ];

        $query = new WP_Query($args);
        $results = [];

        if ($query->have_posts()) {
            foreach ($query->posts as $product) {
                // Ensure the title matches exactly or partially the search term.
                if (stripos($product->post_title, $search_term) !== false) {
                    $results[] = [
                        'id'    => $product->ID,
                        'name'  => $product->post_title,
                        'stock' => get_post_meta($product->ID, '_stock', true), // Fetch stock value.
                    ];
                }
            }
        }

        wp_reset_postdata();

        // Send results as a JSON response.
        wp_send_json_success($results);
    }

    public function save_stock() {
        check_ajax_referer('stockcommerce_nonce', 'nonce');

        $products = isset($_POST['products']) ? $_POST['products'] : [];

        foreach ($products as $product) {
            $product_id = intval($product['id']);
            $stock      = intval($product['stock']);
            update_post_meta($product_id, '_stock', $stock);
        }

        wp_send_json_success(__('Stock updated successfully!', 'stockcommerce'));
    }
}
