<?php

class StockCommerce_Admin {
    public function __construct() {
        add_action('admin_menu', [$this, 'register_admin_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    public function register_admin_menu() {
        add_menu_page(
            __('StockCommerce', 'stockcommerce'),
            __('StockCommerce', 'stockcommerce'),
            'manage_options',
            'stockcommerce',
            [$this, 'render_admin_page'],
            'dashicons-products',
            20
        );
    }

    public function enqueue_scripts($hook) {
        if ($hook !== 'toplevel_page_stockcommerce') {
            return;
        }

        wp_enqueue_script(
            'stockcommerce-admin-js',
            plugins_url('/assets/js/admin.js', dirname(__FILE__)),
            ['jquery'],
            STOCKCOMMERCE_VERSION,
            true
        );

        wp_enqueue_style(
            'stockcommerce-admin-css',
            plugins_url('/assets/css/admin.css', dirname(__FILE__)),
            [],
            STOCKCOMMERCE_VERSION
        );
    }

    public function render_admin_page() {
        ?>
        <div class="wrap">
            <h1><?php esc_html_e('StockCommerce', 'stockcommerce'); ?></h1>
            
            <!-- Contenedor de donación -->
            <div id="donate-container" style="border: 2px solid #0073aa; border-radius: 10px; padding: 15px; margin-bottom: 20px; display: flex; align-items: center; justify-content: space-between; background: #f9f9f9;">
                <p style="margin: 0; font-size: 16px;">
                    ☕ <?php esc_html_e('Did this plugin make your day easier? Buy me a virtual coffee and help keep it running. Thank you for your support! 🙌', 'stockcommerce'); ?>
                </p>
                <a href="https://www.paypal.com/donate/?hosted_button_id=ELUPRMKNYC6DY" target="_blank">
        <img src="<?php echo esc_url( plugins_url( 'assets/images/coffee.png', __DIR__ ) ); ?>" 
             alt="<?php esc_attr_e('Donate with PayPal', 'stockcommerce'); ?>" 
             style="height: 50px;">
    </a>
            </div>

            <div id="stockcommerce-app">

                <!-- Buscador -->
                <input
                    type="text"
                    id="stockcommerce-search"
                    placeholder="<?php esc_attr_e('Search for simple products...', 'stockcommerce'); ?>"
                    style="width: 45%;"
                />

                <!-- Mensaje de ayuda -->
                <p style="margin-top: 10px; color: #000;">
                    <?php esc_html_e('Each time you select a product from the search results, a dynamic card will be created where you can modify the stock of the selected product. You can perform multiple searches and create as many cards as you need. Once you have modified the stock of all the products, click on the Save Changes button. IMPORTANT: The value defined in the stock fields of each product is added to the current stock value. For example, if a product\'s current stock is 10 units and you enter 5 units in the field, upon saving the changes, the stock for that product will be 15 units.', 'stockcommerce'); ?>
                </p>

                <!-- Contenedor de resultados de búsqueda -->
                <div id="stockcommerce-results" style="width: 50%; margin-top: 20px; float: left;"></div>

                <!-- Contenedor de tarjetas dinámicas con el botón encima -->
                <div id="stockcommerce-selected" style="width: 45%; margin-top: 20px; float: right;">
                    
                    <!-- Botón Save Changes (siempre arriba) -->
                    <button id="stockcommerce-save" class="button button-primary" style="margin-bottom: 15px; display: block; width: 100%;">
                        <?php esc_html_e('Save Changes', 'stockcommerce'); ?>
                    </button>

                    <!-- Aquí se insertarán las tarjetas dinámicas -->
                    <div id="stockcommerce-dynamic-cards"></div>

                </div>

            </div>
        </div>
        <?php
    }
}
