<?php

if (!defined('ABSPATH')) {
    exit;
}

// Buscar productos dinámicamente
function stockcommerce_search_products() {
    check_ajax_referer('stockcommerce_nonce', 'nonce');

    // Usar wp_unslash() antes de sanitize_text_field()
    $term = isset($_POST['term']) ? sanitize_text_field(wp_unslash($_POST['term'])) : '';

    $products = wc_get_products([
        'limit' => -1,
        'status' => 'publish',
        'search' => $term,
    ]);

    $results = [];
    foreach ($products as $product) {
        $results[] = [
            'id' => $product->get_id(),
            'text' => $product->get_name(),
            'stock' => $product->get_stock_quantity(),
            'last_updated' => get_post_meta($product->get_id(), '_stock_last_updated', true),
        ];
    }

    wp_send_json($results);
}
add_action('wp_ajax_stockcommerce_search_products', 'stockcommerce_search_products');

// Actualizar stock
function stockcommerce_update_stock() {
    check_ajax_referer('stockcommerce_nonce', 'nonce');

    // Usar wp_unslash() antes de procesar $_POST['product_id'] y $_POST['quantity']
    $product_id = isset($_POST['product_id']) ? intval(wp_unslash($_POST['product_id'])) : 0;
    $quantity = isset($_POST['quantity']) ? intval(wp_unslash($_POST['quantity'])) : 0;

    if ($product_id && $quantity) {
        $product = wc_get_product($product_id);
        $new_stock = $product->get_stock_quantity() + $quantity;
        $product->set_stock_quantity($new_stock);
        $product->save();

        update_post_meta($product_id, '_stock_last_updated', current_time('mysql'));

        wp_send_json_success(['new_stock' => $new_stock]);
    } else {
        wp_send_json_error(['message' => __('Invalid product or quantity.', 'stockcommerce')]);
    }
}
add_action('wp_ajax_stockcommerce_update_stock', 'stockcommerce_update_stock');

