jQuery(document).ready(function ($) {
    let selectedProducts = {};

    // Handle search input.
    $('#stockcommerce-search').on('input', function () {
        const term = $(this).val();

        $.ajax({
            url: stockcommerce.ajax_url,
            method: 'POST',
            data: {
                action: 'stockcommerce_search',
                nonce: stockcommerce.nonce,
                term: term,
            },
            success: function (response) {
                if (response.success) {
                    const results = response.data;
                    const resultsContainer = $('#stockcommerce-results');
                    resultsContainer.empty();

                    results.forEach((product) => {
                        const productRow = $(`
                            <div class="product-result" data-id="${product.id}">
                                <span>${product.name}</span>
                            </div>
                        `);

                        productRow.on('click', function () {
                            if (!selectedProducts[product.id]) {
                                selectedProducts[product.id] = product;

                                const card = $(`
                                    <div class="product-card">
                                        <button class="remove-card">X</button>
                                        <h3>${product.name}</h3>
                                        <p><strong>${stockcommerce.current_stock_label}:</strong> <span class="current-stock" data-id="${product.id}">${product.stock}</span></p>
                                        <label>
                                            <strong>${stockcommerce.modify_stock_label}:</strong>
                                            <input type="text" value="" data-id="${product.id}" placeholder="Enter stock change" style="margin-top: 8px;">
                                        </label>
                                    </div>
                                `);

                                card.find('.remove-card').on('click', function () {
                                    delete selectedProducts[product.id];
                                    card.remove();
                                });

                                $('#stockcommerce-selected').prepend(card);
                            }
                        });

                        resultsContainer.append(productRow);
                    });
                }
            },
        });
    });

    // Handle save button click.
    $('#stockcommerce-save').on('click', function () {
        const modifiedProducts = [];

        $('#stockcommerce-selected .product-card').each(function () {
            const productId = $(this).find('input[type="text"]').data('id');
            const addedStock = parseInt($(this).find('input[type="text"]').val(), 10) || 0;
            const currentStock = parseInt($(this).find('.current-stock').text(), 10) || 0;
            const newStock = currentStock + addedStock;

            if (productId) {
                modifiedProducts.push({
                    id: productId,
                    stock: newStock,
                });

                $(this).find('.current-stock').text(newStock);
                $(this).find('input[type="text"]').val('');
            }
        });

        if (modifiedProducts.length === 0) {
            alert(stockcommerce.no_products_selected || 'No products selected.');
            return;
        }

        $.ajax({
            url: stockcommerce.ajax_url,
            method: 'POST',
            data: {
                action: 'stockcommerce_save',
                nonce: stockcommerce.nonce,
                products: modifiedProducts,
            },
            success: function (response) {
                if (response.success) {
                    alert(response.data || 'Stock updated successfully!');
                } else {
                    alert(response.data || 'An error occurred while updating stock.');
                }
            },
        });
    });
});
