<?php
/**
 * Uninstall Sticky Banner Plugin
 *
 * This file is executed when the plugin is uninstalled (deleted) from WordPress.
 * It cleans up all plugin data from the database.
 *
 * @package StickyBanner
 * @version 1.4.0
 */

// Security: Exit if accessed directly or not during uninstall
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete all plugin options from the database
 */
function hdsb_stickybanner_uninstall()
{
    // Array of all plugin options
    $options = array(
        'hdsb_stickybanner_enabled',
        'hdsb_stickybanner_colour',
        'hdsb_stickybanner_text_colour',
        'hdsb_stickybanner_text',
        'hdsb_stickybanner_position',
        'hdsb_stickybanner_btn_text',
        'hdsb_stickybanner_btn_link',
        'hdsb_stickybanner_cookie_expiry',
        'hdsb_stickybanner_hide_on_pages',
        'hdsb_stickybanner_hide_close_btn',
        'hdsb_stickybanner_version',
    );

    // Delete each option
    foreach ($options as $option) {
        delete_option($option);
    }

    // For multisite installations, delete options from all sites
    if (is_multisite()) {
        global $wpdb;

        // Get all blog IDs
        $blog_ids = $wpdb->get_col("SELECT blog_id FROM {$wpdb->blogs}");

        foreach ($blog_ids as $blog_id) {
            switch_to_blog($blog_id);

            // Delete options for this site
            foreach ($options as $option) {
                delete_option($option);
            }

            restore_current_blog();
        }
    }
}

// Run the uninstall function
hdsb_stickybanner_uninstall();
