<?php
// Security: Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Sanitize and validate all options
$enabled         = (bool) get_option('hdsb_stickybanner_enabled', false);
$text            = wp_kses_post(get_option('hdsb_stickybanner_text'));
$sb_position     = sanitize_key(get_option('hdsb_stickybanner_position', 'top'));
$btnText         = sanitize_text_field(get_option('hdsb_stickybanner_btn_text'));
$btnLink         = esc_url(get_option('hdsb_stickybanner_btn_link'));
$sb_cookieExpiry = absint(get_option('hdsb_stickybanner_cookie_expiry'));
$sb_cookieExpiry = $sb_cookieExpiry > 0 ? $sb_cookieExpiry : 7;
$hideCloseBtn    = (bool) get_option('hdsb_stickybanner_hide_close_btn', false);

$currentPage     = get_the_ID();
$hidePages       = get_option('hdsb_stickybanner_hide_on_pages', '');
$hidePagesArray  = array_map('absint', array_filter(array_map('trim', explode(',', $hidePages))));

// Only display if enabled, text exists, and page is not in hide list
if ($enabled && !empty($text) && !in_array($currentPage, $hidePagesArray, true)) {
    // Validate position
    $sb_position = in_array($sb_position, array('top', 'bottom'), true) ? $sb_position : 'top';
    ?>
    <div id="hdsb-stickybanner" class="hdsb-stickybanner hdsb-stickybanner-<?php echo esc_attr($sb_position); ?>" role="banner" aria-label="<?php esc_attr_e('Site announcement', 'sticky-banner'); ?>">
        <span class="hdsb-stickybanner-text"><?php echo wp_kses_post($text); ?></span>
        <?php if (!empty($btnLink)) : ?>
            <a class="hdsb-stickybanner-btn" href="<?php echo esc_url($btnLink); ?>" <?php echo (strpos($btnLink, home_url()) === false) ? 'rel="noopener noreferrer"' : ''; ?>>
                <?php echo !empty($btnText) ? esc_html($btnText) : esc_html__('Learn more', 'sticky-banner'); ?>
            </a>
        <?php endif; ?>
        <?php if (!$hideCloseBtn) : ?>
            <button class="hdsb-stickybanner-close" aria-label="<?php esc_attr_e('Close banner', 'sticky-banner'); ?>">
                <span aria-hidden="true">&times;</span>
            </button>
        <?php endif; ?>
    </div><!-- hdsb-stickybanner -->
    <?php
    // Enqueue inline script with proper localization
    $hide_close_btn_js = $hideCloseBtn ? 'true' : 'false';

    wp_add_inline_script('hdsb-stickybanner-script', '
        (function($) {
            $(document).ready(function() {
                var $body = $("body");
                var $banner = $(".hdsb-stickybanner");
                var cookieExpiry = ' . absint($sb_cookieExpiry) . ';
                var hideCloseBtn = ' . $hide_close_btn_js . ';

                // Check for active banner cookie (only if close button is visible)
                if (!hideCloseBtn && Cookies.get("sticky-banner")) {
                    $banner.addClass("is-inactive").removeClass("is-active");
                } else {
                    $banner.addClass("is-active").removeClass("is-inactive");
                }

                // Add class and padding to body
                if ($(".hdsb-stickybanner-top").hasClass("is-active")) {
                    $body.addClass("hdsb-t-active");

                    $(window).on("load resize", function() {
                        var bannerHeight = $(".hdsb-stickybanner-top").outerHeight();
                        $(".hdsb-t-active").css("padding-top", bannerHeight);
                    }).trigger("resize");
                } else if ($(".hdsb-stickybanner-bottom").hasClass("is-active")) {
                    $body.addClass("hdsb-b-active");

                    $(window).on("load resize", function() {
                        var bannerHeight = $(".hdsb-stickybanner-bottom").outerHeight();
                        $(".hdsb-b-active").css("padding-bottom", bannerHeight);
                    }).trigger("resize");
                }

                // Close banner and set cookie (only if close button exists)
                if (!hideCloseBtn) {
                    $(".hdsb-stickybanner-close").on("click", function(e) {
                        e.preventDefault();
                        $banner.fadeOut(300, function() {
                            $banner.addClass("is-inactive").removeClass("is-active");
                        });
                        $body.removeAttr("style").removeClass("hdsb-b-active hdsb-t-active");

                        Cookies.set("sticky-banner", "1", {
                            expires: cookieExpiry,
                            path: "/"
                        });
                    });
                }
            });
        })(jQuery);
    ');
}
?>