<?php
// Security: Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Enqueue admin scripts and styles
 */
add_action('admin_enqueue_scripts', 'hdsb_stickybanner_enqueue_admin_scripts');
function hdsb_stickybanner_enqueue_admin_scripts($hook_suffix)
{
    // Only load on our settings page
    if ('toplevel_page_hdsb-stickybanner-settings' !== $hook_suffix) {
        return;
    }

    // WordPress color picker
    wp_enqueue_style('wp-color-picker');

    // Admin scripts
    wp_enqueue_script(
        'hdsb-stickybanner-admin',
        HDSB_PLUGIN_URL . 'assets/js/stickybanner-admin.min.js',
        array('wp-color-picker', 'jquery'),
        HDSB_VERSION,
        true
    );

    // Admin styles - use filemtime for cache busting during development
    $admin_css_file = HDSB_PLUGIN_PATH . 'assets/css/stickybanner-admin.css';
    $admin_css_version = file_exists($admin_css_file) ? filemtime($admin_css_file) : HDSB_VERSION;

    wp_enqueue_style(
        'hdsb-stickybanner-admin-style',
        HDSB_PLUGIN_URL . 'assets/css/stickybanner-admin.css',
        array(),
        $admin_css_version
    );
}

/**
 * Enqueue frontend scripts and styles
 */
add_action('wp_enqueue_scripts', 'hdsb_stickybanner_scripts');
function hdsb_stickybanner_scripts()
{
    // Don't load if banner is disabled or text is empty
    $enabled = (bool) get_option('hdsb_stickybanner_enabled', false);
    $banner_text = get_option('hdsb_stickybanner_text');

    if (!$enabled || empty($banner_text)) {
        return;
    }

    // Check if current page should be excluded
    $current_page = get_the_ID();
    $hide_pages = get_option('hdsb_stickybanner_hide_on_pages', '');
    $hide_pages_array = array_map('absint', array_filter(array_map('trim', explode(',', $hide_pages))));

    if (in_array($current_page, $hide_pages_array, true)) {
        return;
    }

    // Enqueue styles
    wp_enqueue_style(
        'hdsb-stickybanner-style',
        HDSB_PLUGIN_URL . 'assets/css/stickybanner.css',
        array(),
        HDSB_VERSION
    );

    // Enqueue scripts
    wp_enqueue_script(
        'hdsb-stickybanner-script',
        HDSB_PLUGIN_URL . 'assets/js/stickybanner.min.js',
        array('jquery'),
        HDSB_VERSION,
        true
    );

    // Localize script data (not currently used but kept for future enhancements)
    wp_localize_script('hdsb-stickybanner-script', 'hdsbParams', array(
        'pageId' => $current_page,
        'position' => sanitize_key(get_option('hdsb_stickybanner_position', 'top')),
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('hdsb-banner-action')
    ));
}
