<?php
// Security: Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Add custom CSS colors using wp_add_inline_style for better performance
add_action('wp_enqueue_scripts', 'hdsb_stickybanner_custom_colour', 20);
function hdsb_stickybanner_custom_colour()
{
    $bg_colour   = sanitize_hex_color(get_option('hdsb_stickybanner_colour'));
    $text_colour = sanitize_hex_color(get_option('hdsb_stickybanner_text_colour'));

    $custom_css = '';

    if (!empty($bg_colour)) {
        $custom_css .= sprintf(
            '.hdsb-stickybanner { background: %s !important; }',
            esc_attr($bg_colour)
        );
        $custom_css .= sprintf(
            '.hdsb-stickybanner-btn { color: %s !important; }',
            esc_attr($bg_colour)
        );
        $custom_css .= sprintf(
            '.hdsb-stickybanner-btn:hover { color: %s !important; }',
            esc_attr($bg_colour)
        );
    }

    if (!empty($text_colour)) {
        $custom_css .= sprintf(
            '.hdsb-stickybanner-text { color: %s !important; }',
            esc_attr($text_colour)
        );
        $custom_css .= sprintf(
            '.hdsb-stickybanner-btn { background: %s !important; }',
            esc_attr($text_colour)
        );
    }

    if (!empty($custom_css)) {
        wp_add_inline_style('hdsb-stickybanner-style', $custom_css);
    }
}
