<?php
/**
 * Plugin Name: Sticky Banner
 * Plugin URI: https://github.com/hiddendepth/hdsb-stickybanner
 * Description: Display a customizable sticky announcement banner at the top or bottom of your website with call-to-action buttons.
 * Version: 1.4.0
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * Author: Hidden Depth
 * Author URI: https://hiddendepth.ie
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: sticky-banner
 * Domain Path: /languages
 *
 * @package StickyBanner
 * @version 1.4.0
 * @author Hidden Depth <info@hd.ie>
 */

// Security: Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('HDSB_VERSION', '1.4.0');
define('HDSB_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('HDSB_PLUGIN_URL', plugin_dir_url(__FILE__));
define('HDSB_TEXT_DOMAIN', 'sticky-banner');

/**
 * Load plugin text domain for internationalization
 */
add_action('plugins_loaded', 'hdsb_load_textdomain');
function hdsb_load_textdomain()
{
    load_plugin_textdomain(
        'sticky-banner',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages'
    );
}

/**
 * Handle plugin upgrades - runs on every page load but only executes once per version
 */
add_action('plugins_loaded', 'hdsb_stickybanner_upgrade_check');
function hdsb_stickybanner_upgrade_check()
{
    $db_version = get_option('hdsb_stickybanner_version', '0');

    // Only run upgrade logic if version changed
    if (version_compare($db_version, HDSB_VERSION, '<')) {
        // Check if enabled option needs to be set (new in 1.4.0+)
        $enabled_option_exists = get_option('hdsb_stickybanner_enabled');

        if ($enabled_option_exists === false) {
            // This is an upgrade from pre-1.4.0 or fresh install
            $banner_text = get_option('hdsb_stickybanner_text');

            // Smart default: If they had text, they were using the banner (enable it)
            // If no text (fresh install or unused), keep it disabled
            $should_enable = !empty($banner_text);
            update_option('hdsb_stickybanner_enabled', $should_enable);
        }

        // Update version number
        update_option('hdsb_stickybanner_version', HDSB_VERSION);
    }
}

/**
 * Output sticky banner in footer
 */
add_action('wp_footer', 'hdsb_stickybanner_output');
function hdsb_stickybanner_output()
{
    require_once HDSB_PLUGIN_PATH . 'inc/stickybanner.php';
}

// Load plugin files
require_once HDSB_PLUGIN_PATH . 'inc/enqueues.php';
require_once HDSB_PLUGIN_PATH . 'inc/admin/colours.php';
require_once HDSB_PLUGIN_PATH . 'inc/admin/settings.php';
