<?php
/**
 * Global Helper Functions
 *
 * Provides global accessor functions for extension developers.
 *
 * @package STCWHeadlessAssistant
 * @since 2.0.0
 */

if (!defined('ABSPATH')) exit;

/**
 * Get STCW Headless Core instance
 *
 * Provides global access to core functionality for extensions.
 * Use this in extension plugins to register detectors and targets.
 *
 * @return \STCW\Headless\Core Core instance
 */
function STCW_Headless() {
    return \STCW\Headless\Core::instance();
}

/**
 * Check if STCW Headless is available
 *
 * Useful for conditional loading in themes/plugins.
 *
 * @return bool True if Headless Assistant is active
 */
function stcw_headless_is_active() {
    return class_exists('\STCW\Headless\Core');
}
