<?php
/**
 * CMS Target Interface
 *
 * Defines the contract for all CMS target implementations.
 * Each CMS (Sanity, Contentful, Strapi, etc.) must implement this interface.
 *
 * @package STCWHeadlessAssistant
 * @since 2.0.0
 */

namespace STCW\Headless\Engine\Target;

if (!defined('ABSPATH')) exit;

interface TargetInterface {
    
    /**
     * Get target display name
     *
     * @return string Human-readable name (e.g., "Sanity CMS")
     */
    public function get_name(): string;
    
    /**
     * Get target slug
     *
     * @return string Slug for CLI usage (e.g., "sanity")
     */
    public function get_slug(): string;
    
    /**
     * Convert detected patterns to CMS format
     *
     * @param array $patterns Detected patterns from PatternDetector
     * @param array $metadata Page metadata (title, description, etc.)
     * @return array Converted data in CMS-specific format
     */
    public function convert(array $patterns, array $metadata): array;
    
    /**
     * Generate CMS schema files
     *
     * @param string $output_dir Directory to write schema files
     * @return array Result with generated file paths
     */
    public function generate_schemas(string $output_dir): array;
    
    /**
     * Export converted data to importable format
     *
     * @param array $converted_pages Array of converted page data
     * @param string $output_dir Export directory
     * @return array Result with export package information
     */
    public function export(array $converted_pages, string $output_dir): array;
}
