<?php
/**
 * Core Gutenberg Block Patterns
 *
 * Registers detection patterns for WordPress core blocks.
 * These are fundamental patterns that work across all themes.
 * 
 * v1.3.1: Added sanity_target declarations for semantic type mapping
 *
 * @package STCWHeadlessAssistant
 * @since 2.0.0
 */

if (!defined('ABSPATH')) exit;

// Use fully qualified class names since this file has no namespace
use STCW\Headless\Engine\Detector\PatternRegistry;
use STCW\Headless\Engine\Detector\Extractors;

// ==========================================
// TEXT & TYPOGRAPHY BLOCKS
// ==========================================

PatternRegistry::register('heading', [
    'selectors' => [
        'h1',
        'h2',
        'h3',
        'h4',
        'h5',
        'h6',
        '.wp-block-heading',
    ],
    'extractor' => [Extractors::class, 'extract_heading'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress heading blocks',
    // Note: Headings convert to Portable Text 'block' type (built-in)
]);

PatternRegistry::register('paragraph', [
    'selectors' => [
        'p',
        '.wp-block-paragraph',
    ],
    'extractor' => [Extractors::class, 'extract_paragraph'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress paragraph blocks',
    // Note: Paragraphs convert to Portable Text 'block' type (built-in)
]);

PatternRegistry::register('list', [
    'selectors' => [
        'ul',
        'ol',
        '.wp-block-list',
    ],
    'extractor' => [Extractors::class, 'extract_list'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress list blocks',
    // Note: Lists convert to Portable Text 'block' type (built-in)
]);

PatternRegistry::register('quote', [
    'selectors' => [
        'blockquote',
        '.wp-block-quote',
        '.wp-block-pullquote',
    ],
    'extractor' => [Extractors::class, 'extract_quote'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress quote blocks',
    // Note: Quotes convert to Portable Text 'block' type (built-in)
]);

// ==========================================
// MEDIA BLOCKS
// ==========================================

PatternRegistry::register('image', [
    'selectors' => [
        'img',
        '.wp-block-image',
        'figure.wp-block-image',
    ],
    'extractor' => [Extractors::class, 'extract_image'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress image blocks',
    'sanity_target' => 'imageBlock',  // v1.3: Custom type with migration metadata
]);

PatternRegistry::register('gallery', [
    'selectors' => [
        '.wp-block-gallery',
        '.blocks-gallery-grid',
    ],
    'extractor' => [Extractors::class, 'extract_gallery'],
    'priority' => 6,
    'confidence' => 0.95,
    'description' => 'WordPress gallery blocks',
    'sanity_target' => 'rawHtml',  // TODO: Create gallery semantic type in future
    'sanity_note' => 'WordPress gallery block - manual conversion recommended',
]);

PatternRegistry::register('video', [
    'selectors' => [
        'video',
        '.wp-block-video',
    ],
    'extractor' => [Extractors::class, 'extract_video'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress video blocks',
    'sanity_target' => 'rawHtml',  // TODO: Create video semantic type in future
    'sanity_note' => 'WordPress video block - manual conversion recommended',
]);

// ==========================================
// LAYOUT BLOCKS (IGNORED)
// ==========================================
// Note: Layout blocks like group/columns are wrappers, not content.
// They are intentionally NOT registered here - the detector will
// extract their inner content blocks directly.

// ==========================================
// FORMATTING BLOCKS
// ==========================================

PatternRegistry::register('separator', [
    'selectors' => [
        'hr',
        '.wp-block-separator',
    ],
    'extractor' => [Extractors::class, 'extract_separator'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress separator blocks',
    'sanity_target' => 'separator',  // v1.3.1: Maps to existing separator schema
]);

// ==========================================
// BUTTON BLOCKS
// ==========================================

PatternRegistry::register('button', [
    'selectors' => [
        '.wp-block-button',
        'a.wp-element-button',
        '.wp-block-buttons .wp-block-button__link',
    ],
    'extractor' => [Extractors::class, 'extract_button'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress button blocks',
    'sanity_target' => 'customButton',  // Maps to existing customButton schema
]);

PatternRegistry::register('buttons', [
    'selectors' => [
        '.wp-block-buttons',
    ],
    'extractor' => [Extractors::class, 'extract_buttons'],
    'priority' => 6,
    'confidence' => 0.95,
    'description' => 'WordPress button group blocks',
    'sanity_target' => 'rawHtml',  // Button groups need special handling
    'sanity_note' => 'WordPress button group - extract individual buttons',
]);

// ==========================================
// DATA BLOCKS
// ==========================================

PatternRegistry::register('table', [
    'selectors' => [
        'table',
        '.wp-block-table',
    ],
    'extractor' => [Extractors::class, 'extract_table'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress table blocks',
    'sanity_target' => 'tableBlock',  // v1.3.1: Semantic type for all tables
]);

PatternRegistry::register('code', [
    'selectors' => [
        'code',
        'pre',
        '.wp-block-code',
    ],
    'extractor' => [Extractors::class, 'extract_code'],
    'priority' => 5,
    'confidence' => 1.0,
    'description' => 'WordPress code blocks',
    'sanity_target' => 'codeBlock',  // v1.3.1: Semantic type for all code
]);

/**
 * Allow themes/plugins to modify Gutenberg patterns
 *
 * @param array $patterns Current patterns
 */
do_action('stcw_headless_gutenberg_patterns_loaded');
