<?php
/**
 * Headless Assistant Dashboard Template
 *
 * @package STCWHeadlessAssistant
 * @since 2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Calculate pattern breakdown
$stcw_headless_gutenberg = 0;
$stcw_headless_kadence   = 0;
$stcw_headless_custom    = 0;

foreach ( $patterns as $stcw_headless_pattern_name => $stcw_headless_pattern_config ) {
    if ( strpos( $stcw_headless_pattern_name, 'kadence_' ) === 0 ) {
        $stcw_headless_kadence++;
    } elseif (
        strpos( $stcw_headless_pattern_name, 'core/' ) === 0 ||
        in_array(
            $stcw_headless_pattern_name,
            array(
                'heading',
                'paragraph',
                'list',
                'quote',
                'image',
                'gallery',
                'video',
                'group',
                'columns',
                'separator',
                'button',
                'buttons',
                'table',
                'code',
            ),
            true
        )
    ) {
        $stcw_headless_gutenberg++;
    } else {
        $stcw_headless_custom++;
    }
}
?>
<style type="text/css">
/* Failsafe inline styles for layout */
.wrap .stcw-headless-grid { display: grid !important; grid-template-columns: repeat(3, 1fr) !important; gap: 20px !important; margin-bottom: 20px !important; }
.wrap .stcw-headless-layout { display: flex !important; gap: 20px !important; align-items: flex-start !important; flex-wrap: nowrap !important; }
.wrap .stcw-headless-main-content { flex: 1 1 auto !important; min-width: 0 !important; }
.wrap .stcw-headless-sidebar { width: 320px !important; flex: 0 0 320px !important; }
.wrap .stcw-headless-main-content .stcw-headless-card { margin-bottom: 20px !important; }
.wrap .stcw-headless-sidebar .stcw-headless-card { margin-bottom: 20px !important; }
.wrap .stcw-headless-main-content .stcw-headless-card:first-child { margin-top: 0 !important; }
.wrap .stcw-headless-sidebar .stcw-headless-card:first-child { margin-top: 0 !important; }
.wrap .stcw-headless-main-content .stcw-headless-card:last-child { margin-bottom: 0 !important; }
.wrap .stcw-headless-sidebar .stcw-headless-card:last-child { margin-bottom: 0 !important; }
</style>

<div class="wrap">
    <h1><?php esc_html_e( 'Headless Assistant', 'stcw-headless-assistant' ); ?></h1>

    <!-- Stats Grid (3 cards) -->
    <div class="stcw-headless-grid">

        <div class="stcw-headless-card">
            <h3><?php esc_html_e( 'CMS Target', 'stcw-headless-assistant' ); ?></h3>
            <div class="stcw-headless-value stcw-headless-good" style="font-size: 24px;">
                <?php
                $stcw_headless_first_target = reset( $targets );
                echo esc_html( $stcw_headless_first_target ? $stcw_headless_first_target->get_name() : 'None' );
                ?>
            </div>
            <div class="stcw-headless-label">
                <?php esc_html_e( 'Default export format', 'stcw-headless-assistant' ); ?>
            </div>
        </div>

        <div class="stcw-headless-card">
            <h3><?php esc_html_e( 'Source Files', 'stcw-headless-assistant' ); ?></h3>
            <div class="stcw-headless-value <?php echo $scan_stats['total_files'] > 0 ? 'stcw-headless-good' : 'stcw-headless-warning'; ?>">
                <?php echo esc_html( number_format_i18n( $scan_stats['total_files'] ) ); ?>
            </div>
            <div class="stcw-headless-label">
                <?php esc_html_e( 'Cached HTML ready to convert', 'stcw-headless-assistant' ); ?>
            </div>
        </div>

        <div class="stcw-headless-card">
            <h3><?php esc_html_e( 'Cache Size', 'stcw-headless-assistant' ); ?></h3>
            <div class="stcw-headless-value">
                <?php echo esc_html( $scan_stats['formatted_size'] ); ?>
            </div>
            <div class="stcw-headless-label">
                <?php esc_html_e( 'Total static files', 'stcw-headless-assistant' ); ?>
            </div>
        </div>
    </div>

    <div class="stcw-headless-layout">

        <!-- Main Column -->
        <div class="stcw-headless-main-content">

            <div class="stcw-headless-card">
                <h2 class="stcw-headless-panel-title"><?php esc_html_e( 'Pattern Detection System', 'stcw-headless-assistant' ); ?></h2>

                <p style="font-size: 13px; line-height: 1.6; color: #646970; margin-bottom: 20px;">
                    <?php esc_html_e( 'Detector modules analyze cached HTML and identify block patterns. Each detector adds support for specific block libraries or page builders.', 'stcw-headless-assistant' ); ?>
                </p>

                <?php
                $stcw_headless_detectors        = STCW_Headless()->get_detectors();
                $stcw_headless_builtin_count   = STCW_Headless()->get_detector_count( 'built-in' );
                $stcw_headless_premium_count   = STCW_Headless()->get_detector_count( 'premium' );
                $stcw_headless_extension_count = STCW_Headless()->get_detector_count( 'extension' );
                $stcw_headless_test_count      = STCW_Headless()->get_detector_count( 'test' );
                
                // FIXED: Only get enabled patterns (filter out disabled ones)
                $stcw_headless_patterns = array_filter(
                    \STCW\Headless\Engine\Detector\PatternRegistry::get_patterns(),
                    function($pattern) {
                        return ($pattern['enabled'] ?? true) !== false;
                    }
                );
                $stcw_headless_total_patterns  = count( $stcw_headless_patterns );
                ?>

                <!-- Stats Grid -->
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(140px, 1fr)); gap: 12px; margin-bottom: 25px;">
                    <div style="background: #f0f6fc; padding: 15px; border-radius: 4px; border-left: 3px solid #0073aa;">
                        <div style="font-size: 11px; color: #646970; text-transform: uppercase; margin-bottom: 4px;">
                            <?php esc_html_e( 'Built-in Detectors', 'stcw-headless-assistant' ); ?>
                        </div>
                        <div style="font-size: 24px; font-weight: 700; color: #0073aa;">
                            <?php echo esc_html( $stcw_headless_builtin_count ); ?>
                        </div>
                    </div>

                    <?php if ( $stcw_headless_premium_count > 0 ) : ?>
                        <div style="background: #fffbf0; padding: 15px; border-radius: 4px; border-left: 3px solid #f57c00;">
                            <div style="font-size: 11px; color: #646970; text-transform: uppercase; margin-bottom: 4px;">
                                <?php esc_html_e( 'Premium Detectors', 'stcw-headless-assistant' ); ?>
                            </div>
                            <div style="font-size: 24px; font-weight: 700; color: #f57c00;">
                                <?php echo esc_html( $stcw_headless_premium_count ); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div style="background: #f0fdf4; padding: 15px; border-radius: 4px; border-left: 3px solid #00a32a;">
                        <div style="font-size: 11px; color: #646970; text-transform: uppercase; margin-bottom: 4px;">
                            <?php esc_html_e( 'Total Patterns', 'stcw-headless-assistant' ); ?>
                        </div>
                        <div style="font-size: 24px; font-weight: 700; color: #00a32a;">
                            <?php echo esc_html( $stcw_headless_total_patterns ); ?>
                        </div>
                    </div>
                </div>

                <h3 style="font-size: 14px; font-weight: 600; margin: 20px 0 12px 0;">
                    <?php esc_html_e( 'Active Detector Modules', 'stcw-headless-assistant' ); ?>
                </h3>

                <div style="border: 1px solid #dcdcde; border-radius: 4px; overflow: hidden;">
                    <?php
                    $stcw_headless_detector_index = 0;
                    foreach ( $stcw_headless_detectors as $stcw_headless_slug => $stcw_headless_detector ) :
                        $stcw_headless_detector_index++;
                        $stcw_headless_border_bottom = $stcw_headless_detector_index < count( $stcw_headless_detectors ) ? 'border-bottom: 1px solid #f0f0f1;' : '';
                        $stcw_headless_type          = $stcw_headless_detector['type'] ?? 'extension';
                        $stcw_headless_type_label    = ucfirst( $stcw_headless_type );
                        $stcw_headless_badge_color   = '#0073aa';

                        if ( $stcw_headless_type === 'premium' ) {
                            $stcw_headless_badge_color = '#f57c00';
                        } elseif ( $stcw_headless_type === 'extension' ) {
                            $stcw_headless_badge_color = '#00a32a';
                        } elseif ( $stcw_headless_type === 'test' ) {
                            $stcw_headless_badge_color = '#646970';
                        }

                        $stcw_headless_status       = $stcw_headless_detector['status'] ?? 'active';
                        $stcw_headless_status_icon = $stcw_headless_status === 'active' ? '✓' : '○';
                        $stcw_headless_status_color = $stcw_headless_status === 'active' ? '#00a32a' : '#dcdcde';
                        ?>
                        <div style="padding: 15px; background: #fff; <?php echo esc_attr( $stcw_headless_border_bottom ); ?>">
                            <div style="display: flex; align-items: center; gap: 12px;">
                                <div style="width: 24px; height: 24px; border-radius: 50%; background: <?php echo esc_attr( $stcw_headless_status_color ); ?>; color: white; display: flex; align-items: center; justify-content: center; font-size: 14px; flex-shrink: 0;">
                                    <?php echo esc_html( $stcw_headless_status_icon ); ?>
                                </div>
                                <div style="flex: 1;">
                                    <div style="font-weight: 600; font-size: 14px; margin-bottom: 4px;">
                                        <?php echo esc_html( $stcw_headless_detector['name'] ); ?>
                                    </div>
                                    <div style="font-size: 12px; color: #646970;">
                                        <span style="background: <?php echo esc_attr( $stcw_headless_badge_color ); ?>; color: white; padding: 2px 6px; border-radius: 3px; font-size: 10px; font-weight: 600; margin-right: 8px;">
                                            <?php echo esc_html( $stcw_headless_type_label ); ?>
					</span>
					<?php
					echo esc_html( sprintf(
					    /* translators: 1: number of patterns, 2: detector version */
					    __( '%1$d patterns • v%2$s', 'stcw-headless-assistant' ),
					    number_format_i18n( (int) ( $stcw_headless_detector['patterns'] ?? 0 ) ),
					    $stcw_headless_detector['version'] ?? 'N/A'
					) );
					?>
                                    </div>
                                    <?php if ( ! empty( $stcw_headless_detector['description'] ) ) : ?>
                                        <div style="font-size: 12px; color: #787c82; margin-top: 6px;">
                                            <?php echo esc_html( $stcw_headless_detector['description'] ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <details style="margin-top: 20px; border-top: 1px solid #ddd; padding-top: 15px;">
                    <summary style="cursor: pointer; font-weight: 600; color: #2271b1; font-size: 13px;">
                        <?php esc_html_e( 'View All Registered Patterns', 'stcw-headless-assistant' ); ?> (<?php echo esc_html( $stcw_headless_total_patterns ); ?>)
                    </summary>
                    <div style="margin-top: 15px; display: grid; grid-template-columns: repeat(auto-fill, minmax(180px, 1fr)); gap: 8px;">
                        <?php foreach ( $stcw_headless_patterns as $stcw_headless_pattern_name => $stcw_headless_pattern_config ) : ?>
                            <div style="background: #f6f7f7; padding: 8px 12px; border-radius: 3px; font-size: 12px;">
                                <code style="background: transparent;"><?php echo esc_html( $stcw_headless_pattern_name ); ?></code>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </details>

                <div style="margin-top: 20px; padding: 12px; background: #f0f6fc; border-left: 3px solid #0073aa; border-radius: 3px;">
                    <p style="margin: 0; font-size: 12px; line-height: 1.6;">
                        <strong><?php esc_html_e( 'Need more patterns?', 'stcw-headless-assistant' ); ?></strong><br>
                        <?php esc_html_e( 'Install premium detector plugins to add support for page builders (Elementor, Divi, Bricks) and premium block libraries (Otter, Spectra, Stackable).', 'stcw-headless-assistant' ); ?>
                    </p>
                </div>
            </div>

            <div class="stcw-headless-card">
                <h2 class="stcw-headless-panel-title">
                    <?php esc_html_e( 'How to Use', 'stcw-headless-assistant' ); ?>
                </h2>

                <ol style="font-size: 13px; line-height: 1.6; color: #1d2327; margin-left: 18px;">
                    <li>
                        <?php esc_html_e(
                            'Run Static Cache Wrangler to generate a full static cache of your site.',
                            'stcw-headless-assistant'
                        ); ?>
                    </li>
                    <li>
                        <?php esc_html_e(
                            'Optionally install the Coverage Assistant Companion plugin to ensure all pages, routes, and variations are cached.',
                            'stcw-headless-assistant'
                        ); ?>
                    </li>
                    <li>
                        <?php esc_html_e(
                            'Use WP-CLI commands to analyze and normalize cached HTML, inventory detected patterns, and generate a starting schema and JSON files for your target headless CMS.',
                            'stcw-headless-assistant'
			); ?>
		    </li>
		    <li>
    		    	<?php
    			    printf(
        		    /* translators: %s: link to wp2headless.com */
        		    esc_html__(
            		    'Detailed documentation, upcoming pattern detectors, and CMS targets will be published at %s.',
            		    'stcw-headless-assistant'
        		    ),
        		    '<a href="' . esc_url( 'https://wp2headless.com' ) . '" target="_blank" rel="noopener noreferrer">wp2headless.com</a>'
		        );
		        ?>
		    </li>
                </ol>

                <h3 style="font-size: 13px; font-weight: 600; margin: 16px 0 8px;">
                    <?php esc_html_e( 'Available WP-CLI Commands', 'stcw-headless-assistant' ); ?>
                </h3>

                <div style="background: #f6f7f7; border-left: 3px solid #2271b1; padding: 12px; border-radius: 3px;">
                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless analyze &lt;file&gt; [--pattern=&lt;name&gt;] [--format=&lt;format&gt;] [--verbose] [--min-confidence=&lt;float&gt;]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless convert [--cms=&lt;target&gt;] [--limit=&lt;number&gt;] [--verbose]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless detectors [--format=&lt;format&gt;] [--type=&lt;type&gt;]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless info [--format=&lt;format&gt;]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless normalize &lt;file&gt; [--output=&lt;path&gt;] [--stats]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless patterns [--format=&lt;format&gt;] [--enabled-only] [--verbose]
                    </code>

                    <code style="font-size: 12px; display: block; margin-bottom: 6px;">
                        wp scw-headless scan [--format=&lt;format&gt;]
                    </code>

                    <code style="font-size: 12px; display: block;">
                        wp scw-headless targets [--format=&lt;format&gt;]
                    </code>
                </div>
            </div>

        </div>

        <!-- Sidebar -->
        <div class="stcw-headless-sidebar">

            <div class="stcw-headless-card">
                <h2 class="stcw-headless-panel-title"><?php esc_html_e( 'About', 'stcw-headless-assistant' ); ?></h2>
                <p style="font-size:13px;line-height:1.6;">
                    <?php esc_html_e( 'Convert Static Cache Wrangler output to headless CMS import formats.', 'stcw-headless-assistant' ); ?>
                </p>
                <p style="font-size:13px;line-height:1.6;margin-top:10px;">
                    <?php esc_html_e( 'This plugin is CLI-first. Use WP-CLI commands for conversion operations.', 'stcw-headless-assistant' ); ?>
                </p>
            </div>

            <div class="stcw-headless-card">
                <h2 class="stcw-headless-panel-title"><?php esc_html_e( 'WP-CLI Commands', 'stcw-headless-assistant' ); ?></h2>
                <p style="font-size:13px;line-height:1.6;margin-bottom:12px;">
                    <?php esc_html_e( 'Convert cached files to CMS format:', 'stcw-headless-assistant' ); ?>
                </p>
                <div style="background:#f6f7f7;border-left:3px solid #2271b1;padding:12px;border-radius:3px;">
                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless targets</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'List available CMS targets', 'stcw-headless-assistant' ); ?>
		    </p>

                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless info</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'General status information', 'stcw-headless-assistant' ); ?>
                    </p>

                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless detectors</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'List installed detectors', 'stcw-headless-assistant' ); ?>
                    </p>

                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless scan</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'List cached HTML files', 'stcw-headless-assistant' ); ?>
		    </p>

		    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless patterns</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'Installed pattern inventory', 'stcw-headless-assistant' ); ?>
		    </p>

                   <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless analyze</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0 0 8px 0;line-height:1.4;">
                        <?php esc_html_e( 'Create analysis report', 'stcw-headless-assistant' ); ?>
                    </p>

                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless convert --cms=sanity</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0;line-height:1.4;">
                        <?php esc_html_e( 'Convert to Sanity format', 'stcw-headless-assistant' ); ?>
                    </p>

                    <code style="font-size:12px;display:block;margin-bottom:6px;color:#1d2327;">
                        <strong>wp scw-headless normalize</strong>
                    </code>
                    <p style="font-size:12px;color:#646970;margin:0;line-height:1.4;">
                        <?php esc_html_e( 'Normalize removing WP tags', 'stcw-headless-assistant' ); ?>
                    </p>
                </div>
            </div>

        </div>
    </div>
</div>
