<?php
/**
 * Admin Dashboard
 *
 * Handles admin interface for headless assistant
 *
 * @package STCWHeadlessAssistant
 * @since 2.0.0
 */

namespace STCW\Headless;

if (!defined('ABSPATH')) exit;

class Admin {

    /**
     * Initialize admin functionality
     */
    public function init() {
        add_action('admin_menu', [$this, 'add_submenu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    /**
     * Add submenu page under Static Cache menu
     */
    public function add_submenu() {
        add_submenu_page(
            'static-cache-wrangler',
            __('Headless Assistant', 'stcw-headless-assistant'),
            __('Headless Assistant', 'stcw-headless-assistant'),
            'manage_options',
            'stcw-headless-assistant',
            [$this, 'render_page']
        );
    }

    /**
     * Enqueue admin scripts and styles
     *
     * @param string $hook Current admin page hook
     */
    public function enqueue_assets($hook) {
        if ($hook !== 'static-cache_page_stcw-headless-assistant') {
            return;
        }

        wp_enqueue_style(
            'stcw-headless-admin-style',
            STCW_HEADLESS_URL . 'admin/css/admin-style.css',
            [],
            STCW_HEADLESS_VERSION
        );

        wp_enqueue_script(
            'stcw-headless-admin-script',
            STCW_HEADLESS_URL . 'admin/js/admin-script.js',
            ['jquery'],
            STCW_HEADLESS_VERSION,
            true
        );
    }

    /**
     * Render the admin page
     */
    public function render_page() {
        if (!current_user_can('manage_options')) {
            wp_die(
                esc_html__('You do not have sufficient permissions to access this page.', 'stcw-headless-assistant')
            );
        }

        $scanner = new Scanner();
        $scan_stats = $scanner->get_scan_stats();
        
        $targets = Engine\Target\TargetRegistry::get_all();
        $patterns = Engine\Detector\PatternRegistry::get_patterns();

        require_once STCW_HEADLESS_DIR . 'admin/views/dashboard.php';
    }
}
