<?php

if (! defined('ABSPATH')) exit; // Exit if accessed directly 


class starplus_addon_for_elementor_card_slider extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'star-addon-card-slider';
    }
    public function get_title()
    {
        return esc_html__('Slider', 'star-plus-addon-for-elementor');
    }


    public function get_icon()
    {
        return 'eicon-slider-push';
    }


    public function get_categories()
    {
        return ['starplus-addon'];
    }


    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'slide_title',
            [
                'label' => esc_html__('Title', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Title', 'star-plus-addon-for-elementor'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'slide_button',
            [
                'label' => esc_html__('Button Text', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Click Me', 'star-plus-addon-for-elementor'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]


        );
        $repeater->add_control(
            'slide_content',
            [
                'label' => esc_html__('Content', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'star-plus-addon-for-elementor'),
                'show_label' => false,
            ]
        );
        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://example.com', 'star-plus-addon-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );



        $this->add_control(
            'list',
            [
                'label' => esc_html__('Icon Card', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__('slide #1', 'star-plus-addon-for-elementor'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'star-plus-addon-for-elementor'),
                    ],
                    [
                        'list_title' => esc_html__('slide #2', 'star-plus-addon-for-elementor'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'star-plus-addon-for-elementor'),
                    ],
                    [
                        'list_title' => esc_html__('slide #3', 'star-plus-addon-for-elementor'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'star-plus-addon-for-elementor'),
                    ],
                    [
                        'list_title' => esc_html__('slide #4', 'star-plus-addon-for-elementor'),
                        'list_content' => esc_html__('Item content. Click the edit button to change this text.', 'star-plus-addon-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();


        // for slide
        $this->start_controls_section(
            'slide_section',
            [
                'label' => esc_html__('Slide', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'slide_width',
            [
                'label' => esc_html__('Width', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400, // Default width
                ],
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'slide_height',
            [
                'label' => esc_html__('Height', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 490, // Default width
                ],
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );




        $this->end_controls_section();
        // for button
        $this->start_controls_section(
            'button_section',
            [
                'label' => esc_html__('Button', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typo',
                'label' => esc_html__('Heading Typography', 'star-plus-addon-for-elementor'),
                'selector' => '{{WRAPPER}} .starplus-addon-for-elementor .swiper .cost', // Adjust the heading selector as needed
            ]
        );

        $this->add_control(
            'buttontext_color',
            [
                'label' => esc_html__('Text Color', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .cost' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'buttonbg_color',
            [
                'label' => esc_html__('Background Color', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .cost' => 'background-color: {{VALUE}};',
                ],
            ]
        );



        $this->end_controls_section();


        // for heading
        $this->start_controls_section(
            'heading_section',
            [
                'label' => esc_html__('Heading', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typo',
                'label' => esc_html__('Heading Typography', 'star-plus-addon-for-elementor'),
                'selector' => '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide h1', // Adjust the heading selector as needed
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__('Heading Color', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide h1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        // for paragraph
        $this->start_controls_section(
            'paragraph_section',
            [
                'label' => esc_html__('Content', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typo',
                'label' => esc_html__('Heading Typography', 'star-plus-addon-for-elementor'),
                'selector' => '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide p', // Adjust the heading selector as needed
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Heading Color', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // for overlay
        $this->start_controls_section(
            'overlay_section',
            [
                'label' => esc_html__('Overlay', 'star-plus-addon-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'Overlay_height',
            [
                'label' => esc_html__('Height', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150, // Default width
                ],
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide .overlay' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'overlaybg_color',
            [
                'label' => esc_html__('Content Background Color', 'star-plus-addon-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide .overlay' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .starplus-addon-for-elementor .swiper .swiper-slide .overlay',
            ]
        );

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="starplus-addon-for-elementor">


            <div class="swiper">
                <div class="swiper-wrapper">
                    <?php
                    if ($settings['list']) {
                        foreach ($settings['list'] as $item) {
                            error_log(json_encode($item));
                    ?>
                            <div class="swiper-slide">
                                <img src="<?php echo $item['image']['url'] ?> " />
                                <div> <a class="cost" href="<?php echo $item['btn_link']['url'] ?> "><?php echo $item['slide_button'] ?> </a> </div>
                                <div class="overlay">
                                    <h1><?php echo $item['slide_title'] ?> </h1>
                                    <p>
                                        <?php echo $item['slide_content'] ?>
                                    </p>

                                </div>
                            </div>
                    <?php }
                    } ?>

                </div>

            </div>

        </div>
<?php

    }
}
