jQuery(document).ready(function ($) {
  // --- Logic to test SSO configuration ---
  $("#test-jumpcloud-sso-config").on("click", function (e) {
    e.preventDefault();
    var $button = $(this);
    var $spinner = $('<span class="spinner is-active"></span>');
    var $container = $("#jumpssco-test-result-container");

    $button.prop("disabled", true).after($spinner);
    $container.empty();

    $.ajax({
      url: jumpssco_admin.ajax_url,
      type: "POST",
      data: {
        action: "jumpssco_test_sso_config",
        security: jumpssco_admin.nonce,
      },
      dataType: "json",
      success: function (response) {
        var noticeClass = response.success ? "notice-success" : "notice-error";
        var noticeMsg = response.data || "Unknown error occurred";
        $container.html('<div class="' + noticeClass + '"><p><strong>' + noticeMsg + "</strong></p></div>");
      },
      error: function (xhr) {
        var errorMsg = "Error: Unable to test configuration.";
        if (xhr.responseJSON && xhr.responseJSON.data) {
            errorMsg = xhr.responseJSON.data;
        }
        $container.html('<div class="notice-error"><p><strong>' + errorMsg + "</strong></p></div>");
      },
      complete: function () {
        $spinner.remove();
        $button.prop("disabled", false);
        $("html, body").animate({ scrollTop: $container.offset().top - 100 }, 300);
      }
    });
  });

  // --- UI Enhancements ---

  // 1. Create Toggleable Descriptions
  $('.form-table tr').each(function() {
    var $row = $(this);
    var $label = $row.find('th');
    var $description = $row.find('td p.description');

    if ($description.length && $label.length) {
      $description.hide();
      var $toggleIcon = $('<span class="jc-toggle-icon" tabindex="0" role="button" aria-label="Toggle description"><span class="dashicons dashicons-info-outline"></span></span>');
      $label.append($toggleIcon);
      $toggleIcon.on('click keypress', function(e) {
        if (e.type === 'click' || (e.type === 'keypress' && (e.which === 13 || e.which === 32))) {
          e.preventDefault();
          $description.slideToggle(200);
          $(this).toggleClass('is-active');
        }
      });
    }
  });

  // 2. Copy-to-Clipboard for SP Metadata
  $('body').on('click', '.jc-copy-button', function(e) {
    e.preventDefault();
    var $button = $(this);
    var textToCopy = $button.data('copy-text');

    // Modern async clipboard API, available in secure contexts (HTTPS, localhost)
    if (navigator.clipboard && window.isSecureContext) {
      navigator.clipboard.writeText(textToCopy).then(function() {
        showCopyFeedback($button);
      }).catch(function(err) {
        console.error('Async: Could not copy text: ', err);
      });
    } else {
      // Fallback for older browsers or non-secure contexts (HTTP)
      var textArea = document.createElement("textarea");
      textArea.value = textToCopy;
      textArea.style.position = 'fixed'; // Prevent scrolling to bottom
      textArea.style.opacity = '0';
      document.body.appendChild(textArea);
      textArea.focus();
      textArea.select();

      try {
        var successful = document.execCommand('copy');
        if (successful) {
          showCopyFeedback($button);
        }
      } catch (err) {
        console.error('Fallback: Oops, unable to copy', err);
      }

      document.body.removeChild(textArea);
    }
  });

  function showCopyFeedback($button) {
    var originalIcon = $button.find('.dashicons').attr('class');
    $button.find('.dashicons').attr('class', 'dashicons dashicons-yes-alt');
    $button.prop('disabled', true);
    
    setTimeout(function() {
      $button.find('.dashicons').attr('class', originalIcon);
      $button.prop('disabled', false);
    }, 1500);
  }
});