/**
 * donutty // Create SVG donut charts with Javascript
 * @author simeydotme <simey.me@gmail.com>
 * @version 2.0.0
 * @license ISC
 * @link http://simey.me
 * @preserve
 */
!function(e,t){var i,o="http://www.w3.org/2000/svg";function n(t){return void 0!==t}function s(t){return parseFloat(t,10)}function r(t){return n(t)&&(!0===t||"true"===t)}(i=t.Donutty=function(t,i){return t&&"string"==typeof t?this.$wrapper=e.querySelectorAll(t)[0]:t instanceof window.HTMLElement?this.$wrapper=t:(this.$wrapper=e.body,i=t),this.$wrapper&&(n(i)||(i=this.getOptionsFromTag()),this.state={},this.options=i||{},this.options.min=n(this.options.min)?s(this.options.min):0,this.options.max=n(this.options.max)?s(this.options.max):100,this.options.value=n(this.options.value)?s(this.options.value):50,this.options.round=!n(this.options.round)||r(this.options.round),this.options.circle=!n(this.options.circle)||r(this.options.circle),this.options.padding=n(this.options.padding)?s(this.options.padding):4,this.options.radius=s(this.options.radius)||50,this.options.thickness=s(this.options.thickness)||10,this.options.bg=this.options.bg||"rgba(70, 130, 180, 0.15)",this.options.color=this.options.color||"mediumslateblue",this.options.transition=this.options.transition||"all 1.2s cubic-bezier(0.57, 0.13, 0.18, 0.98)",this.options.text=!!n(this.options.text)&&this.options.text,this.init()),this}).prototype.getOptionsFromTag=function(){return JSON.parse(JSON.stringify(this.$wrapper.dataset))},i.prototype.init=function(){var t;return(this.$wrapper.donutty=this).createState(),t=this.getDashValues(),this.createSvg(),this.createBg(t),this.createDonut(t),this.createText(),this.insertFragments(t),this},i.prototype.createState=function(){return this.state.min=this.options.min,this.state.max=this.options.max,this.state.value=this.options.value,this.state.bg=this.options.bg,this.state.color=this.options.color,this},i.prototype.createText=function(){return"function"==typeof this.options.text&&(this.$text=e.createElement("span"),this.$text.setAttribute("class","donut-text"),this.$text.style.opacity=0,this.updateText()),this},i.prototype.createBg=function(t){return this.$bg=e.createElementNS(o,"circle"),this.$bg.setAttribute("cx","50%"),this.$bg.setAttribute("cy","50%"),this.$bg.setAttribute("r",this.options.radius),this.$bg.setAttribute("fill","transparent"),this.$bg.setAttribute("stroke",this.state.bg),this.$bg.setAttribute("stroke-width",this.options.thickness+this.options.padding),this.$bg.setAttribute("stroke-dasharray",t.full*t.multiplier),this.$bg.setAttribute("class","donut-bg"),this.options.round&&this.$bg.setAttribute("stroke-linecap","round"),this},i.prototype.createDonut=function(t){return this.$donut=e.createElementNS(o,"circle"),this.$donut.setAttribute("fill","transparent"),this.$donut.setAttribute("cx","50%"),this.$donut.setAttribute("cy","50%"),this.$donut.setAttribute("r",this.options.radius),this.$donut.setAttribute("stroke",this.state.color),this.$donut.setAttribute("stroke-width",this.options.thickness),this.$donut.setAttribute("stroke-dashoffset",t.full),this.$donut.setAttribute("stroke-dasharray",t.full),this.$donut.setAttribute("class","donut-fill"),this.$donut.style.opacity=0,this.options.round&&this.$donut.setAttribute("stroke-linecap","round"),this},i.prototype.createSvg=function(){var t=2*this.options.radius+this.options.thickness+2*this.options.padding,i=this.options.round?this.options.thickness/3:0,s=this.options.circle?90+i:-225;return this.$html=e.createDocumentFragment(),this.$svg=e.createElementNS(o,"svg"),this.$svg.setAttribute("xmlns",o),this.$svg.setAttribute("viewbox","0 0 "+t+" "+t),this.$svg.setAttribute("transform","rotate( "+s+" )"),this.$svg.setAttribute("preserveAspectRatio","xMidYMid meet"),this.$svg.setAttribute("class","donut"),this},i.prototype.insertFragments=function(t){this.$svg.appendChild(this.$bg),this.$svg.appendChild(this.$donut),this.$html.appendChild(this.$svg),this.$text&&this.$html.appendChild(this.$text),this.$wrapper.appendChild(this.$html),this.$wrapper.innerHTML=this.$wrapper.innerHTML,this.$svg=this.$wrapper.querySelector(".donut"),this.$bg=this.$wrapper.querySelector(".donut-bg"),this.$donut=this.$wrapper.querySelector(".donut-fill"),this.$text&&(this.$text=this.$wrapper.querySelector(".donut-text")),this.animate(t.fill,t.full)},i.prototype.getDashValues=function(){var t,i,s,e;return e=this.options.circle?1:.75,s=(t=2*Math.PI*this.options.radius)-t*e/100*(i=(this.state.value-this.state.min)/(this.state.max-this.state.min)*100),this.options.round&&this.options.circle&&i<100&&s<this.options.thickness&&(s=this.options.thickness),{fill:s,full:t,multiplier:e}},i.prototype.animate=function(t,i){var s=this;s.$bg.style.transition=this.options.transition,s.$donut.style.transition=this.options.transition,s.$text&&(s.$text.style.transition=this.options.transition),window.setTimeout(function(){s.$bg.setAttribute("stroke",s.state.bg),s.$bg.style.opacity=1,s.$donut.setAttribute("stroke-dashoffset",t),s.$donut.setAttribute("stroke-dasharray",i),s.$donut.setAttribute("stroke",s.state.color),s.$donut.style.opacity=1,s.$text&&(s.$text.style.opacity=1)},16)},i.prototype.updateText=function(){return"function"==typeof this.options.text&&(this.$text.innerHTML=this.options.text(this.state)),this},i.prototype.set=function(t,i){var s;return n(t)&&n(i)&&(this.state[t]=i,s=this.getDashValues(),this.updateText(),this.animate(s.fill,s.full)),this},i.prototype.setState=function(t){var i;return n(t.value)&&(this.state.value=t.value),n(t.min)&&(this.state.min=t.min),n(t.max)&&(this.state.max=t.max),n(t.bg)&&(this.state.bg=t.bg),n(t.color)&&(this.state.color=t.color),i=this.getDashValues(),this.updateText(),this.animate(i.fill,i.full),this}}(document,window),function(i,s){void 0!==window.$?s(function(){s.fn.donutty=function(t){return s(this).each(function(){new i(this,t)})},s("[data-donutty]").donutty()}):console.warn("Can't find jQuery to attach Donutty")}(Donutty,jQuery);