<?php
/**
 * Plugin Name: SS Dynamic Filter for Oxygen
 * Plugin URI: https://websolutioncare.com/
 * Description: A professional AJAX filtering suite for Oxygen Builder. Features: Search, Chips, Color Swatches, Price Range, and Native Oxygen Elements.
 * Version: 1.0.1
 * Author: Shemul
 * Author URI: https://shemuls.com
 * Text Domain: ss-dynamic-filter-for-oxygen
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * License: GPL v2 or later
 */

// Prevent direct access to this file
if (!defined('ABSPATH')) {
    exit;
}

// Define Plugin Constants
define('SSDF_VERSION', '1.0.1');
define('SSDF_PATH', plugin_dir_path(__FILE__));
define('SSDF_URL', plugin_dir_url(__FILE__));

/**
 * Main Plugin Class
 */
final class SSDF_Dynamic_Filters
{

    /**
     * Singleton instance
     */
    private static $instance = null;

    /**
     * Get the singleton instance
     */
    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor: Define hooks and includes
     */
    public function __construct()
    {
        $this->includes();
        $this->init_hooks();
    }

    /**
     * Include required core files
     */
    private function includes()
    {
        require_once SSDF_PATH . 'includes/class-term-meta.php'; // Handle Color Meta
        require_once SSDF_PATH . 'includes/class-admin.php'; // Admin Dashboard
        require_once SSDF_PATH . 'includes/class-frontend.php'; // Frontend Engine
        require_once SSDF_PATH . 'includes/class-indexer.php'; // High Performance Indexer
    }

    /**
     * Initialize hooks
     */
    private function init_hooks()
    {
        // Initialize Core Classes
        add_action('plugins_loaded', [$this, 'init_classes']);

        // Register Oxygen Elements (Only if Oxygen is active)
        add_action('init', [$this, 'register_oxygen_elements'], 20);

        // Register URL Rewrites (e.g. /filter/color-red/)
        add_action('init', [$this, 'register_rewrites']);
    }

    /**
     * Register the "filter" endpoint for SEO friendly URLs
     * Added EP_ALL_ARCHIVES to support Shop/Category/Archive pages
     */
    public function register_rewrites()
    {
        add_rewrite_endpoint('filter', EP_PAGES | EP_PERMALINK | EP_ROOT | EP_ALL_ARCHIVES);
    }

    /**
     * Instantiate classes after plugins are loaded
     */
    public function init_classes()
    {
        new SSDF_Filters_Term_Meta();
        new SSDF_Filters_Admin();
        new SSDF_Filters_Indexer();
        // Initialize Frontend Singleton
        SSDF_Filters_Frontend::get_instance();
    }

    /**
     * Register Custom Elements for Oxygen Builder
     */
    public function register_oxygen_elements()
    {
        if (class_exists('OxyEl')) {
            require_once SSDF_PATH . 'includes/elements/class-ssdf-dynamic-filter-el.php';
            require_once SSDF_PATH . 'includes/elements/class-ssdf-active-filters-el.php';
        }
    }
}

// Kick off the plugin
SSDF_Dynamic_Filters::get_instance();

// Flush rules on activation to apply new EP_ALL_ARCHIVES rule
register_activation_hook(__FILE__, function () {
    add_rewrite_endpoint('filter', EP_PAGES | EP_PERMALINK | EP_ROOT | EP_ALL_ARCHIVES);
    flush_rewrite_rules();
});
register_deactivation_hook(__FILE__, 'flush_rewrite_rules');