<?php
if (!defined('ABSPATH'))
    exit;

if (class_exists('OxyEl')):

    class SSDF_Dynamic_Filter_El extends OxyEl
    {

        public function name()
        {
            return 'Dynamic Filter';
        }
        public function slug()
        {
            return 'ssdf_dynamic_filter_el';
        }
        public function icon()
        {
            return 'dashicons-filter';
        }

        public function controls()
        {

            // --- 1. DATA SOURCE CONTROLS ---
            $filters = get_posts([
                'post_type' => 'ssdf_filter',
                'numberposts' => -1,
                'post_status' => 'publish'
            ]);

            $filter_options = [];
            if ($filters) {
                foreach ($filters as $f) {
                    $filter_options[$f->ID] = $f->post_title . ' (ID: ' . $f->ID . ')';
                }
            } else {
                $filter_options[''] = 'No Filters Found';
            }

            $this->addOptionControl([
                "type" => 'dropdown',
                "name" => 'Select Filter',
                "slug" => 'filter_id',
                "value" => $filter_options,
                "default" => ""
            ]);

            $this->addOptionControl([
                "type" => 'textfield',
                "name" => 'Repeater ID',
                "slug" => 'repeater_id',
                "placeholder" => "_dynamic_list-27-96"
            ]);

            // --- 2. LAYOUT CONTROLS ---
            $layout_section = $this->addControlSection("Layout", "Layout", "assets/icon.png", $this);
            $selector_wrap = ".s-ssdf-filter-wrap";

            $layout_section->addStyleControls([
                [
                    "selector" => $selector_wrap,
                    "property" => "display",
                    "default" => "flex"
                ],
                [
                    "selector" => $selector_wrap,
                    "property" => "flex-direction",
                    "name" => "Direction"
                ],
                [
                    "selector" => $selector_wrap,
                    "property" => "gap",
                    "name" => "Gap"
                ],
                [
                    "selector" => $selector_wrap,
                    "property" => "align-items",
                    "name" => "Alignment",
                ],
                [
                    "selector" => $selector_wrap,
                    "property" => "flex-wrap",
                    "name" => "Wrap"
                ]
            ]);

            // --- 3. TYPOGRAPHY ---
            $typo_section = $this->addControlSection("Typography", "Typography", "assets/icon.png", $this);
            $selector_text = ".s-ssdf-filter-btn, .s-ssdf-input-label, .s-ssdf-filter-select, .s-ssdf-search-input";

            $typo_section->addStyleControls([
                ["selector" => $selector_text, "property" => 'font-family'],
                ["selector" => $selector_text, "property" => 'font-size'],
                ["selector" => $selector_text, "property" => 'font-weight'],
                ["selector" => $selector_text, "property" => 'color'],
                ["selector" => $selector_text, "property" => 'line-height'],
                ["selector" => $selector_text, "property" => 'letter-spacing'],
            ]);

            // --- 4. CHECKBOXES ---
            $check_section = $this->addControlSection("Checkboxes", "Checkboxes", "assets/icon.png", $this);
            $selector_input = ".s-ssdf-input-label input";

            $check_section->addStyleControls([
                ["selector" => $selector_input, "property" => 'width', "name" => "Width"],
                ["selector" => $selector_input, "property" => 'height', "name" => "Height"],
                ["selector" => $selector_input, "property" => 'background-color'],
                ["selector" => $selector_input, "property" => 'border-color'],
                ["selector" => $selector_input, "property" => 'border-radius'],
                ["selector" => $selector_input, "property" => 'border-width'],
                ["selector" => $selector_input, "property" => 'border-style'],
            ]);

            $check_active = $this->addControlSection("Checkbox Active", "Checked State", "assets/icon.png", $this);
            $selector_checked = ".s-ssdf-input-label input:checked";

            $check_active->addStyleControls([
                ["selector" => $selector_checked, "property" => 'background-color', "control_type" => 'colorpicker'],
                ["selector" => $selector_checked, "property" => 'border-color', "control_type" => 'colorpicker'],
            ]);

            // --- 5. SLIDER STYLES (NEW) ---
            $slider_section = $this->addControlSection("Slider", "Slider Styles", "assets/icon.png", $this);
            $selector_bar = ".noUi-connect";
            $selector_handle = ".noUi-handle";

            $slider_section->addStyleControls([
                ["name" => "Bar Color", "selector" => $selector_bar, "property" => 'background-color'],
                ["name" => "Handle Color", "selector" => $selector_handle, "property" => 'background-color'],
                ["name" => "Handle Border", "selector" => $selector_handle, "property" => 'border-color'],
                ["name" => "Handle Border Width", "selector" => $selector_handle, "property" => 'border-width'],
                ["name" => "Handle Radius", "selector" => $selector_handle, "property" => 'border-radius'],
            ]);

            // --- 6. BUTTONS ---
            $btn_section = $this->addControlSection("Buttons", "Buttons", "assets/icon.png", $this);
            $selector_btn = ".s-ssdf-filter-btn";

            $btn_section->addStyleControls([
                ["selector" => $selector_btn, "property" => 'background-color'],
                ["selector" => $selector_btn, "property" => 'color'],
                ["selector" => $selector_btn, "property" => 'border-color'],
                ["selector" => $selector_btn, "property" => 'border-width'],
                ["selector" => $selector_btn, "property" => 'border-style'],
                ["selector" => $selector_btn, "property" => 'border-radius'],
                ["selector" => $selector_btn, "property" => 'padding-top'],
                ["selector" => $selector_btn, "property" => 'padding-bottom'],
                ["selector" => $selector_btn, "property" => 'padding-left'],
                ["selector" => $selector_btn, "property" => 'padding-right'],
                ["selector" => $selector_btn, "property" => 'margin-top'],
                ["selector" => $selector_btn, "property" => 'margin-bottom'],
                ["selector" => $selector_btn, "property" => 'margin-left'],
                ["selector" => $selector_btn, "property" => 'margin-right'],
            ]);

            $btn_active = $this->addControlSection("Button Active", "Button Active", "assets/icon.png", $this);
            $selector_btn_active = ".s-ssdf-filter-btn.active";

            $btn_active->addStyleControls([
                ["selector" => $selector_btn_active, "property" => 'background-color'],
                ["selector" => $selector_btn_active, "property" => 'color'],
                ["selector" => $selector_btn_active, "property" => 'border-color'],
            ]);
        }

        public function render($options, $defaults, $content)
        {
            $filter_id = isset($options['filter_id']) ? $options['filter_id'] : '';
            $rep_id = isset($options['repeater_id']) ? $options['repeater_id'] : '';

            if (empty($filter_id)) {
                echo '<div class="oxy-placeholder" style="padding: 20px; background: #f0f0f0; text-align:center;">Select a Filter to render.</div>';
            } else {
                if (class_exists('SSDF_Filters_Frontend')) {
                    // Wrap in the same class used by controls
                    echo '<div class="s-ssdf-filter-wrapper-oxy-el">';
                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    // Define allowed tags for filters (inputs, selects, buttons)
                    $allowed_html = [
                        'div' => ['class' => [], 'id' => [], 'data-source' => [], 'data-tax-label' => [], 'data-repeater-id' => [], 'data-min' => [], 'data-max' => [], 'style' => []],
                        'span' => ['class' => [], 'style' => []],
                        'input' => ['type' => [], 'class' => [], 'id' => [], 'name' => [], 'value' => [], 'placeholder' => [], 'data-label' => [], 'checked' => [], 'disabled' => []],
                        'select' => ['class' => [], 'name' => [], 'id' => [], 'data-selected' => [], 'multiple' => [], 'style' => []],
                        'option' => ['value' => [], 'selected' => [], 'data-label' => []],
                        'label' => ['class' => []],
                        'button' => ['class' => [], 'data-slug' => [], 'data-label' => [], 'title' => []],
                    ];
                    echo wp_kses(SSDF_Filters_Frontend::get_instance()->generate_filter_html($filter_id, $rep_id), $allowed_html);
                    echo '</div>';
                } else {
                    echo 'Error: Filter Frontend class not found.';
                }
            }
        }
    }

    new SSDF_Dynamic_Filter_El();
endif;