<?php
if (!defined('ABSPATH'))
	exit;

if (class_exists('OxyEl')):

	class SSDF_Active_Filters_El extends OxyEl
	{

		public function name()
		{
			return 'Active Filters (Chips)';
		}
		public function slug()
		{
			return 'ssdf_active_filters_el';
		}
		public function icon()
		{
			return 'dashicons-dismiss';
		}

		public function controls()
		{

			// --- 1. DATA CONTROLS ---
			$this->addOptionControl([
				"type" => 'textfield',
				"name" => 'Repeater ID',
				"slug" => 'repeater_id',
				"placeholder" => "_dynamic_list-27-96"
			]);

			$this->addOptionControl([
				"type" => 'dropdown',
				"name" => 'Show Labels?',
				"slug" => 'show_labels',
				"value" => ['yes' => 'Yes (Category: Accessories)', 'no' => 'No (Accessories)'],
				"default" => 'yes'
			]);

			// --- 2. LAYOUT CONTROLS ---
			$layout_section = $this->addControlSection("Layout", "Layout", "assets/icon.png", $this);
			$selector_wrap = ".s-ssdf-active-filters-wrap";

			$layout_section->addStyleControls([
				[
					"selector" => $selector_wrap,
					"property" => "display",
					"default" => "flex",
				],
				[
					"selector" => $selector_wrap,
					"property" => "flex-direction",
					"name" => "Direction"
				],
				[
					"selector" => $selector_wrap,
					"property" => "gap",
					"name" => "Gap"
				],
				[
					"selector" => $selector_wrap,
					"property" => "align-items",
					"name" => "Alignment",
				],
				[
					"selector" => $selector_wrap,
					"property" => "flex-wrap",
					"name" => "Wrap"
				]
			]);

			// --- 3. CHIP STYLE ---
			$chip_section = $this->addControlSection("Chips", "Chip Style", "assets/icon.png", $this);
			$selector = ".s-ssdf-chip";

			$chip_section->addStyleControls([
				["selector" => $selector, "property" => 'background-color'],
				["selector" => $selector, "property" => 'color'],
				["selector" => $selector, "property" => 'font-size'],
				["selector" => $selector, "property" => 'font-weight'],
				["selector" => $selector, "property" => 'border-radius'],
				["selector" => $selector, "property" => 'padding-top'],
				["selector" => $selector, "property" => 'padding-bottom'],
				["selector" => $selector, "property" => 'padding-left'],
				["selector" => $selector, "property" => 'padding-right'],
				["selector" => $selector, "property" => 'border-color'],
				["selector" => $selector, "property" => 'border-width'],
				["selector" => $selector, "property" => 'border-style'],
			]);

			// --- 4. CLEAR BUTTON ---
			$clear_section = $this->addControlSection("Clear Button", "Clear Button", "assets/icon.png", $this);
			$selector_clear = ".s-ssdf-clear-all";

			$clear_section->addStyleControls([
				["selector" => $selector_clear, "property" => 'color'],
				["selector" => $selector_clear, "property" => 'font-size'],
				["selector" => $selector_clear, "property" => 'font-weight'],
				["selector" => $selector_clear, "property" => 'text-decoration'],
				["selector" => $selector_clear, "property" => 'margin-left'],
				["selector" => $selector_clear, "property" => 'margin-top'],
			]);
		}

		public function render($options, $defaults, $content)
		{
			$rep_id = isset($options['repeater_id']) ? $options['repeater_id'] : '';
			$show = isset($options['show_labels']) ? $options['show_labels'] : 'yes';

			if (empty($rep_id)) {
				echo '<div style="padding:10px; background:#eee;">Active Filters: Please enter Repeater ID.</div>';
				return;
			}

			if (class_exists('SSDF_Filters_Frontend')) {
				echo '<div class="s-ssdf-active-filters-wrap">';

				// Capture output in a variable
				$html = SSDF_Filters_Frontend::get_instance()->render_active_filters([
					'repeater_id' => $rep_id,
					'show_labels' => $show
				]);

				// Output safely with suppressor
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				// Define allowed tags for active filters
				$allowed_html = [
					'div' => ['class' => [], 'data-repeater-id' => [], 'data-show-labels' => [], 'style' => []],
					'button' => ['class' => [], 'data-slug' => [], 'data-label' => [], 'title' => []],
					'span' => ['class' => [], 'style' => []],
				];
				echo wp_kses($html, $allowed_html);

				echo '</div>';
			}
		}
	}
	new SSDF_Active_Filters_El();
endif;