<?php
if (!defined('ABSPATH')) {
	exit;
}

class SSDF_Filters_Term_Meta
{

	public function __construct()
	{
		add_action('admin_init', [$this, 'register_meta']);
	}

	public function register_meta()
	{
		$taxonomies = get_taxonomies(['public' => true]);
		foreach ($taxonomies as $tax) {
			add_action("{$tax}_add_form_fields", [$this, 'add_color_field']);
			add_action("{$tax}_edit_form_fields", [$this, 'edit_color_field']);
			add_action("created_{$tax}", [$this, 'save_term_color']);
			add_action("edited_{$tax}", [$this, 'save_term_color']);
		}
	}

	public function add_color_field($taxonomy)
	{
		?>
		<div class="form-field term-color-wrap">
			<label>Filter Color</label>
			<input type="color" name="ssdf_term_color" value="#ffffff" style="width: 100px;">
			<p>Select color for Swatch Filter.</p>
			<?php wp_nonce_field('ssdf_term_meta_nonce', 'ssdf_term_meta_nonce'); ?>
		</div>
		<?php
	}

	public function edit_color_field($term)
	{
		$color = get_term_meta($term->term_id, '_ssdf_filter_color', true) ?: '#ffffff';
		?>
		<tr class="form-field term-color-wrap">
			<th scope="row"><label>Filter Color</label></th>
			<td>
				<input type="color" name="ssdf_term_color" value="<?php echo esc_attr($color); ?>">
				<?php wp_nonce_field('ssdf_term_meta_nonce', 'ssdf_term_meta_nonce'); ?>
			</td>
		</tr>
		<?php
	}

	public function save_term_color($term_id)
	{
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		if (!isset($_POST['ssdf_term_meta_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['ssdf_term_meta_nonce'])), 'ssdf_term_meta_nonce')) {
			return;
		}

		if (isset($_POST['ssdf_term_color'])) {
			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
			update_term_meta($term_id, '_ssdf_filter_color', sanitize_hex_color(wp_unslash($_POST['ssdf_term_color'])));
		}
	}
}