(function ($) {
    $(document).ready(function () {
        const $ptSelect = $('#ssdf_filter_post_type');
        const $sourceSelect = $('#ssdf_filter_source');

        function loadSources(pt, selected) {
            if (!pt) return;
            $sourceSelect.html('<option>Loading...</option>');
            $.post(SsdfAdmin.ajax_url, {
                action: 'ssdf_get_datasources',
                security: SsdfAdmin.nonce,
                post_type: pt
            }, function (res) {
                if (res.success) {
                    let opts = '<option value="">-- Select Filter By --</option>';
                    res.data.forEach(d => {
                        opts += `<option value="${d.value}" ${selected === d.value ? 'selected' : ''}>${d.label}</option>`;
                    });
                    $sourceSelect.html(opts);
                    if (selected) loadTerms(selected);
                }
            });
        }

        function loadTerms(source) {
            if (source === '_price' || source === '_rating' || source === '_search') return;
            $('.s-ssdf-term-select').html('<option>Loading...</option>');
            $.post(SsdfAdmin.ajax_url, {
                action: 'ssdf_get_terms',
                security: SsdfAdmin.nonce,
                taxonomy: source
            }, function (res) {
                if (res.success) {
                    let opts = '';
                    res.data.forEach(t => opts += `<option value="${t.value}">${t.label}</option>`);
                    $('#ssdf_filter_include, #ssdf_filter_exclude').html(opts);
                    $('#ssdf_filter_parent').html('<option value="">None</option>' + opts);
                    restoreSelections($('#ssdf_filter_include'));
                    restoreSelections($('#ssdf_filter_exclude'));
                    const savedPar = $('#ssdf_filter_parent').data('selected');
                    if (savedPar) $('#ssdf_filter_parent').val(savedPar);
                }
            });
        }

        function restoreSelections($el) {
            const saved = $el.data('selected');
            if (saved && saved.length > 0) $el.val(saved);
        }

        $('.s-ssdf-term-select').on('change', function () {
            const val = $(this).val();
            if (val && val.includes('-1')) $(this).val([]);
        });

        $ptSelect.change(function () { loadSources($(this).val()); });
        $sourceSelect.change(function () { loadTerms($(this).val()); });
        $('.s-ssdf-advanced-toggle').click(function () { $('.s-ssdf-advanced-panel').slideToggle(); });

        if ($ptSelect.val()) loadSources($ptSelect.val(), $sourceSelect.data('selected'));


        // INDEXER LOGIC
        $('#ssdf-run-indexer').click(function (e) {
            e.preventDefault();
            var $btn = $(this);
            var $status = $('#ssdf-index-status');

            $btn.prop('disabled', true);
            $status.text('Starting indexing process...');

            function runBatch(offset) {
                $.post(SsdfAdmin.ajax_url, {
                    action: 'ssdf_batch_index',
                    security: SsdfAdmin.nonce,
                    offset: offset
                }, function (res) {
                    if (res.success) {
                        if (res.data.complete) {
                            $status.text('Success! All products indexed.');
                            $btn.prop('disabled', false);
                        } else {
                            $status.text('Indexed ' + res.data.next_offset + ' products so far...');
                            runBatch(res.data.next_offset); // Recursive call
                        }
                    } else {
                        $status.text('Error occurred. Please refresh.');
                        $btn.prop('disabled', false);
                    }
                }).fail(function () {
                    $status.text('Server Error.');
                    $btn.prop('disabled', false);
                });
            }

            // Start from 0
            runBatch(0);
        });
    });
})(jQuery);