<?php
/**
 * The core plugin class.
 *
 * @package Srizon_AI_Image
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Srizon_AI_Image {

    /**
     * The loader that's responsible for maintaining and registering all hooks.
     *
     * @var Srizon_AI_Image_Loader
     */
    protected $loader;

    /**
     * The unique identifier of this plugin.
     *
     * @var string
     */
    protected $plugin_name;

    /**
     * The current version of the plugin.
     *
     * @var string
     */
    protected $version;

    /**
     * Define the core functionality of the plugin.
     */
    public function __construct() {
        $this->version     = SRIZON_AI_IMAGE_VERSION;
        $this->plugin_name = 'srizon-ai-image';

        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        $this->define_api_hooks();
    }

    /**
     * Load the required dependencies for this plugin.
     */
    private function load_dependencies() {
        require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-loader.php';
        require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-api.php';
        require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-bg-removal.php';
        require_once SRIZON_AI_IMAGE_PATH . 'admin/class-srizon-ai-image-admin.php';
        require_once SRIZON_AI_IMAGE_PATH . 'public/class-srizon-ai-image-public.php';

        $this->loader = new Srizon_AI_Image_Loader();
    }

    /**
     * Register all of the hooks related to the admin area functionality.
     */
    private function define_admin_hooks() {
        $plugin_admin = new Srizon_AI_Image_Admin( $this->get_plugin_name(), $this->get_version() );

        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_settings_page' );
        $this->loader->add_action( 'admin_init', $plugin_admin, 'register_settings' );
        $this->loader->add_action( 'admin_notices', $plugin_admin, 'display_api_key_notice' );
        $this->loader->add_action( 'enqueue_block_editor_assets', $plugin_admin, 'enqueue_block_editor_assets' );
        $this->loader->add_action( 'wp_enqueue_media', $plugin_admin, 'enqueue_media_script' );
        $this->loader->add_action( 'wp_enqueue_media', $plugin_admin, 'enqueue_bg_removal_script' );

        // Initialize background removal media integration.
        Srizon_AI_Image_BG_Removal::get_instance();
    }

    /**
     * Register all of the hooks related to the public-facing functionality.
     */
    private function define_public_hooks() {
        $plugin_public = new Srizon_AI_Image_Public( $this->get_plugin_name(), $this->get_version() );

        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
    }

    /**
     * Register REST API routes.
     */
    private function define_api_hooks() {
        $plugin_api = new Srizon_AI_Image_API();
        $this->loader->add_action( 'rest_api_init', $plugin_api, 'register_routes' );
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     */
    public function run() {
        $this->loader->run();
    }

    /**
     * The name of the plugin used to uniquely identify it.
     *
     * @return string
     */
    public function get_plugin_name() {
        return $this->plugin_name;
    }

    /**
     * The reference to the class that orchestrates the hooks.
     *
     * @return Srizon_AI_Image_Loader
     */
    public function get_loader() {
        return $this->loader;
    }

    /**
     * Retrieve the version number of the plugin.
     *
     * @return string
     */
    public function get_version() {
        return $this->version;
    }
}
