<?php
/**
 * WP-CLI commands for sqm-views plugin.
 *
 * @package SQMViews
 */

namespace SQMViews;

if ( defined( 'WP_CLI' ) && WP_CLI ) {

	/**
	 * WP-CLI command class for SQMViews plugin.
	 */
	class SQMViewsCLI extends \WP_CLI_Command {

		/**
		 * Process sqm-views statistics
		 *
		 * ## OPTIONS
		 *
		 * [--verbose]
		 * : Show detailed output
		 *
		 * ## EXAMPLES
		 *
		 *     wp sqm-views process
		 *     wp sqm-views process --verbose
		 *
		 * @param array<string>        $args       Positional arguments.
		 * @param array<string, mixed> $assoc_args Associative arguments.
		 * @return void
		 */
		public function process( array $args, array $assoc_args ): void {
			$verbose = isset( $assoc_args['verbose'] );

			if ( $verbose ) {
				\WP_CLI::line( __( 'Starting sqm-views statistics processing...', 'sqm-views' ) );
			}

			// Call the main function.
			$result = sqm_views_process_statistics( $verbose );

			if ( $result['success'] ) {
				\WP_CLI::success( $result['message'] );
			} else {
				\WP_CLI::error( $result['error'] );
			}
		}

		/**
		 * Show sqm-views statistics
		 *
		 * ## EXAMPLES
		 *
		 *     wp sqm-views stats
		 *
		 * @param array<string>        $args       Positional arguments.
		 * @param array<string, mixed> $assoc_args Associative arguments.
		 * @return void
		 */
		public function stats( array $args, array $assoc_args ): void {
			global $wpdb;

			// phpcs:disable Squiz.PHP.CommentedOutCode.Found, Squiz.Commenting.InlineComment.InvalidEndChar -- Example code for reference.
			// Example: Show some statistics.
			// $table_name = $wpdb->prefix . 'sqm_views_stats';
			//
			// $total_records = $wpdb->get_var("SELECT COUNT(*) FROM {$table_name}");
			// $today_records = $wpdb->get_var($wpdb->prepare(
			// "SELECT COUNT(*) FROM {$table_name} WHERE DATE(created_at) = %s",
			// current_time('Y-m-d')
			// ));
			// phpcs:enable Squiz.PHP.CommentedOutCode.Found, Squiz.Commenting.InlineComment.InvalidEndChar

			\WP_CLI::line( __( 'SQMViews Statistics:', 'sqm-views' ) );
			/* translators: %s: number of total records */
			\WP_CLI::line( sprintf( __( 'Total records: %s', 'sqm-views' ), number_format( 100 ) ) );
			/* translators: %s: number of today's records */
			\WP_CLI::line( sprintf( __( "Today's records: %s", 'sqm-views' ), number_format( 100 ) ) );
		}
	}
}
