<?php
/**
 * SQMViews
 *
 * @package     SQMViews
 * @author      Pavel Khloponin
 * @copyright   2024-2025 Pavel Khloponin
 * @license     GPLv3 or later
 *
 * @wordpress-plugin
 * Plugin Name: SQMViews
 * Plugin URI:  https://searchquerymaster.com/sqm-views
 * Description: Lightweight page view tracking and engagement analytics with interactive dashboards. No external services, privacy-focused.
 * Version:     1.1.9
 * Author:      Pavel Khloponin
 * Author URI:  https://github.com/pkhlop
 * Text Domain: sqm-views
 * Domain Path: /languages
 * Requires at least: 6.2
 * Requires PHP: 8.1
 * License:     GPLv3 or later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * WARNING: Do NOT edit the Version field manually!
 * Use the bump-version.sh script to update versions across all files:
 *   ./bump-version.sh patch|minor|major
 */

namespace SQMViews;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin file constant for path/URL resolution.
if ( ! defined( 'SQMVIEWS_PLUGIN_FILE' ) ) {
	define( 'SQMVIEWS_PLUGIN_FILE', __FILE__ );
}

// Require dependencies.
require_once __DIR__ . '/vendor/autoload.php';
if ( ! defined( 'SQMVIEWS' ) ) {
	throw new \Exception( 'SQMViews autoloader not found.' );
}

require_once __DIR__ . '/src/includes/rest-api.php';
require_once __DIR__ . '/src/includes/activation.php';
require_once __DIR__ . '/sqm-views-process-statistics.php';
require_once __DIR__ . '/src/includes/tracker.php';


// Check for version upgrades on admin pages.
add_action( 'admin_init', '\SQMViews\sqm_views_check_version' );

if ( is_admin() ) {
	new SQMViewsSettings();
}

if ( defined( 'WP_CLI' ) && WP_CLI ) {
	// Register the commands.
	\WP_CLI::add_command( 'sqm-views', '\SQMViews\SQMViewsCLI' );
}

// Hook into WordPress.
add_action( 'wp_head', '\SQMViews\sqm_views_tracker' );

// Register activation/deactivation hooks.
register_activation_hook( __FILE__, '\SQMViews\activate' );
register_deactivation_hook( __FILE__, '\SQMViews\deactivate' );
register_uninstall_hook( __FILE__, '\SQMViews\uninstall' );

$sqm_views_cron = SQMViewsCron::get_instance();
register_activation_hook( __FILE__, array( $sqm_views_cron, 'schedule_cron' ) );
register_deactivation_hook( __FILE__, array( $sqm_views_cron, 'unschedule_cron' ) );
