(()=>{"use strict";const t={DEFAULT_CHART_ENDPOINT:"/wp-json/sqm-views/v1/charts",REQUEST_TIMEOUT:3e4,REQUEST_HEADERS:{"Content-Type":"application/json"},MAX_RETRIES:3,RETRY_DELAY:1e3};class n{constructor(){this.endpoints={},this.baseUrl=""}static getInstance(){return n.instance||(n.instance=new n),n.instance}setBaseUrl(t){this.baseUrl=t}getBaseUrl(){return this.baseUrl}setEndpoints(t){this.endpoints={...this.endpoints,...t}}getChartEndpoint(){return this.endpoints.charts?this.endpoints.charts:this.baseUrl?this.baseUrl.replace(/\/$/,"")+"/charts":t.DEFAULT_CHART_ENDPOINT}getRequestConfig(){return{timeout:t.REQUEST_TIMEOUT,headers:{...t.REQUEST_HEADERS},maxRetries:t.MAX_RETRIES,retryDelay:t.RETRY_DELAY}}reset(){this.endpoints={},this.baseUrl=""}}const e=n.getInstance();class r{constructor(t){this.customEndpoint=t}async fetchChartData(t){const n=this.buildParams(t),r=this.getEndpoint(),i=e.getRequestConfig(),o=new AbortController,a=setTimeout(()=>o.abort(),i.timeout);try{const t=await this.fetchWithRetry(`${r}?${n.toString()}`,{method:"GET",headers:i.headers,signal:o.signal},i.maxRetries,i.retryDelay);if(clearTimeout(a),!t.ok)throw Error("Failed to fetch chart data: "+t.statusText);return t.json()}catch(s){if(clearTimeout(a),s instanceof Error&&"AbortError"===s.name)throw Error(`Request timeout after ${i.timeout}ms`);throw s}}getEndpoint(){return this.customEndpoint||e.getChartEndpoint()}async fetchWithRetry(t,n,e,r){let i;for(let a=0;e>=a;a++)try{const e=await fetch(t,n);if(e.ok||e.status>=400&&500>e.status)return e;throw Error(`HTTP ${e.status}: ${e.statusText}`)}catch(o){i=o instanceof Error?o:Error(o+""),e>a&&await new Promise(t=>setTimeout(t,r))}throw i}buildParams(t){const n=new URLSearchParams;return t.startDate&&n.append("startDate",t.startDate),t.endDate&&n.append("endDate",t.endDate),t.eid&&n.append("eid",t.eid),t.tid&&n.append("tid",t.tid),t.granularity&&n.append("granularity",t.granularity),t.metric&&n.append("metric",t.metric),t.limit&&n.append("limit",t.limit.toString()),n}}class i{static readFiltersFromDOM(){const t=i.findElement("sv-start","input[type='date']"),n=i.findElement("sv-end","input[type='date']"),e=i.findElement("sv-granularity","select"),r=i.findElement("sv-metric","select"),o=i.findElement("sv-limit","input[type='number']"),a=i.findElement("sv-log-scale","input[type='checkbox']"),s=null==e?void 0:e.value,u="by_content"===s;return{startDate:(null==t?void 0:t.value)||i.getDefaultStartDate(),endDate:(null==n?void 0:n.value)||i.getDefaultEndDate(),granularity:"by_content"===s?"by_content":"daily",metric:(null==r?void 0:r.value)||"count",limit:u?+(null==o?void 0:o.value)||10:void 0,useLogScale:(null==a?void 0:a.checked)||!1}}static findElement(t,n){let e=document.getElementById(t);return!e&&n&&(e=document.querySelector(n)),e}static hasFormElements(){return!!(i.findElement("sv-start","input[type='date']")||i.findElement("sv-end","input[type='date']")||i.findElement("sv-granularity","select")||i.findElement("sv-metric","select")||i.findElement("sv-log-scale","input[type='checkbox']"))}static setDefaultValues(t){if(t.startDate){const n=i.findElement("sv-start","input[type='date']");n&&(n.value=t.startDate)}if(t.endDate){const n=i.findElement("sv-end","input[type='date']");n&&(n.value=t.endDate)}if(t.granularity){const n=i.findElement("sv-granularity","select");n&&(n.value=t.granularity)}if(t.metric){const n=i.findElement("sv-metric","select");n&&(n.value=t.metric)}if(t.limit){const n=i.findElement("sv-limit","input[type='number']");n&&(n.value=t.limit+"")}if(void 0!==t.useLogScale){const n=i.findElement("sv-log-scale","input[type='checkbox']");n&&(n.checked=t.useLogScale)}}static getDefaultStartDate(){return new Date(Date.now()-2592e6).toISOString().slice(0,10)}static getDefaultEndDate(){return(new Date).toISOString().slice(0,10)}}class o{constructor(t,n={}){this.controls=new Map;const e=document.getElementById(t);if(!e)throw Error(`Container with id "${t}" not found`);this.container=e,this.config={showStartDate:!0,showEndDate:!0,showGranularity:!0,showMetric:!0,showLimit:!0,showLogScale:!0,showRefreshButton:!0,...n},this.render(),this.setupEventListeners()}render(){this.container.innerHTML="",this.container.className="dashboard-controls",this.addStyles();const t=document.createElement("div");t.className="controls-form",this.config.showStartDate&&t.appendChild(this.createDateControl("start","Start Date",this.getDefaultStartDate())),this.config.showEndDate&&t.appendChild(this.createDateControl("end","End Date",this.getDefaultEndDate())),this.config.showGranularity&&t.appendChild(this.createGranularityControl()),this.config.showLimit&&t.appendChild(this.createLimitControl()),this.config.showMetric&&t.appendChild(this.createMetricControl()),this.config.showLogScale&&t.appendChild(this.createLogScaleControl()),this.config.showRefreshButton&&t.appendChild(this.createRefreshButton()),this.container.appendChild(t)}createDateControl(t,n,e){var r;const i=document.createElement("div");i.className="control-group";const o=document.createElement("label");o.textContent=n+":";const a=document.createElement("input");return a.type="date",a.id="sv-"+t,a.value=(null===(r=this.config.defaultValues)||void 0===r?void 0:r["start"===t?"startDate":"endDate"])||e,this.controls.set(t+"Date",a),o.appendChild(a),i.appendChild(o),i}createGranularityControl(){var t,n;const e=document.createElement("div");e.className="control-group";const r=document.createElement("label");r.textContent="Granularity:";const i=document.createElement("select");i.id="sv-granularity";const o=document.createElement("option");o.value="daily",o.textContent="Daily",o.selected="by_content"!==(null===(t=this.config.defaultValues)||void 0===t?void 0:t.granularity);const a=document.createElement("option");return a.value="by_content",a.textContent="By Content",a.selected="by_content"===(null===(n=this.config.defaultValues)||void 0===n?void 0:n.granularity),i.appendChild(o),i.appendChild(a),this.controls.set("granularity",i),r.appendChild(i),e.appendChild(r),e}createLimitControl(){var t,n;const e=document.createElement("div");e.className="control-group limit-control",e.id="limit-wrapper";const r=document.createElement("label");r.textContent="Limit:";const i=document.createElement("input");return i.type="number",i.id="sv-limit",i.value=((null===(t=this.config.defaultValues)||void 0===t?void 0:t.limit)||10)+"",i.min="1",this.controls.set("limit",i),r.appendChild(i),e.appendChild(r),"by_content"!==(null===(n=this.config.defaultValues)||void 0===n?void 0:n.granularity)&&(e.style.display="none"),e}createMetricControl(){const t=document.createElement("div");t.className="control-group";const n=document.createElement("label");n.textContent="Metric:";const e=document.createElement("select");return e.id="sv-metric",[{value:"count",label:"Page Views"},{value:"on_page",label:"Time on Page"},{value:"active",label:"Active Views"},{value:"high_freq",label:"High Frequency"},{value:"low_freq",label:"Low Frequency"}].forEach(t=>{var n,r;const i=document.createElement("option");i.value=t.value,i.textContent=t.label,i.selected=(null===(n=this.config.defaultValues)||void 0===n?void 0:n.metric)===t.value||!(null===(r=this.config.defaultValues)||void 0===r?void 0:r.metric)&&"count"===t.value,e.appendChild(i)}),this.controls.set("metric",e),n.appendChild(e),t.appendChild(n),t}createLogScaleControl(){var t;const n=document.createElement("div");n.className="control-group";const e=document.createElement("label"),r=document.createElement("input");r.type="checkbox",r.id="sv-log-scale",r.checked=(null===(t=this.config.defaultValues)||void 0===t?void 0:t.useLogScale)||!1;const i=document.createElement("span");return i.textContent="Use Log Scale",i.style.marginLeft="5px",this.controls.set("logScale",r),e.appendChild(r),e.appendChild(i),n.appendChild(e),n}createRefreshButton(){const t=document.createElement("div");t.className="control-group";const n=document.createElement("button");return n.type="button",n.textContent="Refresh",n.className="button button-primary",n.id="sv-refresh",this.controls.set("refresh",n),t.appendChild(n),t}setupEventListeners(){const t=this.controls.get("granularity");t&&t.addEventListener("change",()=>{this.toggleLimitVisibility(),this.config.onFilterChange&&this.config.onFilterChange(this.getCurrentFilters())});const n=this.controls.get("logScale");n&&n.addEventListener("change",()=>{this.config.onFilterChange&&this.config.onFilterChange(this.getCurrentFilters()),this.config.onRefresh&&this.config.onRefresh()}),this.controls.forEach((t,n)=>{"refresh"!==n&&"logScale"!==n&&this.config.onFilterChange&&t.addEventListener("change",()=>{this.config.onFilterChange(this.getCurrentFilters())})});const e=this.controls.get("refresh");e&&e.addEventListener("click",()=>{this.config.onRefresh&&this.config.onRefresh()})}toggleLimitVisibility(){const t=this.controls.get("granularity"),n=document.getElementById("limit-wrapper");if(t&&n){const e="by_content"===t.value;n.style.display=e?"block":"none"}}addStyles(){const t="dashboard-controls-styles";if(document.getElementById(t))return;const n=document.createElement("style");n.id=t,n.textContent="\n      .dashboard-controls {\n        background: #fff;\n        border: 1px solid #ccd0d4;\n        border-radius: 4px;\n        padding: 20px;\n        margin-bottom: 20px;\n        box-shadow: 0 1px 1px rgba(0,0,0,.04);\n      }\n\n      .controls-form {\n        display: flex;\n        flex-wrap: wrap;\n        gap: 15px;\n        align-items: end;\n      }\n\n      .control-group {\n        display: flex;\n        flex-direction: column;\n        min-width: 120px;\n      }\n\n      .control-group label {\n        font-weight: 600;\n        margin-bottom: 5px;\n        font-size: 13px;\n        color: #23282d;\n      }\n\n      .control-group input,\n      .control-group select {\n        padding: 6px 8px;\n        border: 1px solid #ddd;\n        border-radius: 4px;\n        font-size: 14px;\n        background: #fff;\n      }\n\n      .control-group input:focus,\n      .control-group select:focus {\n        border-color: #007cba;\n        outline: none;\n        box-shadow: 0 0 0 1px #007cba;\n      }\n\n      .button {\n        display: inline-block;\n        text-decoration: none;\n        font-size: 13px;\n        line-height: 2.15384615;\n        min-height: 30px;\n        margin: 0;\n        padding: 0 10px;\n        cursor: pointer;\n        border-width: 1px;\n        border-style: solid;\n        border-radius: 3px;\n        white-space: nowrap;\n        box-sizing: border-box;\n      }\n\n      .button-primary {\n        background: #007cba;\n        border-color: #007cba;\n        color: #fff;\n      }\n\n      .button-primary:hover {\n        background: #005a87;\n        border-color: #005a87;\n      }\n\n      @media (max-width: 768px) {\n        .controls-form {\n          flex-direction: column;\n          align-items: stretch;\n        }\n\n        .control-group {\n          min-width: auto;\n        }\n      }\n    ",document.head.appendChild(n)}getDefaultStartDate(){return new Date(Date.now()-2592e6).toISOString().slice(0,10)}getDefaultEndDate(){return(new Date).toISOString().slice(0,10)}getCurrentFilters(){const t=this.controls.get("startDate"),n=this.controls.get("endDate"),e=this.controls.get("granularity"),r=this.controls.get("metric"),i=this.controls.get("limit"),o=this.controls.get("logScale");return{startDate:(null==t?void 0:t.value)||this.getDefaultStartDate(),endDate:(null==n?void 0:n.value)||this.getDefaultEndDate(),granularity:"by_content"===(null==e?void 0:e.value)?"by_content":"daily",metric:(null==r?void 0:r.value)||"count",limit:"by_content"===(null==e?void 0:e.value)?+(null==i?void 0:i.value)||10:void 0,useLogScale:(null==o?void 0:o.checked)||!1}}setFilters(t){if(t.startDate){const n=this.controls.get("startDate");n&&(n.value=t.startDate)}if(t.endDate){const n=this.controls.get("endDate");n&&(n.value=t.endDate)}if(t.granularity){const n=this.controls.get("granularity");n&&(n.value=t.granularity,this.toggleLimitVisibility())}if(t.metric){const n=this.controls.get("metric");n&&(n.value=t.metric)}if(t.limit){const n=this.controls.get("limit");n&&(n.value=t.limit+"")}if(void 0!==t.useLogScale){const n=this.controls.get("logScale");n&&(n.checked=t.useLogScale)}}destroy(){this.container.innerHTML="",this.controls.clear()}}function a(t,n){let e;if(void 0===n)for(const r of t)null!=r&&(r>e||void 0===e&&r>=r)&&(e=r);else{let r=-1;for(let i of t)null!=(i=n(i,++r,t))&&(i>e||void 0===e&&i>=i)&&(e=i)}return e}function s(t){return t}var u=1e-6;function l(t){return"translate("+t+",0)"}function c(t){return"translate(0,"+t+")"}function h(t){return n=>+t(n)}function f(t,n){return n=Math.max(0,t.bandwidth()-2*n)/2,t.round()&&(n=Math.round(n)),e=>+t(e)+n}function d(){return!this.__axis}function p(t,n){var e=[],r=null,i=null,o=6,a=6,p=3,g="undefined"!=typeof window&&window.devicePixelRatio>1?0:.5,m=1===t||4===t?-1:1,y=4===t||2===t?"x":"y",v=1===t||3===t?l:c;function _(l){var c=null==r?n.ticks?n.ticks.apply(n,e):n.domain():r,_=null==i?n.tickFormat?n.tickFormat.apply(n,e):s:i,w=Math.max(o,0)+p,x=n.range(),b=+x[0]+g,M=+x[x.length-1]+g,E=(n.bandwidth?f:h)(n.copy(),g),C=l.selection?l.selection():l,k=C.selectAll(".domain").data([null]),S=C.selectAll(".tick").data(c,n).order(),$=S.exit(),A=S.enter().append("g").attr("class","tick"),N=S.select("line"),D=S.select("text");k=k.merge(k.enter().insert("path",".tick").attr("class","domain").attr("stroke","currentColor")),S=S.merge(A),N=N.merge(A.append("line").attr("stroke","currentColor").attr(y+"2",m*o)),D=D.merge(A.append("text").attr("fill","currentColor").attr(y,m*w).attr("dy",1===t?"0em":3===t?"0.71em":"0.32em")),l!==C&&(k=k.transition(l),S=S.transition(l),N=N.transition(l),D=D.transition(l),$=$.transition(l).attr("opacity",u).attr("transform",function(t){return isFinite(t=E(t))?v(t+g):this.getAttribute("transform")}),A.attr("opacity",u).attr("transform",function(t){var n=this.parentNode.__axis;return v((n&&isFinite(n=n(t))?n:E(t))+g)})),$.remove(),k.attr("d",4===t||2===t?a?"M"+m*a+","+b+"H"+g+"V"+M+"H"+m*a:"M"+g+","+b+"V"+M:a?"M"+b+","+m*a+"V"+g+"H"+M+"V"+m*a:"M"+b+","+g+"H"+M),S.attr("opacity",1).attr("transform",function(t){return v(E(t)+g)}),N.attr(y+"2",m*o),D.attr(y,m*w).text(_),C.filter(d).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===t?"start":4===t?"end":"middle"),C.each(function(){this.__axis=E})}return _.scale=function(t){return arguments.length?(n=t,_):n},_.ticks=function(){return e=Array.from(arguments),_},_.tickArguments=function(t){return arguments.length?(e=null==t?[]:Array.from(t),_):e.slice()},_.tickValues=function(t){return arguments.length?(r=null==t?null:Array.from(t),_):r&&r.slice()},_.tickFormat=function(t){return arguments.length?(i=t,_):i},_.tickSize=function(t){return arguments.length?(o=a=+t,_):o},_.tickSizeInner=function(t){return arguments.length?(o=+t,_):o},_.tickSizeOuter=function(t){return arguments.length?(a=+t,_):a},_.tickPadding=function(t){return arguments.length?(p=+t,_):p},_.offset=function(t){return arguments.length?(g=+t,_):g},_}function g(t){return p(3,t)}function m(t){return p(4,t)}function y(){}function v(t){return null==t?y:function(){return this.querySelector(t)}}function _(){return[]}function w(t){return null==t?_:function(){return this.querySelectorAll(t)}}function x(t){return function(){return this.matches(t)}}function b(t){return function(n){return n.matches(t)}}var M=[].find;function E(){return this.firstElementChild}var C=[].filter;function k(){return Array.from(this.children)}function S(t){return Array(t.length)}function $(t,n){this.ownerDocument=t.ownerDocument,this.namespaceURI=t.namespaceURI,this._next=null,this._parent=t,this.__data__=n}function A(t,n,e,r,i,o){for(var a,s=0,u=n.length,l=o.length;l>s;++s)(a=n[s])?(a.__data__=o[s],r[s]=a):e[s]=new $(t,o[s]);for(;u>s;++s)(a=n[s])&&(i[s]=a)}function N(t,n,e,r,i,o,a){var s,u,l,c=new Map,h=n.length,f=o.length,d=Array(h);for(s=0;h>s;++s)(u=n[s])&&(d[s]=l=a.call(u,u.__data__,s,n)+"",c.has(l)?i[s]=u:c.set(l,u));for(s=0;f>s;++s)l=a.call(t,o[s],s,o)+"",(u=c.get(l))?(r[s]=u,u.__data__=o[s],c.delete(l)):e[s]=new $(t,o[s]);for(s=0;h>s;++s)(u=n[s])&&c.get(d[s])===u&&(i[s]=u)}function D(t){return t.__data__}function T(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function L(t,n){return n>t?-1:t>n?1:n>t?NaN:0}$.prototype={constructor:$,appendChild:function(t){return this._parent.insertBefore(t,this._next)},insertBefore:function(t,n){return this._parent.insertBefore(t,n)},querySelector:function(t){return this._parent.querySelector(t)},querySelectorAll:function(t){return this._parent.querySelectorAll(t)}};var R="http://www.w3.org/1999/xhtml";const F={svg:"http://www.w3.org/2000/svg",xhtml:R,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function P(t){var n=t+="",e=n.indexOf(":");return 0>e||"xmlns"===(n=t.slice(0,e))||(t=t.slice(e+1)),F.hasOwnProperty(n)?{space:F[n],local:t}:t}function I(t){return function(){this.removeAttribute(t)}}function O(t){return function(){this.removeAttributeNS(t.space,t.local)}}function q(t,n){return function(){this.setAttribute(t,n)}}function V(t,n){return function(){this.setAttributeNS(t.space,t.local,n)}}function X(t,n){return function(){var e=n.apply(this,arguments);null==e?this.removeAttribute(t):this.setAttribute(t,e)}}function U(t,n){return function(){var e=n.apply(this,arguments);null==e?this.removeAttributeNS(t.space,t.local):this.setAttributeNS(t.space,t.local,e)}}function j(t){return t.ownerDocument&&t.ownerDocument.defaultView||t.document&&t||t.defaultView}function B(t){return function(){this.style.removeProperty(t)}}function H(t,n,e){return function(){this.style.setProperty(t,n,e)}}function z(t,n,e){return function(){var r=n.apply(this,arguments);null==r?this.style.removeProperty(t):this.style.setProperty(t,r,e)}}function Y(t,n){return t.style.getPropertyValue(n)||j(t).getComputedStyle(t,null).getPropertyValue(n)}function G(t){return function(){delete this[t]}}function Q(t,n){return function(){this[t]=n}}function W(t,n){return function(){var e=n.apply(this,arguments);null==e?delete this[t]:this[t]=e}}function Z(t){return t.trim().split(/^|\s+/)}function K(t){return t.classList||new J(t)}function J(t){this._node=t,this._names=Z(t.getAttribute("class")||"")}function tt(t,n){for(var e=K(t),r=-1,i=n.length;++r<i;)e.add(n[r])}function nt(t,n){for(var e=K(t),r=-1,i=n.length;++r<i;)e.remove(n[r])}function et(t){return function(){tt(this,t)}}function rt(t){return function(){nt(this,t)}}function it(t,n){return function(){(n.apply(this,arguments)?tt:nt)(this,t)}}function ot(){this.textContent=""}function at(t){return function(){this.textContent=t}}function st(t){return function(){var n=t.apply(this,arguments);this.textContent=null==n?"":n}}function ut(){this.innerHTML=""}function lt(t){return function(){this.innerHTML=t}}function ct(t){return function(){var n=t.apply(this,arguments);this.innerHTML=null==n?"":n}}function ht(){this.nextSibling&&this.parentNode.appendChild(this)}function ft(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function dt(t){return function(){var n=this.ownerDocument,e=this.namespaceURI;return e===R&&n.documentElement.namespaceURI===R?n.createElement(t):n.createElementNS(e,t)}}function pt(t){return function(){return this.ownerDocument.createElementNS(t.space,t.local)}}function gt(t){var n=P(t);return(n.local?pt:dt)(n)}function mt(){return null}function yt(){var t=this.parentNode;t&&t.removeChild(this)}function vt(){var t=this.cloneNode(!1),n=this.parentNode;return n?n.insertBefore(t,this.nextSibling):t}function _t(){var t=this.cloneNode(!0),n=this.parentNode;return n?n.insertBefore(t,this.nextSibling):t}function wt(t){return function(){var n=this.__on;if(n){for(var e,r=0,i=-1,o=n.length;o>r;++r)e=n[r],t.type&&e.type!==t.type||e.name!==t.name?n[++i]=e:this.removeEventListener(e.type,e.listener,e.options);++i?n.length=i:delete this.__on}}}function xt(t,n,e){return function(){var r,i=this.__on,o=function(t){return function(n){t.call(this,n,this.__data__)}}(n);if(i)for(var a=0,s=i.length;s>a;++a)if((r=i[a]).type===t.type&&r.name===t.name)return this.removeEventListener(r.type,r.listener,r.options),this.addEventListener(r.type,r.listener=o,r.options=e),void(r.value=n);this.addEventListener(t.type,o,e),r={type:t.type,name:t.name,value:n,listener:o,options:e},i?i.push(r):this.__on=[r]}}function bt(t,n,e){var r=j(t),i=r.CustomEvent;"function"==typeof i?i=new i(n,e):(i=r.document.createEvent("Event"),e?(i.initEvent(n,e.bubbles,e.cancelable),i.detail=e.detail):i.initEvent(n,!1,!1)),t.dispatchEvent(i)}function Mt(t,n){return function(){return bt(this,t,n)}}function Et(t,n){return function(){return bt(this,t,n.apply(this,arguments))}}J.prototype={add:function(t){0>this._names.indexOf(t)&&(this._names.push(t),this._node.setAttribute("class",this._names.join(" ")))},remove:function(t){var n=this._names.indexOf(t);0>n||(this._names.splice(n,1),this._node.setAttribute("class",this._names.join(" ")))},contains:function(t){return this._names.indexOf(t)>=0}};var Ct=[null];function kt(t,n){this._groups=t,this._parents=n}function St(){return new kt([[document.documentElement]],Ct)}kt.prototype=St.prototype={constructor:kt,select:function(t){"function"!=typeof t&&(t=v(t));for(var n=this._groups,e=n.length,r=Array(e),i=0;e>i;++i)for(var o,a,s=n[i],u=s.length,l=r[i]=Array(u),c=0;u>c;++c)(o=s[c])&&(a=t.call(o,o.__data__,c,s))&&("__data__"in o&&(a.__data__=o.__data__),l[c]=a);return new kt(r,this._parents)},selectAll:function(t){t="function"==typeof t?function(t){return function(){return null==(n=t.apply(this,arguments))?[]:Array.isArray(n)?n:Array.from(n);var n}}(t):w(t);for(var n=this._groups,e=n.length,r=[],i=[],o=0;e>o;++o)for(var a,s=n[o],u=s.length,l=0;u>l;++l)(a=s[l])&&(r.push(t.call(a,a.__data__,l,s)),i.push(a));return new kt(r,i)},selectChild:function(t){return this.select(null==t?E:function(t){return function(){return M.call(this.children,t)}}("function"==typeof t?t:b(t)))},selectChildren:function(t){return this.selectAll(null==t?k:function(t){return function(){return C.call(this.children,t)}}("function"==typeof t?t:b(t)))},filter:function(t){"function"!=typeof t&&(t=x(t));for(var n=this._groups,e=n.length,r=Array(e),i=0;e>i;++i)for(var o,a=n[i],s=a.length,u=r[i]=[],l=0;s>l;++l)(o=a[l])&&t.call(o,o.__data__,l,a)&&u.push(o);return new kt(r,this._parents)},data:function(t,n){if(!arguments.length)return Array.from(this,D);var e,r=n?N:A,i=this._parents,o=this._groups;"function"!=typeof t&&(e=t,t=function(){return e});for(var a=o.length,s=Array(a),u=Array(a),l=Array(a),c=0;a>c;++c){var h=i[c],f=o[c],d=f.length,p=T(t.call(h,h&&h.__data__,c,i)),g=p.length,m=u[c]=Array(g),y=s[c]=Array(g);r(h,f,m,y,l[c]=Array(d),p,n);for(var v,_,w=0,x=0;g>w;++w)if(v=m[w]){for(x>w||(x=w+1);!(_=y[x])&&++x<g;);v._next=_||null}}return(s=new kt(s,i))._enter=u,s._exit=l,s},enter:function(){return new kt(this._enter||this._groups.map(S),this._parents)},exit:function(){return new kt(this._exit||this._groups.map(S),this._parents)},join:function(t,n,e){var r=this.enter(),i=this,o=this.exit();return"function"==typeof t?(r=t(r))&&(r=r.selection()):r=r.append(t+""),null!=n&&(i=n(i))&&(i=i.selection()),null==e?o.remove():e(o),r&&i?r.merge(i).order():i},merge:function(t){for(var n=t.selection?t.selection():t,e=this._groups,r=n._groups,i=e.length,o=r.length,a=Math.min(i,o),s=Array(i),u=0;a>u;++u)for(var l,c=e[u],h=r[u],f=c.length,d=s[u]=Array(f),p=0;f>p;++p)(l=c[p]||h[p])&&(d[p]=l);for(;i>u;++u)s[u]=e[u];return new kt(s,this._parents)},selection:function(){return this},order:function(){for(var t=this._groups,n=-1,e=t.length;++n<e;)for(var r,i=t[n],o=i.length-1,a=i[o];--o>=0;)(r=i[o])&&(a&&4^r.compareDocumentPosition(a)&&a.parentNode.insertBefore(r,a),a=r);return this},sort:function(t){function n(n,e){return n&&e?t(n.__data__,e.__data__):!n-!e}t||(t=L);for(var e=this._groups,r=e.length,i=Array(r),o=0;r>o;++o){for(var a,s=e[o],u=s.length,l=i[o]=Array(u),c=0;u>c;++c)(a=s[c])&&(l[c]=a);l.sort(n)}return new kt(i,this._parents).order()},call:function(){var t=arguments[0];return arguments[0]=this,t.apply(null,arguments),this},nodes:function(){return Array.from(this)},node:function(){for(var t=this._groups,n=0,e=t.length;e>n;++n)for(var r=t[n],i=0,o=r.length;o>i;++i){var a=r[i];if(a)return a}return null},size:function(){let t=0;for(const n of this)++t;return t},empty:function(){return!this.node()},each:function(t){for(var n=this._groups,e=0,r=n.length;r>e;++e)for(var i,o=n[e],a=0,s=o.length;s>a;++a)(i=o[a])&&t.call(i,i.__data__,a,o);return this},attr:function(t,n){var e=P(t);if(2>arguments.length){var r=this.node();return e.local?r.getAttributeNS(e.space,e.local):r.getAttribute(e)}return this.each((null==n?e.local?O:I:"function"==typeof n?e.local?U:X:e.local?V:q)(e,n))},style:function(t,n,e){return arguments.length>1?this.each((null==n?B:"function"==typeof n?z:H)(t,n,null==e?"":e)):Y(this.node(),t)},property:function(t,n){return arguments.length>1?this.each((null==n?G:"function"==typeof n?W:Q)(t,n)):this.node()[t]},classed:function(t,n){var e=Z(t+"");if(2>arguments.length){for(var r=K(this.node()),i=-1,o=e.length;++i<o;)if(!r.contains(e[i]))return!1;return!0}return this.each(("function"==typeof n?it:n?et:rt)(e,n))},text:function(t){return arguments.length?this.each(null==t?ot:("function"==typeof t?st:at)(t)):this.node().textContent},html:function(t){return arguments.length?this.each(null==t?ut:("function"==typeof t?ct:lt)(t)):this.node().innerHTML},raise:function(){return this.each(ht)},lower:function(){return this.each(ft)},append:function(t){var n="function"==typeof t?t:gt(t);return this.select(function(){return this.appendChild(n.apply(this,arguments))})},insert:function(t,n){var e="function"==typeof t?t:gt(t),r=null==n?mt:"function"==typeof n?n:v(n);return this.select(function(){return this.insertBefore(e.apply(this,arguments),r.apply(this,arguments)||null)})},remove:function(){return this.each(yt)},clone:function(t){return this.select(t?_t:vt)},datum:function(t){return arguments.length?this.property("__data__",t):this.node().__data__},on:function(t,n,e){var r,i,o=function(t){return t.trim().split(/^|\s+/).map(function(t){var n="",e=t.indexOf(".");return 0>e||(n=t.slice(e+1),t=t.slice(0,e)),{type:t,name:n}})}(t+""),a=o.length;if(arguments.length>=2){for(s=n?xt:wt,r=0;a>r;++r)this.each(s(o[r],n,e));return this}var s=this.node().__on;if(s)for(var u,l=0,c=s.length;c>l;++l)for(r=0,u=s[l];a>r;++r)if((i=o[r]).type===u.type&&i.name===u.name)return u.value},dispatch:function(t,n){return this.each(("function"==typeof n?Et:Mt)(t,n))},[Symbol.iterator]:function*(){for(var t=this._groups,n=0,e=t.length;e>n;++n)for(var r,i=t[n],o=0,a=i.length;a>o;++o)(r=i[o])&&(yield r)}};const $t=St;var At={value:()=>{}};function Nt(){for(var t,n=0,e=arguments.length,r={};e>n;++n){if(!(t=arguments[n]+"")||t in r||/[\s.]/.test(t))throw Error("illegal type: "+t);r[t]=[]}return new Dt(r)}function Dt(t){this._=t}function Tt(t,n){for(var e,r=0,i=t.length;i>r;++r)if((e=t[r]).name===n)return e.value}function Lt(t,n,e){for(var r=0,i=t.length;i>r;++r)if(t[r].name===n){t[r]=At,t=t.slice(0,r).concat(t.slice(r+1));break}return null!=e&&t.push({name:n,value:e}),t}Dt.prototype=Nt.prototype={constructor:Dt,on:function(t,n){var e,r,i=this._,o=(r=i,(t+"").trim().split(/^|\s+/).map(function(t){var n="",e=t.indexOf(".");if(0>e||(n=t.slice(e+1),t=t.slice(0,e)),t&&!r.hasOwnProperty(t))throw Error("unknown type: "+t);return{type:t,name:n}})),a=-1,s=o.length;if(arguments.length>=2){if(null!=n&&"function"!=typeof n)throw Error("invalid callback: "+n);for(;++a<s;)if(e=(t=o[a]).type)i[e]=Lt(i[e],t.name,n);else if(null==n)for(e in i)i[e]=Lt(i[e],t.name,null);return this}for(;++a<s;)if((e=(t=o[a]).type)&&(e=Tt(i[e],t.name)))return e},copy:function(){var t={},n=this._;for(var e in n)t[e]=n[e].slice();return new Dt(t)},call:function(t,n){if((e=arguments.length-2)>0)for(var e,r,i=Array(e),o=0;e>o;++o)i[o]=arguments[o+2];if(!this._.hasOwnProperty(t))throw Error("unknown type: "+t);for(o=0,e=(r=this._[t]).length;e>o;++o)r[o].value.apply(n,i)},apply:function(t,n,e){if(!this._.hasOwnProperty(t))throw Error("unknown type: "+t);for(var r=this._[t],i=0,o=r.length;o>i;++i)r[i].value.apply(n,e)}};const Rt=Nt;var Ft,Pt,It=0,Ot=0,qt=0,Vt=0,Xt=0,Ut=0,jt="object"==typeof performance&&performance.now?performance:Date,Bt="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(t){setTimeout(t,17)};function Ht(){return Xt||(Bt(zt),Xt=jt.now()+Ut)}function zt(){Xt=0}function Yt(){this._call=this._time=this._next=null}function Gt(t,n,e){var r=new Yt;return r.restart(t,n,e),r}function Qt(){Xt=(Vt=jt.now())+Ut,It=Ot=0;try{!function(){Ht(),++It;for(var t,n=Ft;n;)0>(t=Xt-n._time)||n._call.call(void 0,t),n=n._next;--It}()}finally{It=0,function(){for(var t,n,e=Ft,r=1/0;e;)e._call?(r>e._time&&(r=e._time),t=e,e=e._next):(n=e._next,e._next=null,e=t?t._next=n:Ft=n);Pt=t,Zt(r)}(),Xt=0}}function Wt(){var t=jt.now(),n=t-Vt;n>1e3&&(Ut-=n,Vt=t)}function Zt(t){It||(Ot&&(Ot=clearTimeout(Ot)),t-Xt>24?(1/0>t&&(Ot=setTimeout(Qt,t-jt.now()-Ut)),qt&&(qt=clearInterval(qt))):(qt||(Vt=jt.now(),qt=setInterval(Wt,1e3)),It=1,Bt(Qt)))}function Kt(t,n,e){var r=new Yt;return n=null==n?0:+n,r.restart(e=>{r.stop(),t(e+n)},n,e),r}Yt.prototype=Gt.prototype={constructor:Yt,restart:function(t,n,e){if("function"!=typeof t)throw new TypeError("callback is not a function");e=(null==e?Ht():+e)+(null==n?0:+n),this._next||Pt===this||(Pt?Pt._next=this:Ft=this,Pt=this),this._call=t,this._time=e,Zt()},stop:function(){this._call&&(this._call=null,this._time=1/0,Zt())}};var Jt=Rt("start","end","cancel","interrupt"),tn=[];function nn(t,n,e,r,i,o){var a=t.__transition;if(a){if(e in a)return}else t.__transition={};!function(t,n,e){var r,i=t.__transition;function o(u){var l,c,h,f;if(1!==e.state)return s();for(l in i)if((f=i[l]).name===e.name){if(3===f.state)return Kt(o);4===f.state?(f.state=6,f.timer.stop(),f.on.call("interrupt",t,t.__data__,f.index,f.group),delete i[l]):n>+l&&(f.state=6,f.timer.stop(),f.on.call("cancel",t,t.__data__,f.index,f.group),delete i[l])}if(Kt(function(){3===e.state&&(e.state=4,e.timer.restart(a,e.delay,e.time),a(u))}),e.state=2,e.on.call("start",t,t.__data__,e.index,e.group),2===e.state){for(e.state=3,r=Array(h=e.tween.length),l=0,c=-1;h>l;++l)(f=e.tween[l].value.call(t,t.__data__,e.index,e.group))&&(r[++c]=f);r.length=c+1}}function a(n){for(var i=n<e.duration?e.ease.call(null,n/e.duration):(e.timer.restart(s),e.state=5,1),o=-1,a=r.length;++o<a;)r[o].call(t,i);5===e.state&&(e.on.call("end",t,t.__data__,e.index,e.group),s())}function s(){for(var r in e.state=6,e.timer.stop(),delete i[n],i)return;delete t.__transition}i[n]=e,e.timer=Gt(function(t){e.state=1,e.timer.restart(o,e.delay,e.time),e.delay>t||o(t-e.delay)},0,e.time)}(t,e,{name:n,index:r,group:i,on:Jt,tween:tn,time:o.time,delay:o.delay,duration:o.duration,ease:o.ease,timer:null,state:0})}function en(t,n){var e=on(t,n);if(e.state>0)throw Error("too late; already scheduled");return e}function rn(t,n){var e=on(t,n);if(e.state>3)throw Error("too late; already running");return e}function on(t,n){var e=t.__transition;if(!e||!(e=e[n]))throw Error("transition not found");return e}function an(t,n){return t=+t,n=+n,function(e){return t*(1-e)+n*e}}var sn,un=180/Math.PI,ln={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function cn(t,n,e,r,i,o){var a,s,u;return(a=Math.sqrt(t*t+n*n))&&(t/=a,n/=a),(u=t*e+n*r)&&(e-=t*u,r-=n*u),(s=Math.sqrt(e*e+r*r))&&(e/=s,r/=s,u/=s),n*e>t*r&&(t=-t,n=-n,u=-u,a=-a),{translateX:i,translateY:o,rotate:Math.atan2(n,t)*un,skewX:Math.atan(u)*un,scaleX:a,scaleY:s}}function hn(t,n,e,r){function i(t){return t.length?t.pop()+" ":""}return function(o,a){var s=[],u=[];return o=t(o),a=t(a),function(t,r,i,o,a,s){if(t!==i||r!==o){var u=a.push("translate(",null,n,null,e);s.push({i:u-4,x:an(t,i)},{i:u-2,x:an(r,o)})}else(i||o)&&a.push("translate("+i+n+o+e)}(o.translateX,o.translateY,a.translateX,a.translateY,s,u),function(t,n,e,o){t!==n?(t-n>180?n+=360:n-t>180&&(t+=360),o.push({i:e.push(i(e)+"rotate(",null,r)-2,x:an(t,n)})):n&&e.push(i(e)+"rotate("+n+r)}(o.rotate,a.rotate,s,u),function(t,n,e,o){t!==n?o.push({i:e.push(i(e)+"skewX(",null,r)-2,x:an(t,n)}):n&&e.push(i(e)+"skewX("+n+r)}(o.skewX,a.skewX,s,u),function(t,n,e,r,o,a){if(t!==e||n!==r){var s=o.push(i(o)+"scale(",null,",",null,")");a.push({i:s-4,x:an(t,e)},{i:s-2,x:an(n,r)})}else 1===e&&1===r||o.push(i(o)+"scale("+e+","+r+")")}(o.scaleX,o.scaleY,a.scaleX,a.scaleY,s,u),o=a=null,function(t){for(var n,e=-1,r=u.length;++e<r;)s[(n=u[e]).i]=n.x(t);return s.join("")}}}var fn=hn(function(t){const n=new("function"==typeof DOMMatrix?DOMMatrix:WebKitCSSMatrix)(t+"");return n.isIdentity?ln:cn(n.a,n.b,n.c,n.d,n.e,n.f)},"px, ","px)","deg)"),dn=hn(function(t){return null==t?ln:(sn||(sn=document.createElementNS("http://www.w3.org/2000/svg","g")),sn.setAttribute("transform",t),(t=sn.transform.baseVal.consolidate())?cn((t=t.matrix).a,t.b,t.c,t.d,t.e,t.f):ln)},", ",")",")");function pn(t,n){var e,r;return function(){var i=rn(this,t),o=i.tween;if(o!==e)for(var a=0,s=(r=e=o).length;s>a;++a)if(r[a].name===n){(r=r.slice()).splice(a,1);break}i.tween=r}}function gn(t,n,e){var r,i;if("function"!=typeof e)throw Error();return function(){var o=rn(this,t),a=o.tween;if(a!==r){i=(r=a).slice();for(var s={name:n,value:e},u=0,l=i.length;l>u;++u)if(i[u].name===n){i[u]=s;break}u===l&&i.push(s)}o.tween=i}}function mn(t,n,e){var r=t._id;return t.each(function(){var t=rn(this,r);(t.value||(t.value={}))[n]=e.apply(this,arguments)}),function(t){return on(t,r).value[n]}}function yn(t,n,e){t.prototype=n.prototype=e,e.constructor=t}function vn(t,n){var e=Object.create(t.prototype);for(var r in n)e[r]=n[r];return e}function _n(){}var wn=.7,xn=1/wn,bn="\\s*([+-]?\\d+)\\s*",Mn="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",En="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",Cn=/^#([0-9a-f]{3,8})$/,kn=RegExp(`^rgb\\(${bn},${bn},${bn}\\)$`),Sn=RegExp(`^rgb\\(${En},${En},${En}\\)$`),$n=RegExp(`^rgba\\(${bn},${bn},${bn},${Mn}\\)$`),An=RegExp(`^rgba\\(${En},${En},${En},${Mn}\\)$`),Nn=RegExp(`^hsl\\(${Mn},${En},${En}\\)$`),Dn=RegExp(`^hsla\\(${Mn},${En},${En},${Mn}\\)$`),Tn={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function Ln(){return this.rgb().formatHex()}function Rn(){return this.rgb().formatRgb()}function Fn(t){var n,e;return t=(t+"").trim().toLowerCase(),(n=Cn.exec(t))?(e=n[1].length,n=parseInt(n[1],16),6===e?Pn(n):3===e?new qn(n>>8&15|n>>4&240,n>>4&15|240&n,(15&n)<<4|15&n,1):8===e?In(n>>24&255,n>>16&255,n>>8&255,(255&n)/255):4===e?In(n>>12&15|n>>8&240,n>>8&15|n>>4&240,n>>4&15|240&n,((15&n)<<4|15&n)/255):null):(n=kn.exec(t))?new qn(n[1],n[2],n[3],1):(n=Sn.exec(t))?new qn(255*n[1]/100,255*n[2]/100,255*n[3]/100,1):(n=$n.exec(t))?In(n[1],n[2],n[3],n[4]):(n=An.exec(t))?In(255*n[1]/100,255*n[2]/100,255*n[3]/100,n[4]):(n=Nn.exec(t))?Hn(n[1],n[2]/100,n[3]/100,1):(n=Dn.exec(t))?Hn(n[1],n[2]/100,n[3]/100,n[4]):Tn.hasOwnProperty(t)?Pn(Tn[t]):"transparent"===t?new qn(NaN,NaN,NaN,0):null}function Pn(t){return new qn(t>>16&255,t>>8&255,255&t,1)}function In(t,n,e,r){return r>0||(t=n=e=NaN),new qn(t,n,e,r)}function On(t,n,e,r){return 1===arguments.length?((i=t)instanceof _n||(i=Fn(i)),i?new qn((i=i.rgb()).r,i.g,i.b,i.opacity):new qn):new qn(t,n,e,null==r?1:r);var i}function qn(t,n,e,r){this.r=+t,this.g=+n,this.b=+e,this.opacity=+r}function Vn(){return`#${Bn(this.r)}${Bn(this.g)}${Bn(this.b)}`}function Xn(){const t=Un(this.opacity);return`${1===t?"rgb(":"rgba("}${jn(this.r)}, ${jn(this.g)}, ${jn(this.b)}${1===t?")":`, ${t})`}`}function Un(t){return isNaN(t)?1:Math.max(0,Math.min(1,t))}function jn(t){return Math.max(0,Math.min(255,Math.round(t)||0))}function Bn(t){return(16>(t=jn(t))?"0":"")+t.toString(16)}function Hn(t,n,e,r){return r>0?e>0&&1>e?n>0||(t=NaN):t=n=NaN:t=n=e=NaN,new Yn(t,n,e,r)}function zn(t){if(t instanceof Yn)return new Yn(t.h,t.s,t.l,t.opacity);if(t instanceof _n||(t=Fn(t)),!t)return new Yn;if(t instanceof Yn)return t;var n=(t=t.rgb()).r/255,e=t.g/255,r=t.b/255,i=Math.min(n,e,r),o=Math.max(n,e,r),a=NaN,s=o-i,u=(o+i)/2;return s?(a=n===o?(e-r)/s+6*(r>e):e===o?(r-n)/s+2:(n-e)/s+4,s/=.5>u?o+i:2-o-i,a*=60):s=u>0&&1>u?0:a,new Yn(a,s,u,t.opacity)}function Yn(t,n,e,r){this.h=+t,this.s=+n,this.l=+e,this.opacity=+r}function Gn(t){return 0>(t=(t||0)%360)?t+360:t}function Qn(t){return Math.max(0,Math.min(1,t||0))}function Wn(t,n,e){return 255*(60>t?n+(e-n)*t/60:180>t?e:240>t?n+(e-n)*(240-t)/60:n)}function Zn(t,n,e,r,i){var o=t*t,a=o*t;return((1-3*t+3*o-a)*n+(4-6*o+3*a)*e+(1+3*t+3*o-3*a)*r+a*i)/6}yn(_n,Fn,{copy(t){return Object.assign(new this.constructor,this,t)},displayable(){return this.rgb().displayable()},hex:Ln,formatHex:Ln,formatHex8:function(){return this.rgb().formatHex8()},formatHsl:function(){return zn(this).formatHsl()},formatRgb:Rn,toString:Rn}),yn(qn,On,vn(_n,{brighter(t){return t=null==t?xn:Math.pow(xn,t),new qn(this.r*t,this.g*t,this.b*t,this.opacity)},darker(t){return t=null==t?wn:Math.pow(wn,t),new qn(this.r*t,this.g*t,this.b*t,this.opacity)},rgb(){return this},clamp(){return new qn(jn(this.r),jn(this.g),jn(this.b),Un(this.opacity))},displayable(){return this.r>=-.5&&255.5>this.r&&this.g>=-.5&&255.5>this.g&&this.b>=-.5&&255.5>this.b&&this.opacity>=0&&1>=this.opacity},hex:Vn,formatHex:Vn,formatHex8:function(){return`#${Bn(this.r)}${Bn(this.g)}${Bn(this.b)}${Bn(255*(isNaN(this.opacity)?1:this.opacity))}`},formatRgb:Xn,toString:Xn})),yn(Yn,function(t,n,e,r){return 1===arguments.length?zn(t):new Yn(t,n,e,null==r?1:r)},vn(_n,{brighter(t){return t=null==t?xn:Math.pow(xn,t),new Yn(this.h,this.s,this.l*t,this.opacity)},darker(t){return t=null==t?wn:Math.pow(wn,t),new Yn(this.h,this.s,this.l*t,this.opacity)},rgb(){var t=this.h%360+360*(0>this.h),n=isNaN(t)||isNaN(this.s)?0:this.s,e=this.l,r=e+(.5>e?e:1-e)*n,i=2*e-r;return new qn(Wn(240>t?t+120:t-240,i,r),Wn(t,i,r),Wn(120>t?t+240:t-120,i,r),this.opacity)},clamp(){return new Yn(Gn(this.h),Qn(this.s),Qn(this.l),Un(this.opacity))},displayable(){return(this.s>=0&&1>=this.s||isNaN(this.s))&&this.l>=0&&1>=this.l&&this.opacity>=0&&1>=this.opacity},formatHsl(){const t=Un(this.opacity);return`${1===t?"hsl(":"hsla("}${Gn(this.h)}, ${100*Qn(this.s)}%, ${100*Qn(this.l)}%${1===t?")":`, ${t})`}`}}));const Kn=t=>()=>t;function Jn(t,n){var e=n-t;return e?function(t,n){return function(e){return t+e*n}}(t,e):Kn(isNaN(t)?n:t)}const te=function t(n){var e=function(t){return 1===(t=+t)?Jn:function(n,e){return e-n?function(t,n,e){return t=Math.pow(t,e),n=Math.pow(n,e)-t,e=1/e,function(r){return Math.pow(t+r*n,e)}}(n,e,t):Kn(isNaN(n)?e:n)}}(n);function r(t,n){var r=e((t=On(t)).r,(n=On(n)).r),i=e(t.g,n.g),o=e(t.b,n.b),a=Jn(t.opacity,n.opacity);return function(n){return t.r=r(n),t.g=i(n),t.b=o(n),t.opacity=a(n),t+""}}return r.gamma=t,r}(1);function ne(t){return function(n){var e,r,i=n.length,o=Array(i),a=Array(i),s=Array(i);for(e=0;i>e;++e)r=On(n[e]),o[e]=r.r||0,a[e]=r.g||0,s[e]=r.b||0;return o=t(o),a=t(a),s=t(s),r.opacity=1,function(t){return r.r=o(t),r.g=a(t),r.b=s(t),r+""}}}ne(function(t){var n=t.length-1;return function(e){var r=e>0?1>e?Math.floor(e*n):(e=1,n-1):e=0,i=t[r],o=t[r+1],a=r>0?t[r-1]:2*i-o,s=n-1>r?t[r+2]:2*o-i;return Zn((e-r/n)*n,a,i,o,s)}}),ne(function(t){var n=t.length;return function(e){var r=Math.floor((0>(e%=1)?++e:e)*n),i=t[(r+n-1)%n],o=t[r%n],a=t[(r+1)%n],s=t[(r+2)%n];return Zn((e-r/n)*n,i,o,a,s)}});var ee=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,re=RegExp(ee.source,"g");function ie(t,n){var e,r,i,o=ee.lastIndex=re.lastIndex=0,a=-1,s=[],u=[];for(t+="",n+="";(e=ee.exec(t))&&(r=re.exec(n));)(i=r.index)>o&&(i=n.slice(o,i),s[a]?s[a]+=i:s[++a]=i),(e=e[0])===(r=r[0])?s[a]?s[a]+=r:s[++a]=r:(s[++a]=null,u.push({i:a,x:an(e,r)})),o=re.lastIndex;return o<n.length&&(i=n.slice(o),s[a]?s[a]+=i:s[++a]=i),2>s.length?u[0]?function(t){return function(n){return t(n)+""}}(u[0].x):function(t){return function(){return t}}(n):(n=u.length,function(t){for(var e,r=0;n>r;++r)s[(e=u[r]).i]=e.x(t);return s.join("")})}function oe(t,n){var e;return("number"==typeof n?an:n instanceof Fn?te:(e=Fn(n))?(n=e,te):ie)(t,n)}function ae(t){return function(){this.removeAttribute(t)}}function se(t){return function(){this.removeAttributeNS(t.space,t.local)}}function ue(t,n,e){var r,i,o=e+"";return function(){var a=this.getAttribute(t);return a===o?null:a===r?i:i=n(r=a,e)}}function le(t,n,e){var r,i,o=e+"";return function(){var a=this.getAttributeNS(t.space,t.local);return a===o?null:a===r?i:i=n(r=a,e)}}function ce(t,n,e){var r,i,o;return function(){var a,s,u=e(this);if(null!=u)return(a=this.getAttribute(t))===(s=u+"")?null:a===r&&s===i?o:(i=s,o=n(r=a,u));this.removeAttribute(t)}}function he(t,n,e){var r,i,o;return function(){var a,s,u=e(this);if(null!=u)return(a=this.getAttributeNS(t.space,t.local))===(s=u+"")?null:a===r&&s===i?o:(i=s,o=n(r=a,u));this.removeAttributeNS(t.space,t.local)}}function fe(t,n){var e,r;function i(){var i=n.apply(this,arguments);return i!==r&&(e=(r=i)&&function(t,n){return function(e){this.setAttributeNS(t.space,t.local,n.call(this,e))}}(t,i)),e}return i._value=n,i}function de(t,n){var e,r;function i(){var i=n.apply(this,arguments);return i!==r&&(e=(r=i)&&function(t,n){return function(e){this.setAttribute(t,n.call(this,e))}}(t,i)),e}return i._value=n,i}function pe(t,n){return function(){en(this,t).delay=+n.apply(this,arguments)}}function ge(t,n){return n=+n,function(){en(this,t).delay=n}}function me(t,n){return function(){rn(this,t).duration=+n.apply(this,arguments)}}function ye(t,n){return n=+n,function(){rn(this,t).duration=n}}var ve=$t.prototype.constructor;function _e(t){return function(){this.style.removeProperty(t)}}var we=0;function xe(t,n,e,r){this._groups=t,this._parents=n,this._name=e,this._id=r}function be(){return++we}var Me=$t.prototype;xe.prototype=function(t){return $t().transition(t)}.prototype={constructor:xe,select:function(t){var n=this._name,e=this._id;"function"!=typeof t&&(t=v(t));for(var r=this._groups,i=r.length,o=Array(i),a=0;i>a;++a)for(var s,u,l=r[a],c=l.length,h=o[a]=Array(c),f=0;c>f;++f)(s=l[f])&&(u=t.call(s,s.__data__,f,l))&&("__data__"in s&&(u.__data__=s.__data__),h[f]=u,nn(h[f],n,e,f,h,on(s,e)));return new xe(o,this._parents,n,e)},selectAll:function(t){var n=this._name,e=this._id;"function"!=typeof t&&(t=w(t));for(var r=this._groups,i=r.length,o=[],a=[],s=0;i>s;++s)for(var u,l=r[s],c=l.length,h=0;c>h;++h)if(u=l[h]){for(var f,d=t.call(u,u.__data__,h,l),p=on(u,e),g=0,m=d.length;m>g;++g)(f=d[g])&&nn(f,n,e,g,d,p);o.push(d),a.push(u)}return new xe(o,a,n,e)},selectChild:Me.selectChild,selectChildren:Me.selectChildren,filter:function(t){"function"!=typeof t&&(t=x(t));for(var n=this._groups,e=n.length,r=Array(e),i=0;e>i;++i)for(var o,a=n[i],s=a.length,u=r[i]=[],l=0;s>l;++l)(o=a[l])&&t.call(o,o.__data__,l,a)&&u.push(o);return new xe(r,this._parents,this._name,this._id)},merge:function(t){if(t._id!==this._id)throw Error();for(var n=this._groups,e=t._groups,r=n.length,i=e.length,o=Math.min(r,i),a=Array(r),s=0;o>s;++s)for(var u,l=n[s],c=e[s],h=l.length,f=a[s]=Array(h),d=0;h>d;++d)(u=l[d]||c[d])&&(f[d]=u);for(;r>s;++s)a[s]=n[s];return new xe(a,this._parents,this._name,this._id)},selection:function(){return new ve(this._groups,this._parents)},transition:function(){for(var t=this._name,n=this._id,e=be(),r=this._groups,i=r.length,o=0;i>o;++o)for(var a,s=r[o],u=s.length,l=0;u>l;++l)if(a=s[l]){var c=on(a,n);nn(a,t,e,l,s,{time:c.time+c.delay+c.duration,delay:0,duration:c.duration,ease:c.ease})}return new xe(r,this._parents,t,e)},call:Me.call,nodes:Me.nodes,node:Me.node,size:Me.size,empty:Me.empty,each:Me.each,on:function(t,n){var e=this._id;return 2>arguments.length?on(this.node(),e).on.on(t):this.each(function(t,n,e){var r,i,o=function(t){return(t+"").trim().split(/^|\s+/).every(function(t){var n=t.indexOf(".");return 0>n||(t=t.slice(0,n)),!t||"start"===t})}(n)?en:rn;return function(){var a=o(this,t),s=a.on;s!==r&&(i=(r=s).copy()).on(n,e),a.on=i}}(e,t,n))},attr:function(t,n){var e=P(t),r="transform"===e?dn:oe;return this.attrTween(t,"function"==typeof n?(e.local?he:ce)(e,r,mn(this,"attr."+t,n)):null==n?(e.local?se:ae)(e):(e.local?le:ue)(e,r,n))},attrTween:function(t,n){var e="attr."+t;if(2>arguments.length)return(e=this.tween(e))&&e._value;if(null==n)return this.tween(e,null);if("function"!=typeof n)throw Error();var r=P(t);return this.tween(e,(r.local?fe:de)(r,n))},style:function(t,n,e){var r="transform"==(t+="")?fn:oe;return null==n?this.styleTween(t,function(t,n){var e,r,i;return function(){var o=Y(this,t),a=(this.style.removeProperty(t),Y(this,t));return o===a?null:o===e&&a===r?i:i=n(e=o,r=a)}}(t,r)).on("end.style."+t,_e(t)):"function"==typeof n?this.styleTween(t,function(t,n,e){var r,i,o;return function(){var a=Y(this,t),s=e(this),u=s+"";return null==s&&(this.style.removeProperty(t),u=s=Y(this,t)),a===u?null:a===r&&u===i?o:(i=u,o=n(r=a,s))}}(t,r,mn(this,"style."+t,n))).each(function(t,n){var e,r,i,o,a="style."+n,s="end."+a;return function(){var u=rn(this,t),l=u.on,c=null==u.value[a]?o||(o=_e(n)):void 0;l===e&&i===c||(r=(e=l).copy()).on(s,i=c),u.on=r}}(this._id,t)):this.styleTween(t,function(t,n,e){var r,i,o=e+"";return function(){var a=Y(this,t);return a===o?null:a===r?i:i=n(r=a,e)}}(t,r,n),e).on("end.style."+t,null)},styleTween:function(t,n,e){var r="style."+(t+="");if(2>arguments.length)return(r=this.tween(r))&&r._value;if(null==n)return this.tween(r,null);if("function"!=typeof n)throw Error();return this.tween(r,function(t,n,e){var r,i;function o(){var o=n.apply(this,arguments);return o!==i&&(r=(i=o)&&function(t,n,e){return function(r){this.style.setProperty(t,n.call(this,r),e)}}(t,o,e)),r}return o._value=n,o}(t,n,null==e?"":e))},text:function(t){return this.tween("text","function"==typeof t?function(t){return function(){var n=t(this);this.textContent=null==n?"":n}}(mn(this,"text",t)):function(t){return function(){this.textContent=t}}(null==t?"":t+""))},textTween:function(t){var n="text";if(1>arguments.length)return(n=this.tween(n))&&n._value;if(null==t)return this.tween(n,null);if("function"!=typeof t)throw Error();return this.tween(n,function(t){var n,e;function r(){var r=t.apply(this,arguments);return r!==e&&(n=(e=r)&&function(t){return function(n){this.textContent=t.call(this,n)}}(r)),n}return r._value=t,r}(t))},remove:function(){return this.on("end.remove",function(t){return function(){var n=this.parentNode;for(var e in this.__transition)if(+e!==t)return;n&&n.removeChild(this)}}(this._id))},tween:function(t,n){var e=this._id;if(t+="",2>arguments.length){for(var r,i=on(this.node(),e).tween,o=0,a=i.length;a>o;++o)if((r=i[o]).name===t)return r.value;return null}return this.each((null==n?pn:gn)(e,t,n))},delay:function(t){var n=this._id;return arguments.length?this.each(("function"==typeof t?pe:ge)(n,t)):on(this.node(),n).delay},duration:function(t){var n=this._id;return arguments.length?this.each(("function"==typeof t?me:ye)(n,t)):on(this.node(),n).duration},ease:function(t){var n=this._id;return arguments.length?this.each(function(t,n){if("function"!=typeof n)throw Error();return function(){rn(this,t).ease=n}}(n,t)):on(this.node(),n).ease},easeVarying:function(t){if("function"!=typeof t)throw Error();return this.each(function(t,n){return function(){var e=n.apply(this,arguments);if("function"!=typeof e)throw Error();rn(this,t).ease=e}}(this._id,t))},end:function(){var t,n,e=this,r=e._id,i=e.size();return new Promise(function(o,a){var s={value:a},u={value:function(){0===--i&&o()}};e.each(function(){var e=rn(this,r),i=e.on;i!==t&&((n=(t=i).copy())._.cancel.push(s),n._.interrupt.push(s),n._.end.push(u)),e.on=n}),0===i&&o()})},[Symbol.iterator]:Me[Symbol.iterator]};var Ee={time:null,delay:0,duration:250,ease:function(t){return((t*=2)>1?(t-=2)*t*t+2:t*t*t)/2}};function Ce(t,n){for(var e;!(e=t.__transition)||!(e=e[n]);)if(!(t=t.parentNode))throw Error(`transition ${n} not found`);return e}$t.prototype.interrupt=function(t){return this.each(function(){!function(t,n){var e,r,i,o=t.__transition,a=!0;if(o){for(i in n=null==n?null:n+"",o)(e=o[i]).name===n?(r=e.state>2&&5>e.state,e.state=6,e.timer.stop(),e.on.call(r?"interrupt":"cancel",t,t.__data__,e.index,e.group),delete o[i]):a=!1;a&&delete t.__transition}}(this,t)})},$t.prototype.transition=function(t){var n,e;t instanceof xe?(n=t._id,t=t._name):(n=be(),(e=Ee).time=Ht(),t=null==t?null:t+"");for(var r=this._groups,i=r.length,o=0;i>o;++o)for(var a,s=r[o],u=s.length,l=0;u>l;++l)(a=s[l])&&nn(a,t,n,l,s,e||Ce(a,n));return new xe(r,this._parents,t,n)};const{abs:ke,max:Se,min:$e}=Math;function Ae(t){return{type:t}}function Ne(t,n){switch(arguments.length){case 0:break;case 1:this.range(t);break;default:this.range(n).domain(t)}return this}["w","e"].map(Ae),["n","s"].map(Ae),["n","w","e","s","nw","ne","sw","se"].map(Ae);class De extends Map{constructor(t,n=Le){if(super(),Object.defineProperties(this,{_intern:{value:new Map},_key:{value:n}}),null!=t)for(const[e,r]of t)this.set(e,r)}get(t){return super.get(Te(this,t))}has(t){return super.has(Te(this,t))}set(t,n){return super.set(function({_intern:t,_key:n},e){const r=n(e);return t.has(r)?t.get(r):(t.set(r,e),e)}(this,t),n)}delete(t){return super.delete(function({_intern:t,_key:n},e){const r=n(e);return t.has(r)&&(e=t.get(r),t.delete(r)),e}(this,t))}}function Te({_intern:t,_key:n},e){const r=n(e);return t.has(r)?t.get(r):e}function Le(t){return null!==t&&"object"==typeof t?t.valueOf():t}Set;const Re=Symbol("implicit");function Fe(){var t=new De,n=[],e=[],r=Re;function i(i){let o=t.get(i);if(void 0===o){if(r!==Re)return r;t.set(i,o=n.push(i)-1)}return e[o%e.length]}return i.domain=function(e){if(!arguments.length)return n.slice();n=[],t=new De;for(const r of e)t.has(r)||t.set(r,n.push(r)-1);return i},i.range=function(t){return arguments.length?(e=Array.from(t),i):e.slice()},i.unknown=function(t){return arguments.length?(r=t,i):r},i.copy=function(){return Fe(n,e).unknown(r)},Ne.apply(i,arguments),i}function Pe(){var t,n,e=Fe().unknown(void 0),r=e.domain,i=e.range,o=0,a=1,s=!1,u=0,l=0,c=.5;function h(){var e=r().length,h=o>a,f=h?a:o,d=h?o:a;t=(d-f)/Math.max(1,e-u+2*l),s&&(t=Math.floor(t)),f+=(d-f-t*(e-u))*c,n=t*(1-u),s&&(f=Math.round(f),n=Math.round(n));var p=function(t,n,e){t=+t,n=+n,e=2>(i=arguments.length)?(n=t,t=0,1):3>i?1:+e;for(var r=-1,i=0|Math.max(0,Math.ceil((n-t)/e)),o=Array(i);++r<i;)o[r]=t+r*e;return o}(e).map(function(n){return f+t*n});return i(h?p.reverse():p)}return delete e.unknown,e.domain=function(t){return arguments.length?(r(t),h()):r()},e.range=function(t){return arguments.length?([o,a]=t,o=+o,a=+a,h()):[o,a]},e.rangeRound=function(t){return[o,a]=t,o=+o,a=+a,s=!0,h()},e.bandwidth=function(){return n},e.step=function(){return t},e.round=function(t){return arguments.length?(s=!!t,h()):s},e.padding=function(t){return arguments.length?(u=Math.min(1,l=+t),h()):u},e.paddingInner=function(t){return arguments.length?(u=Math.min(1,t),h()):u},e.paddingOuter=function(t){return arguments.length?(l=+t,h()):l},e.align=function(t){return arguments.length?(c=Math.max(0,Math.min(1,t)),h()):c},e.copy=function(){return Pe(r(),[o,a]).round(s).paddingInner(u).paddingOuter(l).align(c)},Ne.apply(h(),arguments)}function Ie(t){var n=t.copy;return t.padding=t.paddingOuter,delete t.paddingInner,delete t.paddingOuter,t.copy=function(){return Ie(n())},t}function Oe(){return Ie(Pe.apply(null,arguments).paddingInner(1))}const qe=Math.sqrt(50),Ve=Math.sqrt(10),Xe=Math.sqrt(2);function Ue(t,n,e){const r=(n-t)/Math.max(0,e),i=Math.floor(Math.log10(r)),o=r/Math.pow(10,i),a=qe>o?Ve>o?Xe>o?1:2:5:10;let s,u,l;return 0>i?(l=Math.pow(10,-i)/a,s=Math.round(t*l),u=Math.round(n*l),t>s/l&&++s,u/l>n&&--u,l=-l):(l=Math.pow(10,i)*a,s=Math.round(t/l),u=Math.round(n/l),t>s*l&&++s,u*l>n&&--u),s>u&&e>=.5&&2>e?Ue(t,n,2*e):[s,u,l]}function je(t,n,e){if(0>=(e=+e))return[];if((t=+t)===(n=+n))return[t];const r=t>n,[i,o,a]=r?Ue(n,t,e):Ue(t,n,e);if(i>o)return[];const s=o-i+1,u=Array(s);if(r)if(0>a)for(let l=0;s>l;++l)u[l]=(o-l)/-a;else for(let l=0;s>l;++l)u[l]=(o-l)*a;else if(0>a)for(let l=0;s>l;++l)u[l]=(i+l)/-a;else for(let l=0;s>l;++l)u[l]=(i+l)*a;return u}function Be(t,n,e){return Ue(t=+t,n=+n,e=+e)[2]}function He(t,n){return null==t||null==n?NaN:n>t?-1:t>n?1:n>t?NaN:0}function ze(t,n){return null==t||null==n?NaN:t>n?-1:n>t?1:t>n?NaN:0}function Ye(t){let n,e,r;function i(t,r,i=0,o=t.length){if(o>i){if(0!==n(r,r))return o;do{const n=i+o>>>1;0>e(t[n],r)?i=n+1:o=n}while(o>i)}return i}return 2!==t.length?(n=He,e=(n,e)=>He(t(n),e),r=(n,e)=>t(n)-e):(n=t===He||t===ze?t:Ge,e=t,r=t),{left:i,center:function(t,n,e=0,o=t.length){const a=i(t,n,e,o-1);return a>e&&r(t[a-1],n)>-r(t[a],n)?a-1:a},right:function(t,r,i=0,o=t.length){if(o>i){if(0!==n(r,r))return o;do{const n=i+o>>>1;e(t[n],r)>0?o=n:i=n+1}while(o>i)}return i}}}function Ge(){return 0}const Qe=Ye(He),We=Qe.right,Ze=(Qe.left,Ye(function(t){return null===t?NaN:+t}).center,We);function Ke(t,n){var e,r=n?n.length:0,i=t?Math.min(r,t.length):0,o=Array(i),a=Array(r);for(e=0;i>e;++e)o[e]=er(t[e],n[e]);for(;r>e;++e)a[e]=n[e];return function(t){for(e=0;i>e;++e)a[e]=o[e](t);return a}}function Je(t,n){var e=new Date;return t=+t,n=+n,function(r){return e.setTime(t*(1-r)+n*r),e}}function tr(t,n){var e,r={},i={};for(e in null!==t&&"object"==typeof t||(t={}),null!==n&&"object"==typeof n||(n={}),n)e in t?r[e]=er(t[e],n[e]):i[e]=n[e];return function(t){for(e in r)i[e]=r[e](t);return i}}function nr(t,n){n||(n=[]);var e,r=t?Math.min(n.length,t.length):0,i=n.slice();return function(o){for(e=0;r>e;++e)i[e]=t[e]*(1-o)+n[e]*o;return i}}function er(t,n){var e,r,i=typeof n;return null==n||"boolean"===i?Kn(n):("number"===i?an:"string"===i?(e=Fn(n))?(n=e,te):ie:n instanceof Fn?te:n instanceof Date?Je:(r=n,!ArrayBuffer.isView(r)||r instanceof DataView?Array.isArray(n)?Ke:"function"!=typeof n.valueOf&&"function"!=typeof n.toString||isNaN(n)?tr:an:nr))(t,n)}function rr(t,n){return t=+t,n=+n,function(e){return Math.round(t*(1-e)+n*e)}}function ir(t){return+t}var or=[0,1];function ar(t){return t}function sr(t,n){return(n-=t=+t)?function(e){return(e-t)/n}:(e=isNaN(n)?NaN:.5,function(){return e});var e}function ur(t,n,e){var r=t[0],i=t[1],o=n[0],a=n[1];return r>i?(r=sr(i,r),o=e(a,o)):(r=sr(r,i),o=e(o,a)),function(t){return o(r(t))}}function lr(t,n,e){var r=Math.min(t.length,n.length)-1,i=Array(r),o=Array(r),a=-1;for(t[r]<t[0]&&(t=t.slice().reverse(),n=n.slice().reverse());++a<r;)i[a]=sr(t[a],t[a+1]),o[a]=e(n[a],n[a+1]);return function(n){var e=Ze(t,n,1,r)-1;return o[e](i[e](n))}}function cr(t,n){return n.domain(t.domain()).range(t.range()).interpolate(t.interpolate()).clamp(t.clamp()).unknown(t.unknown())}function hr(){var t,n,e,r,i,o,a=or,s=or,u=er,l=ar;function c(){var t,n,e,u=Math.min(a.length,s.length);return l!==ar&&(t=a[0],n=a[u-1],t>n&&(e=t,t=n,n=e),l=function(e){return Math.max(t,Math.min(n,e))}),r=u>2?lr:ur,i=o=null,h}function h(n){return null==n||isNaN(n=+n)?e:(i||(i=r(a.map(t),s,u)))(t(l(n)))}return h.invert=function(e){return l(n((o||(o=r(s,a.map(t),an)))(e)))},h.domain=function(t){return arguments.length?(a=Array.from(t,ir),c()):a.slice()},h.range=function(t){return arguments.length?(s=Array.from(t),c()):s.slice()},h.rangeRound=function(t){return s=Array.from(t),u=rr,c()},h.clamp=function(t){return arguments.length?(l=!!t||ar,c()):l!==ar},h.interpolate=function(t){return arguments.length?(u=t,c()):u},h.unknown=function(t){return arguments.length?(e=t,h):e},function(e,r){return t=e,n=r,c()}}var fr,dr=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function pr(t){if(!(n=dr.exec(t)))throw Error("invalid format: "+t);var n;return new gr({fill:n[1],align:n[2],sign:n[3],symbol:n[4],zero:n[5],width:n[6],comma:n[7],precision:n[8]&&n[8].slice(1),trim:n[9],type:n[10]})}function gr(t){this.fill=void 0===t.fill?" ":t.fill+"",this.align=void 0===t.align?">":t.align+"",this.sign=void 0===t.sign?"-":t.sign+"",this.symbol=void 0===t.symbol?"":t.symbol+"",this.zero=!!t.zero,this.width=void 0===t.width?void 0:+t.width,this.comma=!!t.comma,this.precision=void 0===t.precision?void 0:+t.precision,this.trim=!!t.trim,this.type=void 0===t.type?"":t.type+""}function mr(t,n){if(0>(e=(t=n?t.toExponential(n-1):t.toExponential()).indexOf("e")))return null;var e,r=t.slice(0,e);return[r.length>1?r[0]+r.slice(2):r,+t.slice(e+1)]}function yr(t){return(t=mr(Math.abs(t)))?t[1]:NaN}function vr(t,n){var e=mr(t,n);if(!e)return t+"";var r=e[0],i=e[1];return 0>i?"0."+Array(-i).join("0")+r:r.length>i+1?r.slice(0,i+1)+"."+r.slice(i+1):r+Array(i-r.length+2).join("0")}pr.prototype=gr.prototype,gr.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(void 0===this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(void 0===this.precision?"":"."+Math.max(0,0|this.precision))+(this.trim?"~":"")+this.type};const _r={"%":(t,n)=>(100*t).toFixed(n),b:t=>Math.round(t).toString(2),c:t=>t+"",d:function(t){return 1e21>Math.abs(t=Math.round(t))?t.toString(10):t.toLocaleString("en").replace(/,/g,"")},e:(t,n)=>t.toExponential(n),f:(t,n)=>t.toFixed(n),g:(t,n)=>t.toPrecision(n),o:t=>Math.round(t).toString(8),p:(t,n)=>vr(100*t,n),r:vr,s:function(t,n){var e=mr(t,n);if(!e)return t+"";var r=e[0],i=e[1],o=i-(fr=3*Math.max(-8,Math.min(8,Math.floor(i/3))))+1,a=r.length;return o===a?r:o>a?r+Array(o-a+1).join("0"):o>0?r.slice(0,o)+"."+r.slice(o):"0."+Array(1-o).join("0")+mr(t,Math.max(0,n+o-1))[0]},X:t=>Math.round(t).toString(16).toUpperCase(),x:t=>Math.round(t).toString(16)};function wr(t){return t}var xr,br,Mr,Er=[].map,Cr=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function kr(){var t=hr()(ar,ar);return t.copy=function(){return cr(t,kr())},Ne.apply(t,arguments),function(t){var n=t.domain;return t.ticks=function(t){var e=n();return je(e[0],e[e.length-1],null==t?10:t)},t.tickFormat=function(t,e){var r=n();return function(t,n,e,r){var i,o=function(t,n,e){e=+e;const r=(t=+t)>(n=+n),i=r?Be(n,t,e):Be(t,n,e);return(r?-1:1)*(0>i?1/-i:i)}(t,n,e);switch((r=pr(null==r?",f":r)).type){case"s":var a=Math.max(Math.abs(t),Math.abs(n));return null!=r.precision||isNaN(i=function(t,n){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(yr(n)/3)))-yr(Math.abs(t)))}(o,a))||(r.precision=i),Mr(r,a);case"":case"e":case"g":case"p":case"r":null!=r.precision||isNaN(i=function(t,n){return t=Math.abs(t),Math.max(0,yr(n=Math.abs(n)-t)-yr(t))+1}(o,Math.max(Math.abs(t),Math.abs(n))))||(r.precision=i-("e"===r.type));break;case"f":case"%":null!=r.precision||isNaN(i=function(t){return Math.max(0,-yr(Math.abs(t)))}(o))||(r.precision=i-2*("%"===r.type))}return br(r)}(r[0],r[r.length-1],null==t?10:t,e)},t.nice=function(e){null==e&&(e=10);var r,i,o=n(),a=0,s=o.length-1,u=o[a],l=o[s],c=10;for(u>l&&(i=u,u=l,l=i,i=a,a=s,s=i);c-- >0;){if((i=Be(u,l,e))===r)return o[a]=u,o[s]=l,n(o);if(i>0)u=Math.floor(u/i)*i,l=Math.ceil(l/i)*i;else{if(i>=0)break;u=Math.ceil(u*i)/i,l=Math.floor(l*i)/i}r=i}return t},t}(t)}function Sr(t){return Math.log(t)}function $r(t){return Math.exp(t)}function Ar(t){return-Math.log(-t)}function Nr(t){return-Math.exp(-t)}function Dr(t){return isFinite(t)?+("1e"+t):0>t?0:t}function Tr(t){return(n,e)=>-t(-n,e)}function Lr(){const t=function(t){const n=t(Sr,$r),e=n.domain;let r,i,o=10;function a(){return r=function(t){return t===Math.E?Math.log:10===t&&Math.log10||2===t&&Math.log2||(t=Math.log(t),n=>Math.log(n)/t)}(o),i=function(t){return 10===t?Dr:t===Math.E?Math.exp:n=>Math.pow(t,n)}(o),0>e()[0]?(r=Tr(r),i=Tr(i),t(Ar,Nr)):t(Sr,$r),n}return n.base=function(t){return arguments.length?(o=+t,a()):o},n.domain=function(t){return arguments.length?(e(t),a()):e()},n.ticks=t=>{const n=e();let a=n[0],s=n[n.length-1];const u=a>s;u&&([a,s]=[s,a]);let l,c,h=r(a),f=r(s);const d=null==t?10:+t;let p=[];if(o%1||f-h>=d)p=je(h,f,Math.min(f-h,d)).map(i);else{if(h=Math.floor(h),f=Math.ceil(f),a>0){for(;f>=h;++h)for(l=1;o>l;++l)if(c=0>h?l/i(-h):l*i(h),c>=a){if(c>s)break;p.push(c)}}else for(;f>=h;++h)for(l=o-1;l>=1;--l)if(c=h>0?l/i(-h):l*i(h),c>=a){if(c>s)break;p.push(c)}2*p.length<d&&(p=je(a,s,d))}return u?p.reverse():p},n.tickFormat=(t,e)=>{if(null==t&&(t=10),null==e&&(e=10===o?"s":","),"function"!=typeof e&&(o%1||null!=(e=pr(e)).precision||(e.trim=!0),e=br(e)),t===1/0)return e;const a=Math.max(1,o*t/n.ticks().length);return t=>{let n=t/i(Math.round(r(t)));return o-.5>n*o&&(n*=o),n>a?"":e(t)}},n.nice=()=>e(function(t,n){var e,r=0,i=(t=t.slice()).length-1,o=t[r],a=t[i];return o>a&&(e=r,r=i,i=e,e=o,o=a,a=e),t[r]=n.floor(o),t[i]=n.ceil(a),t}(e(),{floor:t=>i(Math.floor(r(t))),ceil:t=>i(Math.ceil(r(t)))})),n}(hr()).domain([1,10]);return t.copy=()=>cr(t,Lr()).base(t.base()),Ne.apply(t,arguments),t}xr=function(t){var n,e,r=void 0===t.grouping||void 0===t.thousands?wr:(n=Er.call(t.grouping,Number),e=t.thousands+"",function(t,r){for(var i=t.length,o=[],a=0,s=n[0],u=0;i>0&&s>0&&(u+s+1>r&&(s=Math.max(1,r-u)),o.push(t.substring(i-=s,i+s)),(u+=s+1)<=r);)s=n[a=(a+1)%n.length];return o.reverse().join(e)}),i=void 0===t.currency?"":t.currency[0]+"",o=void 0===t.currency?"":t.currency[1]+"",a=void 0===t.decimal?".":t.decimal+"",s=void 0===t.numerals?wr:function(t){return function(n){return n.replace(/[0-9]/g,function(n){return t[+n]})}}(Er.call(t.numerals,String)),u=void 0===t.percent?"%":t.percent+"",l=void 0===t.minus?"−":t.minus+"",c=void 0===t.nan?"NaN":t.nan+"";function h(t){var n=(t=pr(t)).fill,e=t.align,h=t.sign,f=t.symbol,d=t.zero,p=t.width,g=t.comma,m=t.precision,y=t.trim,v=t.type;"n"===v?(g=!0,v="g"):_r[v]||(void 0===m&&(m=12),y=!0,v="g"),(d||"0"===n&&"="===e)&&(d=!0,n="0",e="=");var _="$"===f?i:"#"===f&&/[boxX]/.test(v)?"0"+v.toLowerCase():"",w="$"===f?o:/[%p]/.test(v)?u:"",x=_r[v],b=/[defgprs%]/.test(v);function M(t){var i,o,u,f=_,M=w;if("c"===v)M=x(t)+M,t="";else{var E=0>(t=+t)||0>1/t;if(t=isNaN(t)?c:x(Math.abs(t),m),y&&(t=function(t){t:for(var n,e=t.length,r=1,i=-1;e>r;++r)switch(t[r]){case".":i=n=r;break;case"0":0===i&&(i=r),n=r;break;default:if(!+t[r])break t;i>0&&(i=0)}return i>0?t.slice(0,i)+t.slice(n+1):t}(t)),E&&0===+t&&"+"!==h&&(E=!1),f=(E?"("===h?h:l:"-"===h||"("===h?"":h)+f,M=("s"===v?Cr[8+fr/3]:"")+M+(E&&"("===h?")":""),b)for(i=-1,o=t.length;++i<o;)if(48>(u=t.charCodeAt(i))||u>57){M=(46===u?a+t.slice(i+1):t.slice(i))+M,t=t.slice(0,i);break}}g&&!d&&(t=r(t,1/0));var C=f.length+t.length+M.length,k=p>C?Array(p-C+1).join(n):"";switch(g&&d&&(t=r(k+t,k.length?p-M.length:1/0),k=""),e){case"<":t=f+t+M+k;break;case"=":t=f+k+t+M;break;case"^":t=k.slice(0,C=k.length>>1)+f+t+M+k.slice(C);break;default:t=k+f+t+M}return s(t)}return m=void 0===m?6:/[gprs]/.test(v)?Math.max(1,Math.min(21,m)):Math.max(0,Math.min(20,m)),M.toString=function(){return t+""},M}return{format:h,formatPrefix:function(t,n){var e=h(((t=pr(t)).type="f",t)),r=3*Math.max(-8,Math.min(8,Math.floor(yr(n)/3))),i=Math.pow(10,-r),o=Cr[8+r/3];return function(t){return e(i*t)+o}}}}({thousands:",",grouping:[3],currency:["$",""]}),br=xr.format,Mr=xr.formatPrefix;const Rr=function(){for(var t=[,,,,,,,,,,],n=0;10>n;)t[n]="#"+"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf".slice(6*n,6*++n);return t}();function Fr(t){return"string"==typeof t?new kt([[document.querySelector(t)]],[document.documentElement]):new kt([[t]],Ct)}function Pr(t){return"object"==typeof t&&"length"in t?t:Array.from(t)}function Ir(t){return function(){return t}}function Or(t){this._context=t}function qr(t){return new Or(t)}Or.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,n){switch(t=+t,n=+n,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,n):this._context.moveTo(t,n);break;case 1:this._point=2;default:this._context.lineTo(t,n)}}};const Vr=Math.PI,Xr=2*Vr,Ur=1e-6,jr=Xr-Ur;function Br(t){this._+=t[0];for(let n=1,e=t.length;e>n;++n)this._+=arguments[n]+t[n]}class Hr{constructor(t){this._x0=this._y0=this._x1=this._y1=null,this._="",this._append=null==t?Br:function(t){let n=Math.floor(t);if(0>n)throw Error("invalid digits: "+t);if(n>15)return Br;const e=10**n;return function(t){this._+=t[0];for(let n=1,r=t.length;r>n;++n)this._+=Math.round(arguments[n]*e)/e+t[n]}}(t)}moveTo(t,n){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+n}`}closePath(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._append`Z`)}lineTo(t,n){this._append`L${this._x1=+t},${this._y1=+n}`}quadraticCurveTo(t,n,e,r){this._append`Q${+t},${+n},${this._x1=+e},${this._y1=+r}`}bezierCurveTo(t,n,e,r,i,o){this._append`C${+t},${+n},${+e},${+r},${this._x1=+i},${this._y1=+o}`}arcTo(t,n,e,r,i){if(t=+t,n=+n,e=+e,r=+r,0>(i=+i))throw Error("negative radius: "+i);let o=this._x1,a=this._y1,s=e-t,u=r-n,l=o-t,c=a-n,h=l*l+c*c;if(null===this._x1)this._append`M${this._x1=t},${this._y1=n}`;else if(h>Ur)if(Math.abs(c*s-u*l)>Ur&&i){let f=e-o,d=r-a,p=s*s+u*u,g=f*f+d*d,m=Math.sqrt(p),y=Math.sqrt(h),v=i*Math.tan((Vr-Math.acos((p+h-g)/(2*m*y)))/2),_=v/y,w=v/m;Math.abs(_-1)>Ur&&this._append`L${t+_*l},${n+_*c}`,this._append`A${i},${i},0,0,${+(c*f>l*d)},${this._x1=t+w*s},${this._y1=n+w*u}`}else this._append`L${this._x1=t},${this._y1=n}`}arc(t,n,e,r,i,o){if(t=+t,n=+n,o=!!o,0>(e=+e))throw Error("negative radius: "+e);let a=e*Math.cos(r),s=e*Math.sin(r),u=t+a,l=n+s,c=1^o,h=o?r-i:i-r;null===this._x1?this._append`M${u},${l}`:(Math.abs(this._x1-u)>Ur||Math.abs(this._y1-l)>Ur)&&this._append`L${u},${l}`,e&&(0>h&&(h=h%Xr+Xr),h>jr?this._append`A${e},${e},0,1,${c},${t-a},${n-s}A${e},${e},0,1,${c},${this._x1=u},${this._y1=l}`:h>Ur&&this._append`A${e},${e},0,${+(h>=Vr)},${c},${this._x1=t+e*Math.cos(i)},${this._y1=n+e*Math.sin(i)}`)}rect(t,n,e,r){this._append`M${this._x0=this._x1=+t},${this._y0=this._y1=+n}h${e=+e}v${+r}h${-e}Z`}toString(){return this._}}function zr(t){let n=3;return t.digits=function(e){if(!arguments.length)return n;if(null==e)n=null;else{const t=Math.floor(e);if(0>t)throw new RangeError("invalid digits: "+e);n=t}return t},()=>new Hr(n)}function Yr(t){return t[0]}function Gr(t){return t[1]}function Qr(t,n){var e=Ir(!0),r=null,i=qr,o=null,a=zr(s);function s(s){var u,l,c,h=(s=Pr(s)).length,f=!1;for(null==r&&(o=i(c=a())),u=0;h>=u;++u)!(h>u&&e(l=s[u],u,s))===f&&((f=!f)?o.lineStart():o.lineEnd()),f&&o.point(+t(l,u,s),+n(l,u,s));if(c)return o=null,c+""||null}return t="function"==typeof t?t:void 0===t?Yr:Ir(t),n="function"==typeof n?n:void 0===n?Gr:Ir(n),s.x=function(n){return arguments.length?(t="function"==typeof n?n:Ir(+n),s):t},s.y=function(t){return arguments.length?(n="function"==typeof t?t:Ir(+t),s):n},s.defined=function(t){return arguments.length?(e="function"==typeof t?t:Ir(!!t),s):e},s.curve=function(t){return arguments.length?(i=t,null!=r&&(o=i(r)),s):i},s.context=function(t){return arguments.length?(null==t?r=o=null:o=i(r=t),s):r},s}function Wr(t){return 0>t?-1:1}function Zr(t,n,e){var r=t._x1-t._x0,i=n-t._x1,o=(t._y1-t._y0)/(r||0>i&&-0),a=(e-t._y1)/(i||0>r&&-0),s=(o*i+a*r)/(r+i);return(Wr(o)+Wr(a))*Math.min(Math.abs(o),Math.abs(a),.5*Math.abs(s))||0}function Kr(t,n){var e=t._x1-t._x0;return e?(3*(t._y1-t._y0)/e-n)/2:n}function Jr(t,n,e){var r=t._x0,i=t._y0,o=t._x1,a=t._y1,s=(o-r)/3;t._context.bezierCurveTo(r+s,i+s*n,o-s,a-s*e,o,a)}function ti(t){this._context=t}function ni(t){this._context=t}function ei(t){return new ti(t)}function ri(t,n,e){this.k=t,this.x=n,this.y=e}ti.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN,this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:Jr(this,this._t0,Kr(this,this._t0))}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,n){var e=NaN;if(n=+n,(t=+t)!==this._x1||n!==this._y1){switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,n):this._context.moveTo(t,n);break;case 1:this._point=2;break;case 2:this._point=3,Jr(this,Kr(this,e=Zr(this,t,n)),e);break;default:Jr(this,this._t0,e=Zr(this,t,n))}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=n,this._t0=e}}},(function(t){this._context=new ni(t)}.prototype=Object.create(ti.prototype)).point=function(t,n){ti.prototype.point.call(this,n,t)},ni.prototype={moveTo:function(t,n){this._context.moveTo(n,t)},closePath:function(){this._context.closePath()},lineTo:function(t,n){this._context.lineTo(n,t)},bezierCurveTo:function(t,n,e,r,i,o){this._context.bezierCurveTo(n,t,r,e,o,i)}},ri.prototype={constructor:ri,scale:function(t){return 1===t?this:new ri(this.k*t,this.x,this.y)},translate:function(t,n){return 0===t&0===n?this:new ri(this.k,this.x+this.k*t,this.y+this.k*n)},apply:function(t){return[t[0]*this.k+this.x,t[1]*this.k+this.y]},applyX:function(t){return t*this.k+this.x},applyY:function(t){return t*this.k+this.y},invert:function(t){return[(t[0]-this.x)/this.k,(t[1]-this.y)/this.k]},invertX:function(t){return(t-this.x)/this.k},invertY:function(t){return(t-this.y)/this.k},rescaleX:function(t){return t.copy().domain(t.range().map(this.invertX,this).map(t.invert,t))},rescaleY:function(t){return t.copy().domain(t.range().map(this.invertY,this).map(t.invert,t))},toString:function(){return"translate("+this.x+","+this.y+") scale("+this.k+")"}},new ri(1,0,0),ri.prototype;const ii={width:800,height:420,margin:{top:20,right:20,bottom:40,left:50}};class oi{constructor(){}render(t,n){this.options={...ii,...n},this.setupContainer(),this.setupDimensions(),this.setupSVG(),this.clearPreviousChart(),this.renderChart(t)}setupContainer(){if(this.container=Fr("#"+this.options.containerId),this.container.empty())throw Error(`Container with id "${this.options.containerId}" not found`)}setupDimensions(){var t,n;const e=null!==(n=null===(t=this.container.node())||void 0===t?void 0:t.getBoundingClientRect().width)&&void 0!==n?n:this.options.width;this.width=e-this.options.margin.left-this.options.margin.right,this.height=this.options.height-this.options.margin.top-this.options.margin.bottom}setupSVG(){const t=this.width+this.options.margin.left+this.options.margin.right;this.svg=this.container.append("svg").attr("width",t).attr("height",this.options.height),this.g=this.svg.append("g").attr("transform",`translate(${this.options.margin.left},${this.options.margin.top})`)}clearPreviousChart(){this.container.selectAll("*").remove(),this.setupSVG()}createColorScale(){return Fe(Rr)}}class ai{constructor(){this.element=Fr("body").append("div").attr("class","chart-tooltip").style("position","absolute").style("background-color","white").style("border","1px solid #ddd").style("padding","8px").style("border-radius","4px").style("pointer-events","none").style("opacity",0).style("font-size","12px").style("box-shadow","0 2px 4px rgba(0,0,0,0.1)")}show(t,n,e){this.element.html(t).style("left",n+15+"px").style("top",e-28+"px").style("opacity",.9)}hide(){this.element.style("opacity",0)}destroy(){this.element.remove()}}class si{static createChart(t){const n=this.chartTypes.get(t);if(!n)throw Error(`Chart type "${t}" is not supported`);return new n}static registerChartType(t,n){this.chartTypes.set(t,n)}static getSupportedTypes(){return Array.from(this.chartTypes.keys())}}si.chartTypes=new Map([["line",class extends oi{renderChart(t){this.tooltip=new ai,this.colorScale=this.createColorScale(),this.setupScales(t),this.renderAxes(t),this.renderSeries(t),this.setupInteractions(t)}setupScales(t){var n,e;const r=t.series.flatMap(t=>t.values.map(t=>t.x)),i=Array.from(new Set(r)).sort();this.x=Oe().domain(i).range([0,this.width]);const o=null!==(n=a(t.series.flatMap(t=>t.values.map(t=>t.y))))&&void 0!==n?n:1,s=null!==(e=function(t){let n;for(const e of t)null!=e&&(n>e||void 0===n&&e>=e)&&(n=e);return n}(t.series.flatMap(t=>t.values.map(t=>t.y))))&&void 0!==e?e:0;this.y=t.useLogScale&&s>0?Lr().domain([Math.max(s,.1),o]).range([this.height,0]):kr().domain([0,o]).range([this.height,0])}renderAxes(t){const n=Math.max(2,Math.floor(this.width/100)),e=this.x.domain(),r=g(this.x).tickValues(e.filter((t,r)=>r%Math.ceil(e.length/n)===0)),i=m(this.y);this.g.append("g").attr("transform",`translate(0,${this.height})`).call(r).selectAll("text").style("text-anchor","middle"),this.g.append("g").call(i),t.yLabel&&this.svg.append("text").attr("transform",`translate(${this.options.margin.left}, ${this.options.margin.top-6})`).text(t.yLabel)}renderSeries(t){const n=Qr().x(t=>{var n;return null!==(n=this.x(t.x))&&void 0!==n?n:0}).y(t=>this.y(t.y)).curve(ei),e=function(t,n,e){var r=null,i=Ir(!0),o=null,a=qr,s=null,u=zr(l);function l(l){var c,h,f,d,p,g=(l=Pr(l)).length,m=!1,y=Array(g),v=Array(g);for(null==o&&(s=a(p=u())),c=0;g>=c;++c){if(!(g>c&&i(d=l[c],c,l))===m)if(m=!m)h=c,s.areaStart(),s.lineStart();else{for(s.lineEnd(),s.lineStart(),f=c-1;f>=h;--f)s.point(y[f],v[f]);s.lineEnd(),s.areaEnd()}m&&(y[c]=+t(d,c,l),v[c]=+n(d,c,l),s.point(r?+r(d,c,l):y[c],e?+e(d,c,l):v[c]))}if(p)return s=null,p+""||null}function c(){return Qr().defined(i).curve(a).context(o)}return t="function"==typeof t?t:void 0===t?Yr:Ir(+t),n="function"==typeof n?n:Ir(void 0===n?0:+n),e="function"==typeof e?e:void 0===e?Gr:Ir(+e),l.x=function(n){return arguments.length?(t="function"==typeof n?n:Ir(+n),r=null,l):t},l.x0=function(n){return arguments.length?(t="function"==typeof n?n:Ir(+n),l):t},l.x1=function(t){return arguments.length?(r=null==t?null:"function"==typeof t?t:Ir(+t),l):r},l.y=function(t){return arguments.length?(n="function"==typeof t?t:Ir(+t),e=null,l):n},l.y0=function(t){return arguments.length?(n="function"==typeof t?t:Ir(+t),l):n},l.y1=function(t){return arguments.length?(e=null==t?null:"function"==typeof t?t:Ir(+t),l):e},l.lineX0=l.lineY0=function(){return c().x(t).y(n)},l.lineY1=function(){return c().x(t).y(e)},l.lineX1=function(){return c().x(r).y(n)},l.defined=function(t){return arguments.length?(i="function"==typeof t?t:Ir(!!t),l):i},l.curve=function(t){return arguments.length?(a=t,null!=o&&(s=a(o)),l):a},l.context=function(t){return arguments.length?(null==t?o=s=null:s=a(o=t),l):o},l}().x(t=>{var n;return null!==(n=this.x(t.x))&&void 0!==n?n:0}).y0(this.height).y1(t=>this.y(t.y)).curve(ei);t.series.forEach((t,r)=>{var i;const o=null!==(i=t.color)&&void 0!==i?i:this.colorScale(r+"");this.g.append("path").datum(t.values).attr("fill",o).attr("fill-opacity",.1).attr("d",e),this.g.append("path").datum(t.values).attr("fill","none").attr("stroke",o).attr("stroke-width",2).attr("d",n)})}setupInteractions(t){const n=this.g.append("g"),e=n.append("line").attr("stroke","#999").attr("stroke-width",1).attr("stroke-dasharray","3,3").style("display","none").attr("y1",0).attr("y2",this.height),r=n.append("g");t.series.forEach((t,n)=>{var e;r.append("circle").attr("r",4).attr("fill",null!==(e=t.color)&&void 0!==e?e:this.colorScale(n+"")).style("display","none")}),this.g.append("rect").attr("width",this.width).attr("height",this.height).attr("fill","none").attr("pointer-events","all").on("mousemove",n=>{const[i]=function(t,n){if(t=function(t){let n;for(;n=t.sourceEvent;)t=n;return t}(t),void 0===n&&(n=t.currentTarget),n){var e=n.ownerSVGElement||n;if(e.createSVGPoint){var r=e.createSVGPoint();return r.x=t.clientX,r.y=t.clientY,[(r=r.matrixTransform(n.getScreenCTM().inverse())).x,r.y]}if(n.getBoundingClientRect){var i=n.getBoundingClientRect();return[t.clientX-i.left-n.clientLeft,t.clientY-i.top-n.clientTop]}}return[t.pageX,t.pageY]}(n);e.attr("x1",i).attr("x2",i).style("display",null);const o=this.x.domain().reduce((t,n)=>{var e,r;const o=null!==(e=this.x(t))&&void 0!==e?e:0,a=null!==(r=this.x(n))&&void 0!==r?r:0;return Math.abs(o-i)>Math.abs(a-i)?n:t}),a=t.series.map((t,n)=>{var e;const i=t.values.find(t=>t.x===o);return i?(r.select(`circle:nth-child(${n+1})`).attr("transform",`translate(${this.x(i.x)},${this.y(i.y)})`).style("display",null),`<div style="color:${null!==(e=t.color)&&void 0!==e?e:this.colorScale(n+"")}">${t.name}: ${i.y}</div>`):""}).join("");this.tooltip.show(`<div><strong>${o}</strong>${a}</div>`,n.pageX,n.pageY)}).on("mouseout",()=>{e.style("display","none"),r.selectAll("circle").style("display","none"),this.tooltip.hide()})}}],["bar",class extends oi{renderChart(t){this.tooltip=new ai,this.colorScale=this.createColorScale(),this.setupScales(t),this.renderAxes(t),this.renderBars(t)}setupScales(t){var n;const e=t.series.flatMap(t=>t.values.map(t=>t.x)),r=Array.from(new Set(e)).sort();this.x=Pe().domain(r).range([0,this.width]).padding(.1);const i=null!==(n=a(t.series.flatMap(t=>t.values.map(t=>t.y))))&&void 0!==n?n:1;this.y=kr().domain([0,i]).range([this.height,0])}renderAxes(t){const n=g(this.x),e=m(this.y);this.g.append("g").attr("transform",`translate(0,${this.height})`).call(n).selectAll("text").style("text-anchor","middle"),this.g.append("g").call(e),t.yLabel&&this.svg.append("text").attr("transform",`translate(${this.options.margin.left}, ${this.options.margin.top-6})`).text(t.yLabel)}renderBars(t){var n;const e=t.series[0];if(!e)return;const r=null!==(n=e.color)&&void 0!==n?n:this.colorScale("0");this.g.selectAll(".bar").data(e.values).enter().append("rect").attr("class","bar").attr("x",t=>{var n;return null!==(n=this.x(t.x))&&void 0!==n?n:0}).attr("width",this.x.bandwidth()).attr("y",t=>this.y(t.y)).attr("height",t=>this.height-this.y(t.y)).attr("fill",r).on("mouseover",(t,n)=>{this.tooltip.show(`<div><strong>${n.x}</strong><br/>${e.name}: ${n.y}</div>`,t.pageX,t.pageY)}).on("mouseout",()=>{this.tooltip.hide()})}}]]);class ui{constructor(t={}){this.currentChartType="line",this.dataService=new r(t.dataServiceUrl),this.defaultChartOptions=t.defaultChartOptions||{containerId:"chart"},t.useControls&&t.controlsContainerId&&this.setupControls(t.controlsContainerId,t.controlsConfig)}setupControls(t,n){const e={...n,onRefresh:()=>this.renderChart(this.currentChartType),onFilterChange:t=>{this.customFilters=t,(null==n?void 0:n.onFilterChange)&&n.onFilterChange(t)}};this.controls=new o(t,e)}async renderChart(t="line",n){this.currentChartType=t;try{const e=this.getFilters(),r=await this.dataService.fetchChartData(e);void 0!==e.useLogScale&&(r.useLogScale=e.useLogScale);const i={...this.defaultChartOptions,...n};si.createChart(t).render(r,i)}catch(e){throw e}}async renderLineChart(t){return this.renderChart("line",t)}async renderBarChart(t){return this.renderChart("bar",t)}getFilters(){return this.controls?this.controls.getCurrentFilters():this.customFilters?{...i.readFiltersFromDOM(),...this.customFilters}:i.readFiltersFromDOM()}setFilters(t){this.controls?this.controls.setFilters(t):this.customFilters={...this.customFilters,...t}}getControls(){return this.controls}setDataService(t){this.dataService=t}destroy(){this.controls&&this.controls.destroy()}}let li=null;function ci(t={}){return li&&li.destroy(),li=new ui(t),li}"undefined"!=typeof window&&(window.__sqm_wp_pageviews_dashboard_init=async function(){return async function(){try{li||ci({useControls:!1,defaultChartOptions:{containerId:"chart"}}),await li.renderLineChart()}catch(t){}}()},window.__sqm_wp_pageviews_dashboard_create=ci,window.__sqm_wp_pageviews_dashboard_init_with_controls=async function(n="dashboard-controls",e="chart",r){const i={useControls:!0,controlsContainerId:n,defaultChartOptions:{containerId:e},controlsConfig:{defaultValues:r},nonce:r.nonce};t.REQUEST_HEADERS["X-WP-Nonce"]=r.nonce;try{const t=ci(i);await t.renderLineChart()}catch(o){}},window.__sqm_wp_pageviews_dashboard_get=function(){return li},window.__sqm_wp_pageviews_dashboard_set_filters=function(t){li&&li.setFilters(t)},window.__sqm_wp_pageviews_dashboard_configure_api=function(t){t.baseUrl&&e.setBaseUrl(t.baseUrl),t.endpoints&&e.setEndpoints(t.endpoints)})})();
//# sourceMappingURL=dashboard-1.1.8.bundle.min.js.map