(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["SQMViewsDashboard"] = factory();
	else
		root["SQMViewsDashboard"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/charts/bar-chart.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   BarChart: () => ( BarChart)
 });
 var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/d3/src/index.js");
 var _base_chart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/charts/base-chart.ts");
 var _ui_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/ui/tooltip.ts");

class BarChart extends _base_chart__WEBPACK_IMPORTED_MODULE_1__.BaseChart {
    renderChart(data) {
        this.tooltip = new _ui_tooltip__WEBPACK_IMPORTED_MODULE_2__.Tooltip();
        this.colorScale = this.createColorScale();
        this.setupScales(data);
        this.renderAxes(data);
        this.renderBars(data);
    }
    setupScales(data) {
        var _a;
        // X Scale
        const allX = data.series.flatMap(s => s.values.map(v => v.x));
        const xDomain = Array.from(new Set(allX)).sort();
        this.x = d3__WEBPACK_IMPORTED_MODULE_0__.scaleBand().domain(xDomain).range([0, this.width]).padding(0.1);
        // Y Scale
        const yMax = (_a = d3__WEBPACK_IMPORTED_MODULE_0__.max(data.series.flatMap(s => s.values.map(v => v.y)))) !== null && _a !== void 0 ? _a : 1;
        this.y = d3__WEBPACK_IMPORTED_MODULE_0__.scaleLinear().domain([0, yMax]).range([this.height, 0]);
    }
    renderAxes(data) {
        const xAxis = d3__WEBPACK_IMPORTED_MODULE_0__.axisBottom(this.x);
        const yAxis = d3__WEBPACK_IMPORTED_MODULE_0__.axisLeft(this.y);
        this.g.append("g")
            .attr("transform", `translate(0,${this.height})`)
            .call(xAxis)
            .selectAll("text")
            .style("text-anchor", "middle");
        this.g.append("g").call(yAxis);
        if (data.yLabel) {
            this.svg.append("text")
                .attr("transform", `translate(${this.options.margin.left}, ${this.options.margin.top - 6})`)
                .text(data.yLabel);
        }
    }
    renderBars(data) {
        var _a;
        // For simplicity, this example shows only the first series as bars
        // In a real implementation, you might want to group bars or use different approaches
        const firstSeries = data.series[0];
        if (!firstSeries)
            return;
        const color = (_a = firstSeries.color) !== null && _a !== void 0 ? _a : this.colorScale("0");
        this.g.selectAll(".bar")
            .data(firstSeries.values)
            .enter()
            .append("rect")
            .attr("class", "bar")
            .attr("x", d => { var _a; return (_a = this.x(d.x)) !== null && _a !== void 0 ? _a : 0; })
            .attr("width", this.x.bandwidth())
            .attr("y", d => this.y(d.y))
            .attr("height", d => this.height - this.y(d.y))
            .attr("fill", color)
            .on("mouseover", (event, d) => {
            this.tooltip.show(`<div><strong>${d.x}</strong><br/>${firstSeries.name}: ${d.y}</div>`, event.pageX, event.pageY);
        })
            .on("mouseout", () => {
            this.tooltip.hide();
        });
    }
}

/***/ }),

/***/ "./src/charts/base-chart.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   BaseChart: () => ( BaseChart)
 });
 var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/d3/src/index.js");
 var _config_chart_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/config/chart-config.ts");

class BaseChart {
    constructor() {
        // Will be initialized in render method
    }
    render(data, options) {
        this.options = { ..._config_chart_config__WEBPACK_IMPORTED_MODULE_1__.CHART_DEFAULTS, ...options };
        this.setupContainer();
        this.setupDimensions();
        this.setupSVG();
        this.clearPreviousChart();
        this.renderChart(data);
    }
    setupContainer() {
        this.container = d3__WEBPACK_IMPORTED_MODULE_0__.select(`#${this.options.containerId}`);
        if (this.container.empty()) {
            throw new Error(`Container with id "${this.options.containerId}" not found`);
        }
    }
    setupDimensions() {
        var _a, _b;
        const containerWidth = (_b = (_a = this.container.node()) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect().width) !== null && _b !== void 0 ? _b : this.options.width;
        this.width = containerWidth - this.options.margin.left - this.options.margin.right;
        this.height = this.options.height - this.options.margin.top - this.options.margin.bottom;
    }
    setupSVG() {
        const containerWidth = this.width + this.options.margin.left + this.options.margin.right;
        this.svg = this.container
            .append("svg")
            .attr("width", containerWidth)
            .attr("height", this.options.height);
        this.g = this.svg
            .append("g")
            .attr("transform", `translate(${this.options.margin.left},${this.options.margin.top})`);
    }
    clearPreviousChart() {
        this.container.selectAll("*").remove();
        this.setupSVG();
    }
    createColorScale() {
        return d3__WEBPACK_IMPORTED_MODULE_0__.scaleOrdinal(d3__WEBPACK_IMPORTED_MODULE_0__.schemeCategory10);
    }
}

/***/ }),

/***/ "./src/charts/chart-factory.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   ChartFactory: () => ( ChartFactory)
 });
 var _line_chart__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/charts/line-chart.ts");
 var _bar_chart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/charts/bar-chart.ts");

class ChartFactory {
    static createChart(type) {
        const ChartClass = this.chartTypes.get(type);
        if (!ChartClass) {
            throw new Error(`Chart type "${type}" is not supported`);
        }
        return new ChartClass();
    }
    static registerChartType(type, chartClass) {
        this.chartTypes.set(type, chartClass);
    }
    static getSupportedTypes() {
        return Array.from(this.chartTypes.keys());
    }
}
ChartFactory.chartTypes = new Map([
    ["line", _line_chart__WEBPACK_IMPORTED_MODULE_0__.LineChart],
    ["bar", _bar_chart__WEBPACK_IMPORTED_MODULE_1__.BarChart],
]);

/***/ }),

/***/ "./src/charts/line-chart.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   LineChart: () => ( LineChart)
 });
 var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/d3/src/index.js");
 var _base_chart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/charts/base-chart.ts");
 var _ui_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/ui/tooltip.ts");
 var _config_chart_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/config/chart-config.ts");

class LineChart extends _base_chart__WEBPACK_IMPORTED_MODULE_1__.BaseChart {
    renderChart(data) {
        this.tooltip = new _ui_tooltip__WEBPACK_IMPORTED_MODULE_2__.Tooltip();
        this.colorScale = this.createColorScale();
        this.setupScales(data);
        this.renderAxes(data);
        this.renderSeries(data);
        this.setupInteractions(data);
    }
    setupScales(data) {
        var _a, _b;
        // X Scale
        const allX = data.series.flatMap(s => s.values.map(v => v.x));
        const xDomain = Array.from(new Set(allX)).sort();
        this.x = d3__WEBPACK_IMPORTED_MODULE_0__.scalePoint().domain(xDomain).range([0, this.width]);
        // Y Scale
        const yMax = (_a = d3__WEBPACK_IMPORTED_MODULE_0__.max(data.series.flatMap(s => s.values.map(v => v.y)))) !== null && _a !== void 0 ? _a : 1;
        const yMin = (_b = d3__WEBPACK_IMPORTED_MODULE_0__.min(data.series.flatMap(s => s.values.map(v => v.y)))) !== null && _b !== void 0 ? _b : 0;
        this.y = data.useLogScale && yMin > 0
            ? d3__WEBPACK_IMPORTED_MODULE_0__.scaleLog().domain([Math.max(yMin, 0.1), yMax]).range([this.height, 0])
            : d3__WEBPACK_IMPORTED_MODULE_0__.scaleLinear().domain([0, yMax]).range([this.height, 0]);
    }
    renderAxes(data) {
        const tickCount = Math.max(2, Math.floor(this.width / 100));
        const xDomain = this.x.domain();
        const xAxis = d3__WEBPACK_IMPORTED_MODULE_0__.axisBottom(this.x)
            .tickValues(xDomain.filter((_, i) => i % Math.ceil(xDomain.length / tickCount) === 0));
        const yAxis = d3__WEBPACK_IMPORTED_MODULE_0__.axisLeft(this.y);
        this.g.append("g")
            .attr("transform", `translate(0,${this.height})`)
            .call(xAxis)
            .selectAll("text")
            .style("text-anchor", "middle");
        this.g.append("g").call(yAxis);
        if (data.yLabel) {
            this.svg.append("text")
                .attr("transform", `translate(${this.options.margin.left}, ${this.options.margin.top - 6})`)
                .text(data.yLabel);
        }
    }
    renderSeries(data) {
        const line = d3__WEBPACK_IMPORTED_MODULE_0__.line()
            .x(d => { var _a; return (_a = this.x(d.x)) !== null && _a !== void 0 ? _a : 0; })
            .y(d => this.y(d.y))
            .curve(d3__WEBPACK_IMPORTED_MODULE_0__.curveMonotoneX);
        const area = d3__WEBPACK_IMPORTED_MODULE_0__.area()
            .x(d => { var _a; return (_a = this.x(d.x)) !== null && _a !== void 0 ? _a : 0; })
            .y0(this.height)
            .y1(d => this.y(d.y))
            .curve(d3__WEBPACK_IMPORTED_MODULE_0__.curveMonotoneX);
        data.series.forEach((series, idx) => {
            var _a;
            const color = (_a = series.color) !== null && _a !== void 0 ? _a : this.colorScale(String(idx));
            // Area
            this.g.append("path")
                .datum(series.values)
                .attr("fill", color)
                .attr("fill-opacity", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.area.fillOpacity)
                .attr("d", area);
            // Line
            this.g.append("path")
                .datum(series.values)
                .attr("fill", "none")
                .attr("stroke", color)
                .attr("stroke-width", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.line.strokeWidth)
                .attr("d", line);
        });
    }
    setupInteractions(data) {
        const overlay = this.g.append("g");
        const verticalLine = overlay.append("line")
            .attr("stroke", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.guideLine.stroke)
            .attr("stroke-width", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.guideLine.strokeWidth)
            .attr("stroke-dasharray", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.guideLine.strokeDasharray)
            .style("display", "none")
            .attr("y1", 0)
            .attr("y2", this.height);
        const tooltipPoints = overlay.append("g");
        data.series.forEach((series, idx) => {
            var _a;
            tooltipPoints.append("circle")
                .attr("r", _config_chart_config__WEBPACK_IMPORTED_MODULE_3__.CHART_STYLES.point.radius)
                .attr("fill", (_a = series.color) !== null && _a !== void 0 ? _a : this.colorScale(String(idx)))
                .style("display", "none");
        });
        this.g.append("rect")
            .attr("width", this.width)
            .attr("height", this.height)
            .attr("fill", "none")
            .attr("pointer-events", "all")
            .on("mousemove", (event) => {
            const [mx] = d3__WEBPACK_IMPORTED_MODULE_0__.pointer(event);
            verticalLine.attr("x1", mx).attr("x2", mx).style("display", null);
            const closestX = this.x.domain().reduce((prev, curr) => {
                var _a, _b;
                const prevPos = (_a = this.x(prev)) !== null && _a !== void 0 ? _a : 0;
                const currPos = (_b = this.x(curr)) !== null && _b !== void 0 ? _b : 0;
                return Math.abs(currPos - mx) < Math.abs(prevPos - mx) ? curr : prev;
            });
            const tooltipContent = data.series.map((series, idx) => {
                var _a;
                const closestPoint = series.values.find(v => v.x === closestX);
                if (!closestPoint)
                    return "";
                tooltipPoints.select(`circle:nth-child(${idx + 1})`)
                    .attr("transform", `translate(${this.x(closestPoint.x)},${this.y(closestPoint.y)})`)
                    .style("display", null);
                const color = (_a = series.color) !== null && _a !== void 0 ? _a : this.colorScale(String(idx));
                return `<div style="color:${color}">${series.name}: ${closestPoint.y}</div>`;
            }).join("");
            this.tooltip.show(`<div><strong>${closestX}</strong>${tooltipContent}</div>`, event.pageX, event.pageY);
        })
            .on("mouseout", () => {
            verticalLine.style("display", "none");
            tooltipPoints.selectAll("circle").style("display", "none");
            this.tooltip.hide();
        });
    }
}

/***/ }),

/***/ "./src/config/api-config.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   API_CONFIG: () => ( API_CONFIG),
   ApiConfig: () => ( ApiConfig),
   apiConfig: () => ( apiConfig),
   configureApi: () => ( configureApi)
 });
const API_CONFIG = {
    // Default WordPress REST API endpoint for chart data
    DEFAULT_CHART_ENDPOINT: "/wp-json/sqm-views/v1/charts",
    // API configuration options
    REQUEST_TIMEOUT: 30000, // 30 seconds
    REQUEST_HEADERS: {
        "Content-Type": "application/json",
    },
    // Retry configuration
    MAX_RETRIES: 3,
    RETRY_DELAY: 1000, // 1 second
};

class ApiConfig {
    constructor() {
        this.endpoints = {};
        this.baseUrl = "";
    }
    static getInstance() {
        if (!ApiConfig.instance) {
            ApiConfig.instance = new ApiConfig();
        }
        return ApiConfig.instance;
    }
    /**
     * Set the base URL for all API endpoints
     */
    setBaseUrl(baseUrl) {
        this.baseUrl = baseUrl;
    }
    /**
     * Get the base URL
     */
    getBaseUrl() {
        return this.baseUrl;
    }
    /**
     * Set custom endpoint URLs
     */
    setEndpoints(endpoints) {
        this.endpoints = { ...this.endpoints, ...endpoints };
    }
    /**
     * Get the chart endpoint URL
     */
    getChartEndpoint() {
        // Priority: custom endpoint > base URL + default path > default full path
        if (this.endpoints.charts) {
            return this.endpoints.charts;
        }
        if (this.baseUrl) {
            return `${this.baseUrl.replace(/\/$/, '')}/charts`;
        }
        return API_CONFIG.DEFAULT_CHART_ENDPOINT;
    }
    /**
     * Get request configuration
     */
    getRequestConfig() {
        return {
            timeout: API_CONFIG.REQUEST_TIMEOUT,
            headers: { ...API_CONFIG.REQUEST_HEADERS },
            maxRetries: API_CONFIG.MAX_RETRIES,
            retryDelay: API_CONFIG.RETRY_DELAY,
        };
    }
    /**
     * Reset to default configuration
     */
    reset() {
        this.endpoints = {};
        this.baseUrl = "";
    }
}

const apiConfig = ApiConfig.getInstance();
function configureApi(config) {
    if (config.baseUrl) {
        apiConfig.setBaseUrl(config.baseUrl);
    }
    if (config.endpoints) {
        apiConfig.setEndpoints(config.endpoints);
    }
}

/***/ }),

/***/ "./src/config/chart-config.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   CHART_DEFAULTS: () => ( CHART_DEFAULTS),
   CHART_STYLES: () => ( CHART_STYLES),
   COLOR_SCHEMES: () => ( COLOR_SCHEMES)
 });
const CHART_DEFAULTS = {
    width: 800,
    height: 420,
    margin: {
        top: 20,
        right: 20,
        bottom: 40,
        left: 50,
    },
};
const CHART_STYLES = {
    tooltip: {
        backgroundColor: "white",
        border: "1px solid #ddd",
        padding: "8px",
        borderRadius: "4px",
        fontSize: "12px",
        boxShadow: "0 2px 4px rgba(0,0,0,0.1)",
    },
    button: {
        padding: "5px 10px",
        border: "1px solid #ccc",
        borderRadius: "4px",
        background: "#fff",
        cursor: "pointer",
    },
    guideLine: {
        stroke: "#999",
        strokeWidth: 1,
        strokeDasharray: "3,3",
    },
    area: {
        fillOpacity: 0.1,
    },
    line: {
        strokeWidth: 2,
    },
    point: {
        radius: 4,
    },
};
const COLOR_SCHEMES = {
    default: "schemeCategory10",
    pastel: ["#FFB3BA", "#BAFFC9", "#BAE1FF", "#FFFFBA", "#FFD700"],
    monochrome: ["#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78", "#2ca02c"],
};

/***/ }),

/***/ "./src/dashboard.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   Dashboard: () => ( Dashboard)
 });
 var _services_data_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/services/data-service.ts");
 var _ui_form_reader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/ui/form-reader.ts");
 var _ui_dashboard_controls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./src/ui/dashboard-controls.ts");
 var _charts_chart_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./src/charts/chart-factory.ts");

class Dashboard {
    constructor(config = {}) {
        this.currentChartType = "line";
        this.dataService = new _services_data_service__WEBPACK_IMPORTED_MODULE_0__.DataService(config.dataServiceUrl);
        this.defaultChartOptions = config.defaultChartOptions || { containerId: "chart" };
        if (config.useControls && config.controlsContainerId) {
            this.setupControls(config.controlsContainerId, config.controlsConfig);
        }
    }
    setupControls(containerId, controlsConfig) {
        const config = {
            ...controlsConfig,
            onRefresh: () => this.renderChart(this.currentChartType),
            onFilterChange: (filters) => {
                this.customFilters = filters;
                if (controlsConfig === null || controlsConfig === void 0 ? void 0 : controlsConfig.onFilterChange) {
                    controlsConfig.onFilterChange(filters);
                }
            }
        };
        this.controls = new _ui_dashboard_controls__WEBPACK_IMPORTED_MODULE_2__.DashboardControls(containerId, config);
    }
    async renderChart(chartType = "line", options) {
        this.currentChartType = chartType;
        try {
            const filters = this.getFilters();
            console.log("Filters:", filters);
            const data = await this.dataService.fetchChartData(filters);
            // Apply log scale from filter to chart data
            if (filters.useLogScale !== undefined) {
                data.useLogScale = filters.useLogScale;
            }
            const chartOptions = { ...this.defaultChartOptions, ...options };
            const chart = _charts_chart_factory__WEBPACK_IMPORTED_MODULE_3__.ChartFactory.createChart(chartType);
            chart.render(data, chartOptions);
        }
        catch (error) {
            console.error("Failed to render chart:", error);
            throw error;
        }
    }
    async renderLineChart(options) {
        return this.renderChart("line", options);
    }
    async renderBarChart(options) {
        return this.renderChart("bar", options);
    }
    getFilters() {
        // Priority: 1) Controls, 2) Custom filters, 3) DOM form reader (fallback)
        if (this.controls) {
            return this.controls.getCurrentFilters();
        }
        if (this.customFilters) {
            return {
                ..._ui_form_reader__WEBPACK_IMPORTED_MODULE_1__.FormReader.readFiltersFromDOM(),
                ...this.customFilters
            };
        }
        return _ui_form_reader__WEBPACK_IMPORTED_MODULE_1__.FormReader.readFiltersFromDOM();
    }
    setFilters(filters) {
        if (this.controls) {
            this.controls.setFilters(filters);
        }
        else {
            this.customFilters = { ...this.customFilters, ...filters };
        }
    }
    getControls() {
        return this.controls;
    }
    setDataService(dataService) {
        this.dataService = dataService;
    }
    destroy() {
        if (this.controls) {
            this.controls.destroy();
        }
    }
}

/***/ }),

/***/ "./src/index.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   createDashboard: () => ( createDashboard),
   getDashboard: () => ( getDashboard),
   initCharts: () => ( initCharts),
   initChartsWithControls: () => ( initChartsWithControls),
   legacyInitCharts: () => ( legacyInitCharts),
   setDashboardFilters: () => ( setDashboardFilters)
 });
 var _dashboard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/dashboard.ts");
 var _config_api_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./src/config/api-config.ts");

let dashboardInstance = null;
function createDashboard(config = {}) {
    if (dashboardInstance) {
        dashboardInstance.destroy();
    }
    dashboardInstance = new _dashboard__WEBPACK_IMPORTED_MODULE_0__.Dashboard(config);
    return dashboardInstance;
}
async function initCharts(config) {
    try {
        if (!dashboardInstance) {
            createDashboard(config);
        }
        await dashboardInstance.renderLineChart();
    }
    catch (error) {
        console.error("Failed to initialize charts:", error);
    }
}
async function initChartsWithControls(controlsContainerId = "dashboard-controls", chartContainerId = "chart", defaultFilters) {
    const config = {
        useControls: true,
        controlsContainerId,
        defaultChartOptions: { containerId: chartContainerId },
        controlsConfig: {
            defaultValues: defaultFilters
        },
        nonce: defaultFilters['nonce']
    };
    _config_api_config__WEBPACK_IMPORTED_MODULE_1__.API_CONFIG.REQUEST_HEADERS['X-WP-Nonce'] = defaultFilters['nonce'];
    try {
        const dashboard = createDashboard(config);
        await dashboard.renderLineChart();
    }
    catch (error) {
        console.error("Failed to initialize charts with controls:", error);
    }
}
function getDashboard() {
    return dashboardInstance;
}
function setDashboardFilters(filters) {
    if (dashboardInstance) {
        dashboardInstance.setFilters(filters);
    }
}

async function legacyInitCharts() {
    const config = {
        useControls: false,
        defaultChartOptions: { containerId: "chart" }
    };
    return initCharts(config);
}

if (typeof window !== "undefined") {
    // Legacy support
    window["__sqm_wp_pageviews_dashboard_init"] = legacyInitCharts;
    // New API
    window["__sqm_wp_pageviews_dashboard_create"] = createDashboard;
    window["__sqm_wp_pageviews_dashboard_init_with_controls"] = initChartsWithControls;
    window["__sqm_wp_pageviews_dashboard_get"] = getDashboard;
    window["__sqm_wp_pageviews_dashboard_set_filters"] = setDashboardFilters;
    // API Configuration
    window["__sqm_wp_pageviews_dashboard_configure_api"] = _config_api_config__WEBPACK_IMPORTED_MODULE_1__.configureApi;
}

/***/ }),

/***/ "./src/services/data-service.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   DataService: () => ( DataService)
 });
 var _config_api_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./src/config/api-config.ts");

class DataService {
    constructor(customEndpoint) {
        this.customEndpoint = customEndpoint;
    }
    async fetchChartData(filters) {
        const params = this.buildParams(filters);
        const endpoint = this.getEndpoint();
        const config = _config_api_config__WEBPACK_IMPORTED_MODULE_0__.apiConfig.getRequestConfig();
        const controller = new AbortController();
        const timeoutId = setTimeout(() => controller.abort(), config.timeout);
        try {
            const response = await this.fetchWithRetry(`${endpoint}?${params.toString()}`, {
                method: "GET",
                headers: config.headers,
                signal: controller.signal,
            }, config.maxRetries, config.retryDelay);
            clearTimeout(timeoutId);
            if (!response.ok) {
                throw new Error(`Failed to fetch chart data: ${response.statusText}`);
            }
            return response.json();
        }
        catch (error) {
            clearTimeout(timeoutId);
            if (error instanceof Error && error.name === 'AbortError') {
                throw new Error(`Request timeout after ${config.timeout}ms`);
            }
            throw error;
        }
    }
    getEndpoint() {
        // Priority: custom endpoint passed to constructor > global config
        return this.customEndpoint || _config_api_config__WEBPACK_IMPORTED_MODULE_0__.apiConfig.getChartEndpoint();
    }
    async fetchWithRetry(url, options, maxRetries, retryDelay) {
        let lastError;
        for (let attempt = 0; attempt <= maxRetries; attempt++) {
            try {
                const response = await fetch(url, options);
                // Don't retry on client errors (4xx), only on server errors (5xx) or network issues
                if (response.ok || (response.status >= 400 && response.status < 500)) {
                    return response;
                }
                throw new Error(`HTTP ${response.status}: ${response.statusText}`);
            }
            catch (error) {
                lastError = error instanceof Error ? error : new Error(String(error));
                // Don't retry on the last attempt
                if (attempt < maxRetries) {
                    console.warn(`Request attempt ${attempt + 1} failed, retrying in ${retryDelay}ms...`, lastError.message);
                    await new Promise(resolve => setTimeout(resolve, retryDelay));
                }
            }
        }
        throw lastError;
    }
    buildParams(filters) {
        const params = new URLSearchParams();
        if (filters.startDate)
            params.append("startDate", filters.startDate);
        if (filters.endDate)
            params.append("endDate", filters.endDate);
        if (filters.eid)
            params.append("eid", filters.eid);
        if (filters.tid)
            params.append("tid", filters.tid);
        if (filters.granularity)
            params.append("granularity", filters.granularity);
        if (filters.metric)
            params.append("metric", filters.metric);
        if (filters.limit)
            params.append("limit", filters.limit.toString());
        return params;
    }
}

/***/ }),

/***/ "./src/ui/dashboard-controls.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   DashboardControls: () => ( DashboardControls)
 });
class DashboardControls {
    constructor(containerId, config = {}) {
        this.controls = new Map();
        const container = document.getElementById(containerId);
        if (!container) {
            throw new Error(`Container with id "${containerId}" not found`);
        }
        this.container = container;
        this.config = {
            showStartDate: true,
            showEndDate: true,
            showGranularity: true,
            showMetric: true,
            showLimit: true,
            showLogScale: true,
            showRefreshButton: true,
            ...config
        };
        this.render();
        this.setupEventListeners();
    }
    render() {
        this.container.innerHTML = '';
        this.container.className = 'dashboard-controls';
        // Add CSS styles
        this.addStyles();
        const form = document.createElement('div');
        form.className = 'controls-form';
        if (this.config.showStartDate) {
            form.appendChild(this.createDateControl('start', 'Start Date', this.getDefaultStartDate()));
        }
        if (this.config.showEndDate) {
            form.appendChild(this.createDateControl('end', 'End Date', this.getDefaultEndDate()));
        }
        if (this.config.showGranularity) {
            form.appendChild(this.createGranularityControl());
        }
        if (this.config.showLimit) {
            form.appendChild(this.createLimitControl());
        }
        if (this.config.showMetric) {
            form.appendChild(this.createMetricControl());
        }
        if (this.config.showLogScale) {
            form.appendChild(this.createLogScaleControl());
        }
        if (this.config.showRefreshButton) {
            form.appendChild(this.createRefreshButton());
        }
        this.container.appendChild(form);
    }
    createDateControl(type, label, defaultValue) {
        var _a;
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group';
        const labelEl = document.createElement('label');
        labelEl.textContent = label + ':';
        const input = document.createElement('input');
        input.type = 'date';
        input.id = `sv-${type}`;
        input.value = ((_a = this.config.defaultValues) === null || _a === void 0 ? void 0 : _a[type === 'start' ? 'startDate' : 'endDate']) || defaultValue;
        this.controls.set(`${type}Date`, input);
        labelEl.appendChild(input);
        wrapper.appendChild(labelEl);
        return wrapper;
    }
    createGranularityControl() {
        var _a, _b;
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group';
        const label = document.createElement('label');
        label.textContent = 'Granularity:';
        const select = document.createElement('select');
        select.id = 'sv-granularity';
        const dailyOption = document.createElement('option');
        dailyOption.value = 'daily';
        dailyOption.textContent = 'Daily';
        dailyOption.selected = ((_a = this.config.defaultValues) === null || _a === void 0 ? void 0 : _a.granularity) !== 'by_content';
        const contentOption = document.createElement('option');
        contentOption.value = 'by_content';
        contentOption.textContent = 'By Content';
        contentOption.selected = ((_b = this.config.defaultValues) === null || _b === void 0 ? void 0 : _b.granularity) === 'by_content';
        select.appendChild(dailyOption);
        select.appendChild(contentOption);
        this.controls.set('granularity', select);
        label.appendChild(select);
        wrapper.appendChild(label);
        return wrapper;
    }
    createLimitControl() {
        var _a, _b;
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group limit-control';
        wrapper.id = 'limit-wrapper';
        const label = document.createElement('label');
        label.textContent = 'Limit:';
        const input = document.createElement('input');
        input.type = 'number';
        input.id = 'sv-limit';
        input.value = String(((_a = this.config.defaultValues) === null || _a === void 0 ? void 0 : _a.limit) || 10);
        input.min = '1';
        this.controls.set('limit', input);
        label.appendChild(input);
        wrapper.appendChild(label);
        // Hide by default if granularity is daily
        if (((_b = this.config.defaultValues) === null || _b === void 0 ? void 0 : _b.granularity) !== 'by_content') {
            wrapper.style.display = 'none';
        }
        return wrapper;
    }
    createMetricControl() {
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group';
        const label = document.createElement('label');
        label.textContent = 'Metric:';
        const select = document.createElement('select');
        select.id = 'sv-metric';
        const metrics = [
            { value: 'count', label: 'Page Views' },
            { value: 'on_page', label: 'Time on Page' },
            { value: 'active', label: 'Active Views' },
            { value: 'high_freq', label: 'High Frequency' },
            { value: 'low_freq', label: 'Low Frequency' }
        ];
        metrics.forEach(metric => {
            var _a, _b;
            const option = document.createElement('option');
            option.value = metric.value;
            option.textContent = metric.label;
            option.selected = ((_a = this.config.defaultValues) === null || _a === void 0 ? void 0 : _a.metric) === metric.value ||
                (!((_b = this.config.defaultValues) === null || _b === void 0 ? void 0 : _b.metric) && metric.value === 'count');
            select.appendChild(option);
        });
        this.controls.set('metric', select);
        label.appendChild(select);
        wrapper.appendChild(label);
        return wrapper;
    }
    createLogScaleControl() {
        var _a;
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group';
        const label = document.createElement('label');
        const checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.id = 'sv-log-scale';
        checkbox.checked = ((_a = this.config.defaultValues) === null || _a === void 0 ? void 0 : _a.useLogScale) || false;
        const labelText = document.createElement('span');
        labelText.textContent = 'Use Log Scale';
        labelText.style.marginLeft = '5px';
        this.controls.set('logScale', checkbox);
        label.appendChild(checkbox);
        label.appendChild(labelText);
        wrapper.appendChild(label);
        return wrapper;
    }
    createRefreshButton() {
        const wrapper = document.createElement('div');
        wrapper.className = 'control-group';
        const button = document.createElement('button');
        button.type = 'button';
        button.textContent = 'Refresh';
        button.className = 'button button-primary';
        button.id = 'sv-refresh';
        this.controls.set('refresh', button);
        wrapper.appendChild(button);
        return wrapper;
    }
    setupEventListeners() {
        // Granularity change handler
        const granularitySelect = this.controls.get('granularity');
        if (granularitySelect) {
            granularitySelect.addEventListener('change', () => {
                this.toggleLimitVisibility();
                if (this.config.onFilterChange) {
                    this.config.onFilterChange(this.getCurrentFilters());
                }
            });
        }
        // Log scale checkbox - auto-refresh on change
        const logScaleCheckbox = this.controls.get('logScale');
        if (logScaleCheckbox) {
            logScaleCheckbox.addEventListener('change', () => {
                if (this.config.onFilterChange) {
                    this.config.onFilterChange(this.getCurrentFilters());
                }
                // Auto-refresh chart when log scale changes
                if (this.config.onRefresh) {
                    this.config.onRefresh();
                }
            });
        }
        // Filter change handlers for other controls
        this.controls.forEach((control, key) => {
            if (key !== 'refresh' && key !== 'logScale' && this.config.onFilterChange) {
                control.addEventListener('change', () => {
                    this.config.onFilterChange(this.getCurrentFilters());
                });
            }
        });
        // Refresh button handler
        const refreshButton = this.controls.get('refresh');
        if (refreshButton) {
            refreshButton.addEventListener('click', () => {
                if (this.config.onRefresh) {
                    this.config.onRefresh();
                }
            });
        }
    }
    toggleLimitVisibility() {
        const granularitySelect = this.controls.get('granularity');
        const limitWrapper = document.getElementById('limit-wrapper');
        if (granularitySelect && limitWrapper) {
            const showLimit = granularitySelect.value === 'by_content';
            limitWrapper.style.display = showLimit ? 'block' : 'none';
        }
    }
    addStyles() {
        const styleId = 'dashboard-controls-styles';
        if (document.getElementById(styleId))
            return;
        const style = document.createElement('style');
        style.id = styleId;
        style.textContent = `
      .dashboard-controls {
        background: #fff;
        border: 1px solid #ccd0d4;
        border-radius: 4px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 1px 1px rgba(0,0,0,.04);
      }

      .controls-form {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        align-items: end;
      }

      .control-group {
        display: flex;
        flex-direction: column;
        min-width: 120px;
      }

      .control-group label {
        font-weight: 600;
        margin-bottom: 5px;
        font-size: 13px;
        color: #23282d;
      }

      .control-group input,
      .control-group select {
        padding: 6px 8px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
        background: #fff;
      }

      .control-group input:focus,
      .control-group select:focus {
        border-color: #007cba;
        outline: none;
        box-shadow: 0 0 0 1px #007cba;
      }

      .button {
        display: inline-block;
        text-decoration: none;
        font-size: 13px;
        line-height: 2.15384615;
        min-height: 30px;
        margin: 0;
        padding: 0 10px;
        cursor: pointer;
        border-width: 1px;
        border-style: solid;
        border-radius: 3px;
        white-space: nowrap;
        box-sizing: border-box;
      }

      .button-primary {
        background: #007cba;
        border-color: #007cba;
        color: #fff;
      }

      .button-primary:hover {
        background: #005a87;
        border-color: #005a87;
      }

      @media (max-width: 768px) {
        .controls-form {
          flex-direction: column;
          align-items: stretch;
        }

        .control-group {
          min-width: auto;
        }
      }
    `;
        document.head.appendChild(style);
    }
    getDefaultStartDate() {
        return new Date(Date.now() - 30 * 24 * 60 * 60 * 1000).toISOString().slice(0, 10);
    }
    getDefaultEndDate() {
        return new Date().toISOString().slice(0, 10);
    }
    getCurrentFilters() {
        const startDateInput = this.controls.get('startDate');
        const endDateInput = this.controls.get('endDate');
        const granularitySelect = this.controls.get('granularity');
        const metricSelect = this.controls.get('metric');
        const limitInput = this.controls.get('limit');
        const logScaleCheckbox = this.controls.get('logScale');
        return {
            startDate: (startDateInput === null || startDateInput === void 0 ? void 0 : startDateInput.value) || this.getDefaultStartDate(),
            endDate: (endDateInput === null || endDateInput === void 0 ? void 0 : endDateInput.value) || this.getDefaultEndDate(),
            granularity: (granularitySelect === null || granularitySelect === void 0 ? void 0 : granularitySelect.value) === 'by_content' ? 'by_content' : 'daily',
            metric: (metricSelect === null || metricSelect === void 0 ? void 0 : metricSelect.value) || 'count',
            limit: (granularitySelect === null || granularitySelect === void 0 ? void 0 : granularitySelect.value) === 'by_content' ? Number(limitInput === null || limitInput === void 0 ? void 0 : limitInput.value) || 10 : undefined,
            useLogScale: (logScaleCheckbox === null || logScaleCheckbox === void 0 ? void 0 : logScaleCheckbox.checked) || false,
        };
    }
    setFilters(filters) {
        if (filters.startDate) {
            const startInput = this.controls.get('startDate');
            if (startInput)
                startInput.value = filters.startDate;
        }
        if (filters.endDate) {
            const endInput = this.controls.get('endDate');
            if (endInput)
                endInput.value = filters.endDate;
        }
        if (filters.granularity) {
            const granularitySelect = this.controls.get('granularity');
            if (granularitySelect) {
                granularitySelect.value = filters.granularity;
                this.toggleLimitVisibility();
            }
        }
        if (filters.metric) {
            const metricSelect = this.controls.get('metric');
            if (metricSelect)
                metricSelect.value = filters.metric;
        }
        if (filters.limit) {
            const limitInput = this.controls.get('limit');
            if (limitInput)
                limitInput.value = String(filters.limit);
        }
        if (filters.useLogScale !== undefined) {
            const logScaleCheckbox = this.controls.get('logScale');
            if (logScaleCheckbox)
                logScaleCheckbox.checked = filters.useLogScale;
        }
    }
    destroy() {
        this.container.innerHTML = '';
        this.controls.clear();
    }
}

/***/ }),

/***/ "./src/ui/form-reader.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   FormReader: () => ( FormReader)
 });
class FormReader {
    /**
     * Read filters from DOM elements - works as fallback when no controls are present
     * Attempts to read from common element IDs used in legacy implementations
     */
    static readFiltersFromDOM() {
        const startDateInput = FormReader.findElement("sv-start", "input[type='date']");
        const endDateInput = FormReader.findElement("sv-end", "input[type='date']");
        const granularitySelect = FormReader.findElement("sv-granularity", "select");
        const metricSelect = FormReader.findElement("sv-metric", "select");
        const limitInput = FormReader.findElement("sv-limit", "input[type='number']");
        const logScaleCheckbox = FormReader.findElement("sv-log-scale", "input[type='checkbox']");
        const granularity = granularitySelect === null || granularitySelect === void 0 ? void 0 : granularitySelect.value;
        const shouldIncludeLimit = granularity === "by_content";
        return {
            startDate: (startDateInput === null || startDateInput === void 0 ? void 0 : startDateInput.value) || FormReader.getDefaultStartDate(),
            endDate: (endDateInput === null || endDateInput === void 0 ? void 0 : endDateInput.value) || FormReader.getDefaultEndDate(),
            granularity: granularity === "by_content" ? "by_content" : "daily",
            metric: (metricSelect === null || metricSelect === void 0 ? void 0 : metricSelect.value) || "count",
            limit: shouldIncludeLimit ? (Number(limitInput === null || limitInput === void 0 ? void 0 : limitInput.value) || 10) : undefined,
            useLogScale: (logScaleCheckbox === null || logScaleCheckbox === void 0 ? void 0 : logScaleCheckbox.checked) || false,
        };
    }
    /**
     * Attempt to find an element by ID first, then by selector as fallback
     */
    static findElement(id, fallbackSelector) {
        let element = document.getElementById(id);
        if (!element && fallbackSelector) {
            element = document.querySelector(fallbackSelector);
        }
        return element;
    }
    /**
     * Check if the page has the expected form elements
     */
    static hasFormElements() {
        return Boolean(FormReader.findElement("sv-start", "input[type='date']") ||
            FormReader.findElement("sv-end", "input[type='date']") ||
            FormReader.findElement("sv-granularity", "select") ||
            FormReader.findElement("sv-metric", "select") ||
            FormReader.findElement("sv-log-scale", "input[type='checkbox']"));
    }
    /**
     * Set default values for form elements if they exist
     */
    static setDefaultValues(filters) {
        if (filters.startDate) {
            const startInput = FormReader.findElement("sv-start", "input[type='date']");
            if (startInput)
                startInput.value = filters.startDate;
        }
        if (filters.endDate) {
            const endInput = FormReader.findElement("sv-end", "input[type='date']");
            if (endInput)
                endInput.value = filters.endDate;
        }
        if (filters.granularity) {
            const granularitySelect = FormReader.findElement("sv-granularity", "select");
            if (granularitySelect)
                granularitySelect.value = filters.granularity;
        }
        if (filters.metric) {
            const metricSelect = FormReader.findElement("sv-metric", "select");
            if (metricSelect)
                metricSelect.value = filters.metric;
        }
        if (filters.limit) {
            const limitInput = FormReader.findElement("sv-limit", "input[type='number']");
            if (limitInput)
                limitInput.value = String(filters.limit);
        }
        if (filters.useLogScale !== undefined) {
            const logScaleCheckbox = FormReader.findElement("sv-log-scale", "input[type='checkbox']");
            if (logScaleCheckbox)
                logScaleCheckbox.checked = filters.useLogScale;
        }
    }
    static getDefaultStartDate() {
        return new Date(Date.now() - 30 * 24 * 60 * 60 * 1000)
            .toISOString()
            .slice(0, 10);
    }
    static getDefaultEndDate() {
        return new Date().toISOString().slice(0, 10);
    }
}

/***/ }),

/***/ "./src/ui/tooltip.ts":
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
 __webpack_require__.d(__webpack_exports__, {
   Tooltip: () => ( Tooltip)
 });
 var d3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/d3/src/index.js");

class Tooltip {
    constructor() {
        this.element = d3__WEBPACK_IMPORTED_MODULE_0__.select("body")
            .append("div")
            .attr("class", "chart-tooltip")
            .style("position", "absolute")
            .style("background-color", "white")
            .style("border", "1px solid #ddd")
            .style("padding", "8px")
            .style("border-radius", "4px")
            .style("pointer-events", "none")
            .style("opacity", 0)
            .style("font-size", "12px")
            .style("box-shadow", "0 2px 4px rgba(0,0,0,0.1)");
    }
    show(content, x, y) {
        this.element
            .html(content)
            .style("left", `${x + 15}px`)
            .style("top", `${y - 28}px`)
            .style("opacity", 0.9);
    }
    hide() {
        this.element.style("opacity", 0);
    }
    destroy() {
        this.element.remove();
    }
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"main": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = this["webpackChunkSQMViewsDashboard"] = this["webpackChunkSQMViewsDashboard"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["vendors"], () => (__webpack_require__("./src/index.ts")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	__webpack_exports__ = __webpack_exports__["default"];
/******/ 	
/******/ 	return __webpack_exports__;
/******/ })()
;
});