# SQM Views Plugin Build Targets
# Included from main Makefile

.PHONY: views-build views-build-dev views-rebuild \
	views-clean views-clean-artifacts \
	views-dist views-dist-install views-release \
	views-process build-pot

views-build: ## Build sqm-views dependencies (was: sqm-views-build)
	@echo "Building sqm-views plugin dependencies..."
	@if [ ! -f sqm-views/vendor/autoload.php ]; then \
		echo "Installing composer dependencies..."; \
		cd sqm-views && composer install --no-dev --optimize-autoloader --no-interaction; \
		echo "✅ sqm-views dependencies installed"; \
	else \
		echo "✅ sqm-views/vendor/autoload.php already exists. Use 'make views-rebuild' to force rebuild."; \
	fi

views-build-dev: ## Build with dev dependencies (was: sqm-views-dev-build)
	echo "Building sqm-views plugin dependencies...";
	cd sqm-views && composer install --optimize-autoloader --no-interaction;

views-rebuild: views-clean views-clean-artifacts views-build ## Force rebuild, clean + install (was: sqm-views-rebuild)

views-clean: wp-chmod ## Remove vendor directory (was: sqm-views-clean)
	@echo "Cleaning sqm-views vendor directory..."
	@if [ -d sqm-views/vendor ]; then \
		rm -rf sqm-views/vendor; \
		echo "✅ sqm-views/vendor removed"; \
	else \
		echo "✅ sqm-views/vendor already clean"; \
	fi

views-clean-artifacts: ## Clean artifacts directory (was: sqm-views-clean-artifacts)
	@echo "Cleaning sqm-views artifacts directory..."
	@if [ -d sqm-views/artifacts ]; then \
		rm -rf sqm-views/artifacts/*; \
		echo "✅ sqm-views/artifacts removed"; \
	else \
		echo "✅ sqm-views/artifacts already clean"; \
	fi

views-dist: views-rebuild ## Build production plugin zip (was: sqm-views-dist-build)
	cd sqm-views && ls -lah
	cd sqm-views && ./build-plugin.sh

views-dist-install: wp-chmod ## Install built plugin to WordPress (was: sqm-views-dist-install)
	@echo "Installing sqm-views from dist build..."
	@if [ ! -d sqm-views/dist ]; then \
		echo "❌ Dist directory not found. Run 'make views-dist' first"; \
		exit 1; \
	fi
	@PLUGIN_ZIP=$$(ls -t sqm-views/dist/sqm-views-*.zip 2>/dev/null | head -1); \
	if [ -z "$$PLUGIN_ZIP" ]; then \
		echo "❌ No plugin zip found in sqm-views/dist/"; \
		exit 1; \
	fi; \
	echo "Found: $$PLUGIN_ZIP"; \
	echo "Removing old plugin from wordpress/wp-content/plugins/sqm-views..."; \
	mkdir -p wordpress/wp-content/plugins; \
	docker run --rm -v $(PWD)/wordpress/wp-content/plugins:/data alpine sh -c "rm -rf /data/sqm-views/*"; \
	docker run --rm -v $(PWD)/wordpress/wp-content/plugins:/data alpine sh -c "chmod a+rwX /data/sqm-views/"; \
	echo "Copying plugin zip to container..."; \
	$(COMPOSE) cp -a "$$PLUGIN_ZIP" wordpress:/tmp/sqm-views.zip; \
	echo "Extracting inside container with correct permissions..."; \
	$(COMPOSE) exec -T -u www-data wordpress bash -c "cd /var/www/html/wp-content/plugins && unzip -q -o /tmp/sqm-views.zip"; \
	$(COMPOSE) exec -T wordpress rm /tmp/sqm-views.zip  ; \
	echo "✅ Plugin installed successfully"

views-release: views-clean-artifacts ## Build complete release package (was: sqm-views-release-build)
	@echo "🚀 Building complete release package..."
	@echo "📦 Building JavaScript tracker..."
	cd js-tracker && npm install && npm run build
	@echo "📊 Building dashboard..."
	cd dashboard && npm install && npm run build
	@echo "🔨 Building plugin distribution..."
	cd sqm-views && ./build-plugin.sh
	@echo ""
	@echo "✅ Release build complete!"
	@echo "📁 Plugin zip: sqm-views/dist/sqm-views-*.zip"
	@ls -lh sqm-views/dist/
	@echo ""
	@echo "🔐 SHA256 checksum:"
	@cat sqm-views/dist/*.sha256

views-process: ## Run event processing, cron (was: sqm-cli-process)
	$(COMPOSE) exec -u www-data wordpress wp sqm-views process --verbose

build-pot: wp-chmod ## Generate POT file for translations (was: build-pot)
	@echo "Generating POT file for translations..."
	$(COMPOSE) exec -u www-data wordpress wp i18n make-pot /var/www/html/wp-content/plugins/sqm-views /var/www/html/wp-content/plugins/sqm-views/languages/sqm-views.pot
	@echo "✅ POT file generated at sqm-views/languages/sqm-views.pot" || true
