# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).


## v1.0.5 - 2025-02-19
### Changed
* prepare drop table statement in db teardown

## v1.0.4 - 2025-02-19
### Added
* data dir to blacklist
* information about data populating to readme
### Changed
* activation and deactivation hook manipulate the db through DbDelta instead of executing sql scripts
### Removed
* schema creation from seed script

## v1.0.3 - 2025-02-18
### Changed
* increment version in readme and relevant files

## v1.0.2 - 2025-02-18
### Added
* composer files to blacklist

## v1.0.1 - 2025-02-18
### Added
* LICENSE file
* prepare script. blacklist for files that can't be submitted to wordpress registry. package json scripts for testing, development, and release prep
* prepared all query statements
* check for abspath in hooks file to prevent direct access
### Changed
* updated readme to comply with wp standards
* refactored several features to accomodate advice from the all powerful plugin checker plugin
* adjust blacklist and remove block registration action since I am not using the custom block yet
* renamed index.php to spenpo-resume.php
* updated composer dependencies
* removed duplicate register_setting. added sanitize_callback to api auth setting
* exclude all test files from wp registry build
* throw wp error if version is incompatible
* prefixed all function names, namespaces, defines, class and option names with spcv
### Removed
* several unnecessary files from source control

## v1.0.0 - 2024-11-21
### Added
* seed.sql script that creates the resume tables and is executed against the database as an initialization hook by executeScript function
* shortcode that creates and renders a DOMDocument with the resume content. styled via style.css
* api endpoint that returns resume content as json for consumers
* teardown script for dropping tables when uninstalling the plugin
* admin dashboard with auth switch for REST API endpoint
* generated documentation readme and error handling
* unit test suite in /tests
* setup composer and phpunit
* base integration test
### Changed
* added $type param to executeScript function to choose between dbDelta() and $wpdb->query()
* refactored repository pattern to abstract specific code into classes
* refactored the api to use the singleton pattern and serve the json and the REST route separately. now all consumers including the plugin shortcode are serviced by the same function fetchResume.
* implemented reusable createElement function for DOM manipulation across the resume shortcode
* Added mandatory and optional display order fields to all tables
* Madd all class names generic and appended unique identifiers to class names in id attribute
* moved teardown function to uninstall hook
* slight changes to some classes for testability. added namespaces to all classes
### Fixed
* logical bug with $type param in executeScript funtion
