<?php
/**
 * Uninstall handler for SpamScrubber.
 *
 * Deletes all plugin options on single and multisite installs.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

$option_keys = array(
	'spamscrubber_delay_seconds',
	'spamscrubber_disabled_click_count',
	'spamscrubber_early_submit_count',
	'spamscrubber_njs_spam_count',
	'spamscrubber_error_page_url',
	'spamscrubber_honeypot_count',
	'spamscrubber_remote_spam_count',
	'spamscrubber_exclude_ids',
	'spamscrubber_honeypot_enabled',
	'spamscrubber_honeypot_field',
);

if ( is_multisite() ) {
	$site_ids = get_sites( array( 'fields' => 'ids' ) );

	foreach ( $site_ids as $site_id ) {
		switch_to_blog( $site_id );

		foreach ( $option_keys as $key ) {
			delete_option( $key );
		}

		// Clear rewrite rules for this site.
		if ( function_exists( 'flush_rewrite_rules' ) ) {
			flush_rewrite_rules();
		}

		restore_current_blog();
	}
} else {
	foreach ( $option_keys as $key ) {
		delete_option( $key );
	}

	// Clear rewrite rules on single site.
	if ( function_exists( 'flush_rewrite_rules' ) ) {
		flush_rewrite_rules();
	}
}
