jQuery(function ($) {
  var CFG = window.SpamScrubberData || {};
  var FORMS = $('form[data-spamscrubber-action]');

  FORMS.each(function () {
    var $form = $(this);

    // Restore real action set by PHP obfuscator
    var realAction = $form.attr('data-spamscrubber-action');
    $form.attr('action', realAction && realAction !== '' ? realAction : window.location.href);

    // Insert anti-spam JS token
    if (CFG.js_token && $form.find('input[name="spamscrubber_js_token"]').length === 0) {
      $form.append('<input type="hidden" name="spamscrubber_js_token" value="' + String(CFG.js_token) + '">');
    }

    // Find submit controls
    var $submit = $form.find('input[type="submit"], button:not([type="button"])');
    if ($submit.length === 0) return;

    // Accessibility helpers
    function setDisabledState() {
      $submit.addClass('spamscrubber-disabled');
      $submit.prop('disabled', false); // stay clickable for counting, styled/flagged as disabled
      $submit.attr('aria-disabled', 'true');
      $submit.attr('tabindex', '-1');
    }
    function setEnabledState() {
      $submit.removeClass('spamscrubber-disabled');
      $submit.removeAttr('aria-disabled');
      $submit.removeAttr('tabindex');
    }

    setDisabledState();

    var originalText = $submit.first().is('button') ? $submit.first().text() : $submit.first().val();
    var delay = parseInt(CFG.delay || 4, 10);
    if (!isFinite(delay) || delay < 1) delay = 4;

    var counter = delay;
    var allowSubmit = false;
    var spamClickReported = false;
    var spamSubmitReported = false;

    function updateSubmitLabel(txt) {
      $submit.each(function () {
        if ($(this).is('button')) $(this).text(txt);
        else $(this).val(txt);
      });
    }

    // Disabled button click = "disabled submit button clicks"
    $submit.on('click.spamscrubber', function (e) {
      if ($(this).hasClass('spamscrubber-disabled')) {
        e.preventDefault();
        if (!spamClickReported) {
          spamClickReported = true;
          reportSpamClick();
        }
        return false;
      }
    });

    // Early form submit = "early form submit attempts"
    $form.on('submit.spamscrubber', function (e) {
      if (!allowSubmit) {
        e.preventDefault();
        if (!spamSubmitReported) {
          spamSubmitReported = true;
          reportSpamSubmit();
        }
        return false;
      } else {
        spamClickReported = false;
        spamSubmitReported = false;
      }
    });

    // Countdown logic
    updateSubmitLabel(originalText + ' (' + counter + ')');
    var interval = setInterval(function () {
      counter--;
      var shown = counter > 0 ? counter : 0;
      updateSubmitLabel(originalText + ' (' + shown + ')');

      if (counter <= 0) {
        clearInterval(interval);
        setEnabledState();
        updateSubmitLabel(originalText);
        allowSubmit = true;
      }
    }, 1000);

    // Reset handler
    $form.on('reset.spamscrubber', function () {
      setDisabledState();
      counter = delay;
      allowSubmit = false;
      clearInterval(interval);
      updateSubmitLabel(originalText + ' (' + counter + ')');
      interval = setInterval(function () {
        counter--;
        var shown = counter > 0 ? counter : 0;
        updateSubmitLabel(originalText + ' (' + shown + ')');
        if (counter <= 0) {
          clearInterval(interval);
          setEnabledState();
          updateSubmitLabel(originalText);
          allowSubmit = true;
        }
      }, 1000);

      spamClickReported = false;
      spamSubmitReported = false;
    });

    // --- Reporting helpers ---
    function canAjax() {
      return !!(CFG.ajax_url && CFG.nonce);
    }
    function reportSpamClick() {
      if (!canAjax()) return;
      $.post(CFG.ajax_url, {
        action: 'spamscrubber_disabled_click',
        nonce: CFG.nonce
      });
    }
    function reportSpamSubmit() {
      if (!canAjax()) return;
      $.post(CFG.ajax_url, {
        action: 'spamscrubber_early_submit',
        nonce: CFG.nonce
      });
    }
  });
});
