<?php
/**
 * @wordpress-plugin
 * Plugin Name: Spamex
 * Plugin URI:  https://successmedia.online/wordpress-plugins/spamex
 * Description: Shortcode [email address="name@domain.tld" key="geheim"] or [email phone="+49!123!456"], obfuscates E-Mails and Phone numbers, to protect them from spam bots.
 * Version:     1.6.3
 * Author:      SuccessMedia
 * Author URI: https://successmedia.online
 * License:     GPLv2 or later
 * Text Domain: spamex
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Shortcode-Logik
add_shortcode( 'spamex', function ( $atts, $content, $shortcode_name ) {
	$atts = shortcode_atts(
		array(
			'email' => '',
			'phone'   => '',
			'key'     => 'proudly',
		),
		$atts,
		$shortcode_name
	);

	// E-Mail-Verarbeitung
	if ( ! empty( $atts['email'] ) ) {
		return spamex_email_output( $atts['email'], $atts['key'] );
	}

	// Telefon-Verarbeitung
	if ( ! empty( $atts['phone'] ) ) {
		return spamex_phone_output( $atts['phone'] );
	}

	return '';
});

// E-Mail-Ausgabe
function spamex_email_output( $email, $key ) {
	$email = sanitize_email( $email );
	$key   = sanitize_text_field( $key );

	if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
		return '';
	}

	$email_parts = explode( '@', $email );
	if ( count( $email_parts ) !== 2 ) {
		return esc_html( $email );
	}
	list( $name, $domain ) = $email_parts;

	$domain_parts = explode( '.', $domain );

	if ( count( $domain_parts ) < 2 ) {
		return esc_html( $email );
	}

	$tld = array_pop( $domain_parts );
	$main_domain = implode( '.', $domain_parts );

	return sprintf(
		'<span class="email">%s@%s<b>.%s</b>.%s</span>',
		esc_html( $name ),
		esc_html( $main_domain ),
		esc_html( $key ),
		esc_html( $tld )
	);
}

// Telefon-Ausgabe
function spamex_phone_output( $phone ) {
	$phone = sanitize_text_field( $phone );

	// Prüfen, ob das Format mit zwei "!" passt
	$parts = explode( '!', $phone );

	if ( count( $parts ) !== 3 ) {
		return esc_html( str_replace( '!', '', $phone ) ); // Fallback, wenn Format nicht stimmt
	}

	list( $prefix, $middle, $suffix ) = $parts;

	// Zufallsziffern generieren (Länge des Suffix)
	$random_digits = spamex_generate_random_digits( strlen( $middle ) );

	// Zusammensetzen der Ausgabe
	$output = sprintf(
		'<span class="phone">%s%s<b>%s</b>%s</span>',
		esc_html( $prefix ),
		esc_html( $middle ),
		esc_html( $random_digits ),
		esc_html( $suffix )
	);

	return $output;
}

// Zufallsziffern generieren
function spamex_generate_random_digits( $length ) {
	$digits = '';
	for ( $i = 0; $i < $length; $i++ ) {
		$digits .= wp_rand( 0, 9 );
	}
	return $digits;
}

// CSS im Customizer hinzufügen
function spamex_add_custom_css() {
	$css_code = "span.email b, span.phone b {\n\tdisplay: none;\n}";

	// Aktuelles Custom CSS abrufen
	$custom_css = wp_get_custom_css() ?: ''; // Falls null, dann leerer String


	// Prüfen, ob der CSS-Code bereits vorhanden ist
	if ( strpos( $custom_css, $css_code ) === false ) {
		$new_css = $custom_css . "\n/* Spamex Mail & Phone Antispam CSS */\n" . $css_code;
		wp_update_custom_css_post( $new_css );
	}
}

function spamex_header_comment() {
	$plugin_data = get_file_data(__FILE__, ['Version' => 'Version']);
	$version = isset($plugin_data['Version']) ? esc_attr($plugin_data['Version']) : 'unknown';

	echo sprintf(
		"<!-- This site uses SPAMEX v%s - %s -->\n",
		esc_html($version),
		esc_url('https://successmedia.online/wordpress-plugins/spamex')
	);
}

add_action('wp_head', 'spamex_header_comment');
register_activation_hook( __FILE__, 'spamex_add_custom_css' );
