<?php
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.

 * @package    Sort_Options_Label_Editor_For_WooCommerce
 * @subpackage Sort_Options_Label_Editor_For_WooCommerce/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Sort_Options_Label_Editor_For_WooCommerce
 * @subpackage Sort_Options_Label_Editor_For_WooCommerce/includes
 * @author     Vinod<https://profiles.wordpress.org/vinodkudavoor/>
 */
class SOL_Editor_Activator {

    /**
     * Activate the plugin.
     *
     * Sets up default options during activation, including 'hide' status for sorting options.
     * Merges with existing options if any, to avoid overwriting user settings on re-activation.
     *
     * @since    1.0.0
     */
    public static function activate() {
        // Set up default options during activation, including 'hide' status
        $default_options = array(
            'menu_order'      => '', // Leave blank to use WooCommerce default for label
            'menu_order_hide' => 'no',
            'popularity'      => '',
            'popularity_hide' => 'no',
            'rating'          => '',
            'rating_hide'     => 'no',
            'date'            => '',
            'date_hide'       => 'no',
            'price'           => '',
            'price_hide'      => 'no',
            'price-desc'      => '',
            'price-desc_hide' => 'no',
        );

        // Merge with existing options if any, to avoid overwriting user settings on re-activation
        $existing_options = get_option( 'sol_editor_options', array() ); // Use the new option name
        update_option( 'sol_editor_options', wp_parse_args( $existing_options, $default_options ) );
    }
}