<?php
/**
 * All Licences
 *
 * Shows All Licences on the account page.
 */

defined( 'ABSPATH' ) || exit;

global $SOLIW;

do_action( 'woocommerce_before_account_all_licences', $licences ); ?>

<?php if ( $licences ) { ?>

    <table class="woocommerce-licences-table my_account_orders woocommerce-MyAccount-licences shop_table shop_table_responsive my_account_licences account-licences-table">
        <thead>
            <tr>
                <th class="licence-id order-number woocommerce-orders-table__header woocommerce-orders-table__header-order-number woocommerce-orders-table__header-id"><span class="nobr"><?php esc_html_e( 'ID', 'software-license-lite' ); ?></span></th>
                <th class="licence-id order-number woocommerce-orders-table__header woocommerce-orders-table__header-order-number woocommerce-orders-table__header-type"><span class="nobr"><?php esc_html_e( 'Type', 'software-license-lite' ); ?></span></th>
                <th class="licence-status order-status woocommerce-orders-table__header woocommerce-orders-table__header-order-status woocommerce-orders-table__header-licence-status"><span class="nobr"><?php esc_html_e( 'Licence Status', 'software-license-lite' ); ?></span></th>
                <th class="licence-total order-total woocommerce-orders-table__header woocommerce-orders-table__header-order-total woocommerce-orders-table__header-licence-total"><span class="nobr"><?php echo esc_html_x( 'Actions', 'table heading', 'software-license-lite' ); ?></span></th>
            </tr>
        </thead>

        <tbody>
            <?php
            foreach ( $licences as $licence_data ) 
                {
                    $order          =   wc_get_order( $licence_data->order_id );
                    $license_status =   $SOLIW->functions->get_licence_status( $licence_data->order_item_id);
                    ?>
                    <tr class="woocommerce-licences-table__row woocommerce-licences-table__row order">

                            <td class="woocommerce-licences-table__cell woocommerce-licences-table__cell-order-number" data-title="Order">
                                    <a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
                                        <?php echo esc_html( _x( '#', 'hash before order number', 'software-license-lite' ) . $order->get_order_number() ); ?>
                                    </a>
                            </td>
                            
                            <td class="woocommerce-licences-table__cell woocommerce-licences-table__cell-order-number" data-title="<?php echo esc_html_x( 'Type', 'label for type selector', 'software-license-lite' ); ?>">
                                    <?php
                                        
                                        $type   =   __( 'Order', 'software-license-lite' );   
                                        
                                        $type   =   ucwords( str_replace( array ( "-", "_" ), " ", $order->get_type() ) );
                                            
                                        echo esc_html ( $type );
                                    
                                    ?>
                            </td>

                            <td class="woocommerce-licences-table__cell woocommerce-licences-table__cell-licence-status" data-title="<?php echo esc_html_x( 'Licence Status', 'label for license status', 'software-license-lite' ); ?>">
                                    <?php echo esc_html( ucfirst( $license_status ) ); ?>
                            </td>


                            <td class="woocommerce-licences-table__cell woocommerce-licences-table__cell-order-number" data-title="<?php esc_html_e( 'Actions', 'software-license-lite' ); ?>">
                                    <?php
                                        
                                        $text   =   apply_filters('woo_sl/html/button/license_manage', __('License Manage', 'software-license-lite'));
                                        echo '<a href="' . esc_html( $SOLIW->functions->get_licence_manage_url( $order->get_id() ) ) . '" class="woocommerce-button button">' . esc_html ( $text ). '</a>';
                                        
                                    ?>
                                    <a href="<?php echo esc_url( $order->get_view_order_url() ) ?>" class="woocommerce-button button view"><?php esc_html_e( 'View ', 'software-license-lite' ) .  str_replace( "Shop", "", $type ); ?></a>
                            </td>
              
                    </tr>
                    <?php
                }
            ?>
        </tbody>
    </table>

    <?php do_action( 'woocommerce_before_account_all_licences_pagination' ); ?>

    <?php if ( 1 < $max_num_pages ) : ?>
        <div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination">
        <?php if ( 1 !== $current_page ) : ?>
            <a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button" href="<?php echo esc_url( wc_get_endpoint_url( 'license-manage', $current_page - 1 ) ); ?>"><?php esc_html_e( 'Previous', 'software-license-lite' ); ?></a>
        <?php endif; ?>

        <?php if ( intval( $max_num_pages ) !== $current_page ) : ?>
            <a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button" href="<?php echo esc_url( wc_get_endpoint_url( 'license-manage', $current_page + 1 ) ); ?>"><?php esc_html_e( 'Next', 'software-license-lite' ); ?></a>
        <?php endif; ?>
        </div>
    <?php endif; ?>

<?php  } else { ?>
    <div class="woocommerce-message woocommerce-message--info woocommerce-Message woocommerce-Message--info woocommerce-info">
        <a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>"><?php esc_html_e( 'Browse products', 'software-license-lite' ); ?></a>
        <?php esc_html_e( 'No Licence is available at the moment.', 'software-license-lite' ); ?>
    </div>
<?php } ?>

<?php do_action( 'woocommerce_after_account_all_licences', $licences ); ?> 