<?php
    
    defined( 'ABSPATH' ) || exit;
    
    /**
    * License Manage Page
    */

	global $software_license, $SOLIW_FRONT;
        
    do_action( 'woo_sl/template/before_my_license_management' );
    
    wc_print_notices();
    
    $order_data     = new WC_Order($software_license);
    
    $order_products =   $order_data->get_items();

	?>
    <p class="order-info"><?php esc_html_e ( 'Order', 'software-license-lite' ) ?> #<mark class="order-number"><?php 
            // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
            esc_html ( $order_data->get_order_number() ) ?></mark> <?php esc_html_e ( 'was placed on', 'software-license-lite' ) ?> <mark class="order-date"><?php 
            // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
            echo esc_html ( wc_format_datetime( $order_data->get_date_created() ) ) ?></mark> <?php esc_html_e ( 'and is currently', 'software-license-lite' ) ?> <mark class="order-status"><?php echo esc_html ( wc_get_order_status_name( $order_data->get_status() ) ) ?>.</mark></p>
        
    <div id="soliw_lk" class="postbox "><div class="inside">
        <h2><?php esc_html_e( 'My Order License Keys', 'software-license-lite' ); ?></h2>
	    <?php 
            
            foreach ( $order_products as $order_item_id     =>  $order_product ) 
                {
			        //check if the product use licensed software
                    if(! SOLIW_functions::is_product_licensed($order_product->get_product_id()))
                        continue;
                    
                    ?>
                        <h4><?php echo esc_html ( $order_product['name'] ) ?></h4>
                        
                        <?php do_action( 'woo_sl/template/product/licence_data',  $order_data->get_id(), $order_item_id); ?>
                        
                        <?php
                        
                            $order_licence_details =   SOLIW_functions::get_order_licence_details( $order_data->get_id() );
                            $order_item_licence_details =   isset($order_licence_details[$order_item_id])   ?   $order_licence_details[$order_item_id]  :   array();
                            foreach ($order_item_licence_details as $licence_group_id   =>  $product_licence_data)
                                {
                                    if($order_item_id   !=  $product_licence_data->order_item_id)
                                        continue;
                                        
                                    ?>
                                        <p class="woo-sl-label"><?php echo esc_html ( $product_licence_data->license_data['group_title'] );
                                        
                                        $max_instances_per_key =   $product_licence_data->license_data['max_instances_per_key'];
                                        
                                        if ( $max_instances_per_key < 0 )
                                            $max_instances_per_key  =   __( 'Unlimited', 'software-license-lite' );
                                            else
                                            $max_instances_per_key  =   (int)$max_instances_per_key;
                                    
                                        $instances      =   ' - ';
                                        if ( is_int( $max_instances_per_key ) )
                                            {
                                                $instances .= sprintf(
                                                    /* translators: %s: The number of domains. */
                                                    _n(
                                                        '%s domain',
                                                        '%s domains',
                                                        $max_instances_per_key,
                                                        'software-license-lite'
                                                    ),
                                                    $max_instances_per_key
                                                );
                                            }
                                        $instances     .=   ' ' . __( 'per key', 'software-license-lite' );
                                        
                                        $status         =   wc_get_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'active');
                                        $instances     .=   ' <br />'. __( 'Status', 'software-license-lite' ) .' <b><mark class="order-status">' . ucfirst( $status ) . '</mark></b>';
                                        
                                        $expiration_timestamp   =   SOLIW_functions::get_order_item_meta( $order_item_id ,  '_woo_sl_licensing_expire_at',  TRUE );
                                        $expiration_timestamp = '1884263836';
                                        if( $expiration_timestamp > 0 && $order_data->get_status() ==  'completed' ) 
                                            {
                                                $instances     .=   ' <br />'. __( 'Expire Date', 'software-license-lite' ) .' <b><mark id="exp_local_time" data-timestamp="' .  $expiration_timestamp . '"></mark></b>';        
                                            }
                                         
                                        $allowed_tags = array(
                                                                'br'     => array(),
                                                                'mark'   => array(
                                                                    'class' => array(),
                                                                    'id'    => array(),
                                                                    'data-timestamp'    =>  array(),
                                                                ),
                                                                'b'      => array(),
                                                                'script' => array(
                                                                    'type' => array(),
                                                                ),
                                                            );
                                        
                                        echo wp_kses ( apply_filters('woo_sl/html/max_instances_per_key', $instances, $product_licence_data->order_item_id, $licence_group_id), $allowed_tags );
                                        
                                        ?></p>
                                        <table id="woo-sl-keys_<?php echo esc_attr ( $product_licence_data->order_item_id ) ?>_<?php echo esc_attr ( $product_licence_data->group_id ) ?>" data-order_item_id="<?php echo esc_attr ( $product_licence_data->order_item_id ) ?>" data-group_id="<?php echo esc_attr ( $product_licence_data->group_id ) ?>" class="shop_table my_account_software_license my_account_orders software_license_keys">
                                        <thead>
                                            <tr>
                                                <th class="woo-sl-key header"><span class="nobr"><?php esc_html_e( 'License Key', 'software-license-lite' ); ?></span></th>
                                                <th class="woo-sl-status header"><span class="nobr"><?php esc_html_e( 'Status', 'software-license-lite' ); ?></span></th>
                                                <th class="woo-sl-domain header"><span class="nobr"><?php esc_html_e( 'Domain', 'software-license-lite' ); ?></span></th>
                                                <th class="woo-sl-action header"><span class="nobr"><?php esc_html_e( 'Action', 'software-license-lite' ); ?></span></th>
                                            </tr>
                                        </thead>
                                        
                                        <tbody>
                                            <?php
                                                        
                                                $license_keys   =   SOLIW_functions::get_order_product_generated_keys($order_data->get_id(), $order_item_id, $product_licence_data->group_id);
                                                SOLIW_functions::interface_licence_block($license_keys);
                                            
                                            ?>
                                        </tbody>
                                        </table>
                                      <?php   
                                }
                }
                 
        ?>
    </div></div>

    
    <div id="soliw_lg" class="postbox "><div class="inside">
    
        <h2><?php esc_html_e( 'Key Generator', 'software-license-lite' ); ?></h2>
        
        <table id="woo-sl-key-generator" class="my_account_software_license my_account_orders software_license_key_generator">
            <tbody>  
                <tr>
                    <td align="left">
                        
                        <ul id="sl_generator_desc" class="order_details">
                            <li class="group">
                                <?php esc_html_e("Group", 'software-license-lite') ?>:<strong></strong>
                            </li>
                            <li class="max_keys">
                                <?php esc_html_e("Max Keys", 'software-license-lite') ?>:<strong></strong>
                            </li>
                            <li class="instances_per_key">
                                <?php esc_html_e("Instances per key", 'software-license-lite') ?>:<strong></strong>
                            </li>
                            <li class="in_use_keys">
                                <?php esc_html_e("In use keys", 'software-license-lite') ?>:<strong></strong>
                            </li>
                        </ul>
                        
                        <p><?php 
                        
                            $allowed_tags = array(
                                                'select'   => array(
                                                    'onchange'      => array(),
                                                    'name'   => array(),
                                                    'id'     => array()
                                                ),
                                                'option'      => array(
                                                    'data-description-group'     => array(),
                                                    'data-description-max-keys'     => array(),
                                                    'data-description-instances-per-keys'     => array(),
                                                    'data-description-in-use-keys'     => array(),
                                                    'disabled'     => array(),
                                                    'value'     => array(),
                                                        ),
                                                'b'      => array(),
                                            );
                            
                            echo wp_kses ( SOLIW_functions::interface_get_sl_product_select($order_licence_details), $allowed_tags);
                        
                        ?></p>
                         
                        <a href="javascript: void(0)" onClick="soliw.keyGenerate('<?php echo esc_js ( wp_create_nonce( 'woo_sl/key-generator' ) ) ?>')" name="submit" class="button button_generate"><?php esc_html_e("Generate Licence Key", 'software-license-lite') ?></a>
                    </td>
                </tr>
            </tbody>
        </table>
    
    </div></div>

<?php  do_action( 'woo_sl/template/after_my_license_management' ); ?>