<?php
/**
 * Licence expire email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/licence-expired.php
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

echo "= " . esc_html ( $email_heading ) . " =\n\n";

echo sprintf(
        /* translators: %s: the product name */
        esc_html__( 'Hello, this is a system automated message to inform you the licence for the %s product has expired.', 'software-license-lite' ),
        sprintf(
            '<strong>%s</strong>',
            esc_html ( $order_item['name'] )
        )
    );
echo "\n\n";

echo sprintf(
        /* translators: %s: the link for renewal */
        esc_html__( 'Please take action and extend your licence %s', 'software-license-lite' ),
        sprintf(
            '<a href="%1$s">%2$s</a>',
            esc_html( $extend_link ),
            esc_html__( 'here', 'software-license-lite' )
        )
    );

echo "\n\n";

echo esc_html__( "For your reference, your order details are shown below.", 'software-license-lite' ) . "\n\n";

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/**
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Emails::order_schema_markup() Adds Schema.org markup.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/**
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/**
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

echo esc_html ( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
